/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.Appia;
import net.sf.appia.core.AppiaCursorException;
import net.sf.appia.core.AppiaDuplicatedSessionsException;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaInvalidQoSException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.ChannelCursor;
import net.sf.appia.core.Layer;
import net.sf.appia.core.QoS;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteLayer;
import org.vanilladb.comm.client.ClientNodeFailListener;
import org.vanilladb.comm.client.ClientP2pMessageListener;
import org.vanilladb.comm.messages.ChannelType;
import org.vanilladb.comm.messages.NodeFailListener;
import org.vanilladb.comm.messages.P2pMessage;
import org.vanilladb.comm.messages.P2pMessageListener;
import org.vanilladb.comm.protocols.serverClientAppl.ServerClientApplLayer;
import org.vanilladb.comm.protocols.serverClientAppl.ServerClientApplSession;
import org.vanilladb.comm.protocols.tcpBasedPFD.PFDStartEvent;
import org.vanilladb.comm.protocols.tcpBasedPFD.TcpBasedPFDLayer;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;
import org.vanilladb.comm.server.ServerAppl;

public class ClientAppl
extends Thread
implements P2pMessageListener,
NodeFailListener {
    private final boolean IS_STANDALONE_SEQUENCER;
    private Channel clientChannel;
    private String serverView;
    private String clientView;
    private ProcessSet clientParticipatedProcessSet;
    private int selfId;
    private int leaderId;
    private ClientP2pMessageListener cP2pMListener;
    private ClientNodeFailListener nfListener;

    public ClientAppl(int selfId, ClientP2pMessageListener cP2pMListener, ClientNodeFailListener nfListener) {
        block16: {
            this.leaderId = 0;
            if (cP2pMListener == null || nfListener == null) {
                throw new IllegalArgumentException("Must implement TotalOrderedMessageListener and P2pMessageListener");
            }
            this.selfId = selfId;
            this.cP2pMListener = cP2pMListener;
            this.nfListener = nfListener;
            String path = System.getProperty("org.vanilladb.comm.config.file");
            if (path != null) {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(path);
                        System.getProperties().load(fis);
                    }
                    catch (IOException iOException) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException2) {}
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.serverView = System.getProperty(String.valueOf(ServerAppl.class.getName()) + ".SERVER_VIEW");
        this.clientView = System.getProperty(String.valueOf(ClientAppl.class.getName()) + ".CLIENT_VIEW");
        String prop = System.getProperty(String.valueOf(ServerAppl.class.getName()) + ".STAND_ALONE_SEQUENCER");
        this.IS_STANDALONE_SEQUENCER = prop != null ? Boolean.parseBoolean(prop) : false;
    }

    @Override
    public void run() {
        ProcessSet dbServerProcessSet = this.buildProcessSet(this.serverView, this.selfId);
        ProcessSet clientProcessSet = this.buildProcessSet(this.clientView, this.selfId);
        this.leaderId = this.IS_STANDALONE_SEQUENCER ? dbServerProcessSet.getSize() - 1 : 0;
        ProcessSet ps = new ProcessSet();
        int i = 0;
        while (i < dbServerProcessSet.getSize()) {
            ps.addProcess(new SampleProcess(dbServerProcessSet.getProcess(i).getSocketAddress(), i, false), i);
            ++i;
        }
        i = 0;
        while (i < clientProcessSet.getAllProcesses().length) {
            ps.addProcess(new SampleProcess(clientProcessSet.getProcess(i).getSocketAddress(), dbServerProcessSet.getSize() + i, i == this.selfId), dbServerProcessSet.getSize() + i);
            ++i;
        }
        this.clientParticipatedProcessSet = ps;
        this.clientChannel = this.getServerClientChannel(this.clientParticipatedProcessSet);
        try {
            this.clientChannel.start();
        }
        catch (AppiaDuplicatedSessionsException e) {
            e.printStackTrace();
        }
        Logger.getLogger(ClientAppl.class.getName()).info("Starting Appia...");
        Appia.run();
    }

    public void sendRequest(Object[] req) {
        P2pMessage p2pm = new P2pMessage(req, this.leaderId, ChannelType.CLIENT);
        this.sendP2pMessage(p2pm);
    }

    public void sendP2pMessage(P2pMessage c) {
        if (Logger.getLogger(ClientAppl.class.getName()).isLoggable(Level.FINE)) {
            Logger.getLogger(ClientAppl.class.getName()).fine("Client " + this.selfId + " sends message to server " + c.getReceiver());
        }
        try {
            SendableEvent ev = new SendableEvent();
            ev.getMessage().pushObject((Object)c);
            ev.source = this.clientParticipatedProcessSet.getSelfProcess().getSocketAddress();
            ev.dest = this.clientParticipatedProcessSet.getProcess(c.getReceiver()).getSocketAddress();
            ev.setSourceSession(null);
            ev.asyncGo(this.clientChannel, -1);
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    public void startPFD() {
        PFDStartEvent pfdStart = new PFDStartEvent();
        try {
            pfdStart.asyncGo(this.clientChannel, -1);
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onNodeFail(int id, ChannelType group, Channel channel) {
        this.nfListener.onNodeFail(id, group);
    }

    @Override
    public void onRecvP2pMessage(P2pMessage p2pm) {
        if (Logger.getLogger(ClientAppl.class.getName()).isLoggable(Level.FINE)) {
            Logger.getLogger(ClientAppl.class.getName()).fine("Client " + this.selfId + " receives message from server ");
        }
        this.cP2pMListener.onRecvClientP2pMessage(p2pm);
    }

    private ProcessSet buildProcessSet(String str, int selfProc) {
        String[] machines;
        ProcessSet set = new ProcessSet();
        String[] stringArray = machines = str.split(",");
        int n = machines.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            try {
                StringTokenizer st = new StringTokenizer(m);
                if (st.countTokens() != 3) {
                    Logger.getLogger(ClientAppl.class.getName()).severe("Wrong line in file: " + st.countTokens());
                } else {
                    int procNumber = Integer.parseInt(st.nextToken());
                    InetAddress addr = InetAddress.getByName(st.nextToken());
                    int portNumber = Integer.parseInt(st.nextToken());
                    boolean self = procNumber == selfProc;
                    SampleProcess process = new SampleProcess(new InetSocketAddress(addr, portNumber), procNumber, self);
                    set.addProcess(process, procNumber);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
        return set;
    }

    private Channel getServerClientChannel(ProcessSet processes) {
        Layer[] qos = new Layer[]{new TcpCompleteLayer(), new TcpBasedPFDLayer(), new ServerClientApplLayer()};
        QoS myQoS = null;
        try {
            myQoS = new QoS("ServerClient QoS for client -1", qos);
        }
        catch (AppiaInvalidQoSException ex) {
            Logger.getLogger(ClientAppl.class.getName()).severe("Invalid QoS");
            Logger.getLogger(ClientAppl.class.getName()).severe(ex.getMessage());
            System.exit(1);
        }
        Channel channel = myQoS.createUnboundChannel("ServerClient channel for client -1");
        ServerClientApplSession sas = (ServerClientApplSession)qos[qos.length - 1].createSession();
        sas.init(processes, this, this, true);
        ChannelCursor cc = channel.getCursor();
        try {
            cc.top();
            cc.setSession((Session)sas);
        }
        catch (AppiaCursorException ex) {
            Logger.getLogger(ClientAppl.class.getName()).severe("Unexpected exception in main. Type code:" + ex.type);
            System.exit(1);
        }
        return channel;
    }
}

