/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.basicPaxos;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.protocols.consensusUtils.PaxosProposal;
import org.vanilladb.comm.protocols.consensusUtils.TimestampValue;
import org.vanilladb.comm.protocols.events.Nack;
import org.vanilladb.comm.protocols.events.PaxosPropose;
import org.vanilladb.comm.protocols.events.PaxosReturn;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.events.Read;
import org.vanilladb.comm.protocols.events.ReadAck;
import org.vanilladb.comm.protocols.events.Write;
import org.vanilladb.comm.protocols.events.WriteAck;
import org.vanilladb.comm.protocols.utils.ProcessSet;

public class BasicPaxosConsensusSession
extends Session {
    private ProcessSet correct = null;
    private Set<TimestampValue> readSet = null;
    private PaxosProposal tempValue = null;
    private PaxosProposal val = null;
    private long tstamp = 0L;
    private long rts = 0L;
    private long wts = 0L;
    private int wAcks = 0;

    public BasicPaxosConsensusSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof ProcessInitEvent) {
            this.handleProcessInit((ProcessInitEvent)event);
        } else if (event instanceof PaxosPropose) {
            this.handlePaxosPropose((PaxosPropose)event);
        } else if (event instanceof Read) {
            this.handleRead((Read)event);
        } else if (event instanceof Nack) {
            this.handleNack((Nack)event);
        } else if (event instanceof ReadAck) {
            this.handleReadAck((ReadAck)event);
        } else if (event instanceof Write) {
            this.handleWrite((Write)event);
        } else if (event instanceof WriteAck) {
            this.handleWriteAck((WriteAck)event);
        } else {
            try {
                event.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void init() {
        this.tempValue = new PaxosProposal();
        this.val = new PaxosProposal();
        this.val.abort = true;
        this.tempValue.abort = true;
        this.wts = 0L;
        this.rts = 0L;
        this.wAcks = 0;
        this.tstamp = this.correct.getSelfRank();
        this.readSet = new HashSet<TimestampValue>();
    }

    private void handleProcessInit(ProcessInitEvent event) {
        this.correct = event.getProcessSet();
        this.init();
        try {
            event.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handlePaxosPropose(PaxosPropose pp) {
        this.tstamp += (long)this.correct.getSize();
        this.tempValue = pp.value;
        try {
            Read ev = new Read(pp.getChannel(), -1, this);
            ev.getMessage().pushLong(this.tstamp);
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleRead(Read read) {
        long ts = read.getMessage().popLong();
        if (this.rts >= ts || this.wts >= ts) {
            try {
                Nack ev = new Nack(read.getChannel(), -1, this);
                ev.source = this.correct.getSelfProcess().getSocketAddress();
                ev.dest = read.source;
                ev.setSourceSession(this);
                ev.init();
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        } else {
            this.rts = ts;
            try {
                ReadAck ev = new ReadAck(read.getChannel(), -1, this);
                ev.getMessage().pushLong(this.wts);
                ev.getMessage().pushObject((Object)this.val);
                ev.source = this.correct.getSelfProcess().getSocketAddress();
                ev.dest = read.source;
                ev.setSourceSession(this);
                ev.init();
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void handleNack(Nack nack) {
        try {
            PaxosReturn ev = new PaxosReturn(nack.getChannel(), 1, this);
            this.tempValue.abort = true;
            ev.decision = this.tempValue;
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleReadAck(ReadAck ra) {
        PaxosProposal v = (PaxosProposal)ra.getMessage().popObject();
        long ts = ra.getMessage().popLong();
        TimestampValue tsv = new TimestampValue(ts, v);
        this.readSet.add(tsv);
        this.readDecide(ra.getChannel());
    }

    private void readDecide(Channel channel) {
        if (this.readSet.size() > this.correct.getSize() / 2) {
            TimestampValue highest = Collections.max(this.readSet);
            if (!highest.getPaxosProposal().abort) {
                this.tempValue = highest.getPaxosProposal();
                try {
                    Write ev = new Write(channel, -1, this);
                    ev.getMessage().pushLong(this.tstamp);
                    ev.getMessage().pushObject((Object)this.tempValue);
                    ev.go();
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void handleWrite(Write write) {
        PaxosProposal v = (PaxosProposal)write.getMessage().popObject();
        long ts = write.getMessage().popLong();
        if (this.rts >= ts || this.wts >= ts) {
            try {
                Nack ev = new Nack(write.getChannel(), -1, this);
                ev.source = this.correct.getSelfProcess().getSocketAddress();
                ev.dest = write.source;
                ev.setSourceSession(this);
                ev.init();
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        } else {
            this.wts = ts;
            this.val = v;
            try {
                WriteAck ev = new WriteAck(write.getChannel(), -1, this);
                ev.source = this.correct.getSelfProcess().getSocketAddress();
                ev.dest = write.source;
                ev.setSourceSession(this);
                ev.init();
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void handleWriteAck(WriteAck wa) {
        ++this.wAcks;
        this.writeDecide(wa.getChannel());
    }

    private void writeDecide(Channel channel) {
        if (this.wAcks > this.correct.getSize() / 2) {
            this.readSet.clear();
            this.wAcks = 0;
            try {
                PaxosReturn ev = new PaxosReturn(channel, 1, this);
                this.tempValue.abort = false;
                ev.decision = this.tempValue;
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }
}

