/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.consensusUTO;

import org.vanilladb.comm.protocols.consensusUtils.Proposal;
import org.vanilladb.comm.protocols.utils.Debug;

public class OrderProposal
extends Proposal {
    private static final long serialVersionUID = -8495751662017937316L;
    byte[] bytes;

    public OrderProposal(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public int compareTo(Proposal other) {
        int LESS = -1;
        boolean EQUAL = false;
        boolean GREATER = true;
        byte[] bytes_other = ((OrderProposal)other).bytes;
        int curPos_this = 0;
        int curPos_other = 0;
        int nElem_this = this.byteArrayToInt(this.bytes, curPos_this);
        curPos_this += 4;
        int nElem_other = this.byteArrayToInt(bytes_other, curPos_other);
        curPos_other += 4;
        if (nElem_this < nElem_other) {
            Debug.print("COMPARE: " + nElem_this + "<" + nElem_other);
            return 1;
        }
        if (nElem_other < nElem_this) {
            Debug.print("COMPARE: " + nElem_other + "<" + nElem_this);
            return -1;
        }
        for (int g = 0; g < nElem_this; ++g) {
            int seq_this = this.byteArrayToInt(this.bytes, curPos_this);
            curPos_this += 4;
            int seq_other = this.byteArrayToInt(bytes_other, curPos_other);
            curPos_other += 4;
            curPos_this += this.byteArrayToInt(this.bytes, curPos_this) + 4;
            curPos_other += this.byteArrayToInt(bytes_other, curPos_other) + 4;
            int port_this = this.byteArrayToInt(this.bytes, curPos_this);
            int port_other = this.byteArrayToInt(bytes_other, curPos_other);
            String host_this = new String(this.bytes, (curPos_this += 4) + 4, this.byteArrayToInt(this.bytes, curPos_this));
            curPos_this += this.byteArrayToInt(this.bytes, curPos_this) + 4;
            String host_other = new String(bytes_other, (curPos_other += 4) + 4, this.byteArrayToInt(bytes_other, curPos_other));
            curPos_other += this.byteArrayToInt(bytes_other, curPos_other) + 4;
            curPos_this += this.byteArrayToInt(this.bytes, curPos_this) + 4;
            curPos_other += this.byteArrayToInt(bytes_other, curPos_other) + 4;
            if (host_this.compareTo(host_other) < 0) {
                return -1;
            }
            if (host_other.compareTo(host_this) < 0) {
                return 1;
            }
            if (port_this < port_other) {
                return -1;
            }
            if (port_other < port_this) {
                return 1;
            }
            if (seq_this < seq_other) {
                return -1;
            }
            if (seq_other >= seq_this) continue;
            return 1;
        }
        return 0;
    }

    float averageSeq(OrderProposal op) {
        int seqCounter = 0;
        int curPos = 0;
        int nElem = this.byteArrayToInt(this.bytes, curPos);
        curPos += 4;
        for (int k = 0; k < nElem; ++k) {
            seqCounter += this.byteArrayToInt(this.bytes, curPos);
            curPos += 4;
            curPos += this.byteArrayToInt(this.bytes, curPos) + 4;
            curPos += 4;
            curPos += this.byteArrayToInt(this.bytes, curPos) + 4;
            curPos += this.byteArrayToInt(this.bytes, curPos) + 4;
        }
        return seqCounter / nElem;
    }

    float averagePort(OrderProposal op) {
        int portCounter = 0;
        int curPos = 0;
        int nElem = this.byteArrayToInt(this.bytes, curPos);
        curPos += 4;
        for (int k = 0; k < nElem; ++k) {
            curPos += 4;
            curPos += this.byteArrayToInt(this.bytes, curPos) + 4;
            portCounter += this.byteArrayToInt(this.bytes, curPos);
            curPos += 4;
            curPos += this.byteArrayToInt(this.bytes, curPos) + 4;
            curPos += this.byteArrayToInt(this.bytes, curPos) + 4;
        }
        return portCounter / nElem;
    }

    int byteArrayToInt(byte[] b, int off) {
        int ret = 0;
        ret |= b[off] << 24;
        ret |= b[off + 1] << 24 >>> 8;
        ret |= b[off + 2] << 24 >>> 16;
        return ret |= b[off + 3] << 24 >>> 24;
    }
}

