/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.floodingConsensus;

import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.HashSet;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.protocols.consensusUtils.Proposal;
import org.vanilladb.comm.protocols.events.ConsensusDecide;
import org.vanilladb.comm.protocols.events.ConsensusPropose;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.floodingConsensus.DecidedEvent;
import org.vanilladb.comm.protocols.floodingConsensus.MySetEvent;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;

public class FloodingConsensusSession
extends Session {
    private int round = 0;
    private ProcessSet correct = null;
    private Proposal decided = null;
    private HashSet<SampleProcess>[] correct_this_round = null;
    private HashSet<Proposal>[] proposal_set = null;
    private int count_decided;
    public static final boolean debugFull = false;
    private PrintStream debug = System.out;

    public FloodingConsensusSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof ProcessInitEvent) {
            this.handleProcessInit((ProcessInitEvent)event);
        } else if (event instanceof Crash) {
            this.handleCrash((Crash)event);
        } else if (event instanceof ConsensusPropose) {
            this.handleConsensusPropose((ConsensusPropose)event);
        } else if (event instanceof MySetEvent) {
            this.handleMySet((MySetEvent)event);
        } else if (event instanceof DecidedEvent) {
            this.handleDecided((DecidedEvent)event);
        } else {
            this.debug("Unwanted event received, ignoring.");
            try {
                event.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void init() {
        int max_rounds = this.correct.getSize() + 1;
        this.correct_this_round = new HashSet[max_rounds];
        this.proposal_set = new HashSet[max_rounds];
        int i = 0;
        while (i < max_rounds) {
            this.correct_this_round[i] = new HashSet();
            this.proposal_set[i] = new HashSet();
            ++i;
        }
        i = 0;
        while (i < this.correct.getSize()) {
            SampleProcess p = this.correct.getProcess(i);
            if (p.isCorrect()) {
                this.correct_this_round[0].add(p);
            }
            ++i;
        }
        this.round = 1;
        this.decided = null;
        this.count_decided = 0;
    }

    private void handleProcessInit(ProcessInitEvent event) {
        this.correct = event.getProcessSet();
        this.init();
        try {
            event.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleCrash(Crash crash) {
        this.correct.setCorrect(crash.getCrashedProcess(), false);
        try {
            crash.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        this.decide(crash.getChannel());
    }

    private void handleConsensusPropose(ConsensusPropose propose) {
        this.proposal_set[this.round].add(propose.value);
        try {
            MySetEvent ev = new MySetEvent(propose.getChannel(), -1, this);
            ev.getMessage().pushObject(this.proposal_set[this.round]);
            ev.getMessage().pushInt(this.round);
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        this.decide(propose.getChannel());
    }

    private void handleMySet(MySetEvent event) {
        SampleProcess p_i = this.correct.getProcess((SocketAddress)event.source);
        int r = event.getMessage().popInt();
        HashSet set = (HashSet)event.getMessage().popObject();
        this.correct_this_round[r].add(p_i);
        this.proposal_set[r].addAll(set);
        this.decide(event.getChannel());
    }

    private void decide(Channel channel) {
        Object ev;
        this.debugAll("decide");
        if (this.decided != null) {
            return;
        }
        int i = 0;
        while (i < this.correct.getSize()) {
            SampleProcess p = this.correct.getProcess(i);
            if (p != null && p.isCorrect() && !this.correct_this_round[this.round].contains(p)) {
                return;
            }
            ++i;
        }
        if (this.correct_this_round[this.round].equals(this.correct_this_round[this.round - 1])) {
            for (Proposal proposal : this.proposal_set[this.round]) {
                if (this.decided == null) {
                    this.decided = proposal;
                    continue;
                }
                if (proposal.compareTo(this.decided) >= 0) continue;
                this.decided = proposal;
            }
            try {
                ev = new ConsensusDecide(channel, 1, this);
                ev.decision = this.decided;
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
            try {
                ev = new DecidedEvent(channel, -1, this);
                ev.getMessage().pushObject((Object)this.decided);
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        } else {
            ++this.round;
            this.proposal_set[this.round].addAll(this.proposal_set[this.round - 1]);
            try {
                ev = new MySetEvent(channel, -1, this);
                ev.getMessage().pushObject(this.proposal_set[this.round]);
                ev.getMessage().pushInt(this.round);
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
            this.count_decided = 0;
        }
    }

    private void handleDecided(DecidedEvent event) {
        Object ev;
        if (++this.count_decided >= this.correctSize() && this.decided != null) {
            this.init();
            return;
        }
        if (this.decided != null) {
            return;
        }
        SampleProcess p_i = this.correct.getProcess((SocketAddress)event.source);
        if (!p_i.isCorrect()) {
            return;
        }
        this.decided = (Proposal)event.getMessage().popObject();
        try {
            ev = new ConsensusDecide(event.getChannel(), 1, this);
            ev.decision = this.decided;
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        try {
            ev = new DecidedEvent(event.getChannel(), -1, this);
            ev.getMessage().pushObject((Object)this.decided);
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        this.round = 0;
    }

    private int correctSize() {
        int size = 0;
        SampleProcess[] processes = this.correct.getAllProcesses();
        int i = 0;
        while (i < processes.length) {
            if (processes[i] != null && processes[i].isCorrect()) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private void debug(String s) {
    }

    private void debugAll(String s) {
    }
}

