/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.serverClientAppl;

import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelClose;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.protocols.common.RegisterSocketEvent;
import org.vanilladb.comm.messages.ChannelType;
import org.vanilladb.comm.messages.NodeFailListener;
import org.vanilladb.comm.messages.P2pMessage;
import org.vanilladb.comm.messages.P2pMessageListener;
import org.vanilladb.comm.messages.TotalOrderMessage;
import org.vanilladb.comm.messages.TotalOrderedMessageListener;
import org.vanilladb.comm.protocols.events.BroadcastEvent;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.utils.ProcessSet;

public class ServerClientApplSession
extends Session {
    private Channel channel;
    private P2pMessageListener p2pMessageListener;
    private NodeFailListener nflistener;
    private ProcessSet processes;
    private boolean registerSocket;
    private TotalOrderedMessageListener tomListener;

    public ServerClientApplSession(Layer layer) {
        super(layer);
    }

    public void init(ProcessSet processes, P2pMessageListener p2pMessageListener, NodeFailListener nflistener, boolean registerSocket) {
        this.processes = processes;
        this.p2pMessageListener = p2pMessageListener;
        this.registerSocket = registerSocket;
        this.nflistener = nflistener;
    }

    public void init(ProcessSet processes, TotalOrderedMessageListener tomListener, P2pMessageListener p2pMessageListener, NodeFailListener nflistener, boolean registerSocket) {
        this.processes = processes;
        this.p2pMessageListener = p2pMessageListener;
        this.registerSocket = registerSocket;
        this.nflistener = nflistener;
        this.tomListener = tomListener;
    }

    public void handle(Event event) {
        if (event instanceof BroadcastEvent) {
            this.handleBroadcastEvent((BroadcastEvent)event);
        } else if (event instanceof SendableEvent) {
            this.handleSendableEvent((SendableEvent)event);
        } else if (event instanceof Crash) {
            this.handleCrashEvent((Crash)event);
        } else if (event instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)event);
        } else if (event instanceof ChannelClose) {
            this.handleChannelClose((ChannelClose)event);
        } else if (event instanceof RegisterSocketEvent) {
            this.handleRegisterSocket((RegisterSocketEvent)event);
        }
    }

    private void handleBroadcastEvent(BroadcastEvent event) {
        if (event.getDir() == 1) {
            this.tomListener.onRecvTotalOrderedMessage((TotalOrderMessage)event.getMessage().popObject());
        } else {
            try {
                event.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleSendableEvent(SendableEvent event) {
        if (event.getDir() == 1) {
            Object o = event.getMessage().popObject();
            if (o instanceof P2pMessage) {
                this.p2pMessageListener.onRecvP2pMessage((P2pMessage)o);
            }
        } else {
            try {
                event.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleCrashEvent(Crash event) {
        int crashedProcess = event.getCrashedProcess();
        if (crashedProcess == this.processes.getSize() - 1) {
            this.nflistener.onNodeFail(event.getCrashedProcess(), ChannelType.CLIENT, event.getChannel());
        } else {
            this.nflistener.onNodeFail(crashedProcess, ChannelType.SERVER, event.getChannel());
        }
    }

    private void handleRegisterSocket(RegisterSocketEvent event) {
        if (event.error) {
            if (Logger.getLogger(ServerClientApplSession.class.getName()).isLoggable(Level.SEVERE)) {
                Logger.getLogger(ServerClientApplSession.class.getName()).severe("Address already in use!");
            }
            System.exit(2);
        }
    }

    private void handleChannelInit(ChannelInit init) {
        try {
            init.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        this.channel = init.getChannel();
        try {
            if (this.registerSocket) {
                RegisterSocketEvent rse = new RegisterSocketEvent(this.channel, -1, (Session)this);
                rse.port = ((InetSocketAddress)this.processes.getSelfProcess().getSocketAddress()).getPort();
                rse.localHost = ((InetSocketAddress)this.processes.getSelfProcess().getSocketAddress()).getAddress();
                rse.go();
            }
            ProcessInitEvent processInit = new ProcessInitEvent(this.channel, -1, this);
            processInit.setProcessSet(this.processes);
            processInit.go();
        }
        catch (AppiaEventException e1) {
            e1.printStackTrace();
        }
        if (Logger.getLogger(ServerClientApplSession.class.getName()).isLoggable(Level.INFO)) {
            Logger.getLogger(ServerClientApplSession.class.getName()).info("Channel is open.");
        }
    }

    private void handleChannelClose(ChannelClose close) {
        this.channel = null;
        if (Logger.getLogger(ServerClientApplSession.class.getName()).isLoggable(Level.INFO)) {
            Logger.getLogger(ServerClientApplSession.class.getName()).info("Channel is closed.");
        }
    }
}

