/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.tcpBasedPFD;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.protocols.tcpcomplete.TcpUndeliveredEvent;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.tcpBasedPFD.CreateChannelsEvent;
import org.vanilladb.comm.protocols.tcpBasedPFD.PFDStartEvent;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;

public class TcpBasedPFDSession
extends Session {
    private Channel channel;
    private Map<Channel, ProcessSet> cpMap = new HashMap<Channel, ProcessSet>();
    private ProcessSet processes;
    private boolean started = false;

    public TcpBasedPFDSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof TcpUndeliveredEvent) {
            this.notifyCrash((TcpUndeliveredEvent)event);
        } else if (event instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)event);
        } else if (event instanceof ProcessInitEvent) {
            this.handleProcessInit((ProcessInitEvent)event);
        } else if (event instanceof PFDStartEvent) {
            this.handlePFDStart((PFDStartEvent)event);
        }
    }

    private void handleChannelInit(ChannelInit init) {
        this.channel = init.getChannel();
        try {
            init.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleProcessInit(ProcessInitEvent event) {
        this.processes = event.getProcessSet();
        this.cpMap.put(event.getChannel(), this.processes);
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handlePFDStart(PFDStartEvent event) {
        this.started = true;
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        SampleProcess[] processArray = this.processes.getAllProcesses();
        for (int i = 0; i < processArray.length; ++i) {
            try {
                CreateChannelsEvent createChannels = new CreateChannelsEvent(this.channel, -1, this);
                createChannels.source = this.processes.getSelfProcess().getSocketAddress();
                createChannels.dest = processArray[i].getSocketAddress();
                createChannels.setSourceSession(this);
                if (i == this.processes.getSelfRank()) continue;
                createChannels.init();
                createChannels.go();
                continue;
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void notifyCrash(TcpUndeliveredEvent event) {
        if (this.started) {
            for (Channel c : this.cpMap.keySet()) {
                SampleProcess p = this.cpMap.get(c).getProcess((SocketAddress)event.getFailedAddress());
                if (p == null || !p.isCorrect()) continue;
                Logger.getLogger(TcpBasedPFDSession.class.getName()).severe("Process " + p.getProcessNumber() + " in channel " + c.getChannelID() + " failed. Source session: " + (event.getSourceSession() == null ? "null" : event.getSourceSession().toString()));
                p.setCorrect(false);
                try {
                    Crash crash = new Crash(c, 1, this, p.getProcessNumber());
                    crash.go();
                }
                catch (AppiaEventException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

