/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.utils;

import java.io.Serializable;
import java.net.SocketAddress;
import org.vanilladb.comm.protocols.utils.SampleProcess;

public class ProcessSet
implements Serializable {
    private static final long serialVersionUID = -8520712350015155147L;
    SampleProcess[] processes;
    private int self;

    public ProcessSet(int n) {
        this.processes = new SampleProcess[n];
    }

    public ProcessSet() {
        this.processes = new SampleProcess[0];
    }

    public SampleProcess[] getAllProcesses() {
        return this.processes;
    }

    public int getSize() {
        return this.processes.length;
    }

    public int getRank(SocketAddress addr) {
        for (int i = 0; i < this.processes.length; ++i) {
            if (this.processes[i] == null || !this.processes[i].getSocketAddress().equals(addr)) continue;
            return i;
        }
        return -1;
    }

    public void addProcess(SampleProcess process, int pr) {
        if (pr >= this.processes.length) {
            SampleProcess[] temp = new SampleProcess[this.processes.length + 1];
            for (int i = 0; i < this.processes.length; ++i) {
                temp[i] = this.processes[i];
            }
            this.processes = temp;
        }
        this.processes[pr] = process;
        if (process.isSelf()) {
            this.self = pr;
        }
    }

    public void setCorrect(int proc, boolean correct) {
        this.processes[proc].setCorrect(correct);
    }

    public SampleProcess getProcess(int i) {
        return this.processes[i];
    }

    public SampleProcess getProcess(SocketAddress addr) {
        int i = this.getRank(addr);
        if (i == -1) {
            return null;
        }
        return this.processes[i];
    }

    public int getSelfRank() {
        return this.self;
    }

    public SampleProcess getSelfProcess() {
        return this.processes[this.self];
    }

    public ProcessSet cloneProcessSet() {
        ProcessSet set = new ProcessSet(this.getSize());
        SampleProcess[] procs = this.getAllProcesses();
        for (int i = 0; i < procs.length; ++i) {
            set.addProcess(procs[i].cloneProcess(), i);
        }
        set.self = this.self;
        return set;
    }
}

