/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class Profiler
implements Runnable {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final int INTERVAL;
    private static final int DEPTH;
    private static final int MAX_PACKAGES;
    private static final int MAX_METHODS;
    private static final int MAX_LINES;
    private static final String[] IGNORE_THREADS;
    private static final String[] IGNORE_PACKAGES;
    private Thread thread;
    private boolean started;
    private boolean paused;
    private long time;
    private long pauseTime;
    private CountMap<String> packages;
    private CountMap<String> selfMethods;
    private CountMap<String> stackMethods;
    private CountMap<String> lines;
    private int total;

    public synchronized void startCollecting() {
        this.paused = false;
        if (this.thread != null) {
            return;
        }
        this.packages = new CountMap(MAX_PACKAGES);
        this.selfMethods = new CountMap(MAX_METHODS);
        this.stackMethods = new CountMap(MAX_METHODS);
        this.lines = new CountMap(MAX_LINES);
        this.total = 0;
        this.started = true;
        this.thread = new Thread(this);
        this.thread.setName("Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stopCollecting() {
        this.started = false;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    public synchronized void pauseCollecting() {
        this.paused = true;
    }

    @Override
    public void run() {
        this.time = System.nanoTime();
        while (this.started) {
            try {
                this.tick();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break;
            }
        }
        this.time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.time);
    }

    private void tick() {
        long ts = System.nanoTime();
        if (INTERVAL > 0) {
            try {
                Thread.sleep(INTERVAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.paused) {
            this.pauseTime += TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ts);
            return;
        }
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] trace;
            Thread t = entry.getKey();
            if (t.getState() != Thread.State.RUNNABLE || (trace = entry.getValue()) == null || trace.length == 0 || Profiler.startsWithAny(trace[0].toString(), IGNORE_THREADS)) continue;
            boolean relevant = this.tickPackages(trace);
            this.tickMethods(trace);
            this.tickLines(trace);
            if (!relevant) continue;
            ++this.total;
        }
    }

    private boolean tickPackages(StackTraceElement[] trace) {
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement el = trace[i];
            if (Profiler.startsWithAny(el.getClassName(), IGNORE_PACKAGES)) continue;
            String packageName = Profiler.getPackageName(el);
            this.packages.increment(packageName);
            return true;
        }
        return false;
    }

    private void tickMethods(StackTraceElement[] trace) {
        boolean self = true;
        StackTraceElement last = null;
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement el = trace[i];
            if (Profiler.startsWithAny(el.getClassName(), IGNORE_PACKAGES) || last != null && el.getClassName().equals(last.getClassName()) && el.getMethodName().equals(last.getMethodName())) continue;
            last = el;
            String methodName = Profiler.getMethodName(el);
            if (self) {
                this.selfMethods.increment(methodName);
                self = false;
            }
            this.stackMethods.increment(methodName);
        }
    }

    private void tickLines(StackTraceElement[] trace) {
        StringBuilder buff = new StringBuilder();
        StackTraceElement last = null;
        int j = 0;
        for (int i = 0; i < trace.length && j < DEPTH; ++i) {
            StackTraceElement el = trace[i];
            if (last != null && el.getClassName().equals(last.getClassName()) && el.getMethodName().equals(last.getMethodName())) continue;
            if (!Profiler.startsWithAny(el.getClassName(), IGNORE_PACKAGES)) {
                if (last == null) {
                    buff.append(el.toString()).append("+").append(LINE_SEPARATOR);
                } else if (Profiler.startsWithAny(last.getClassName(), IGNORE_PACKAGES)) {
                    buff.append(last.toString()).append(LINE_SEPARATOR);
                    buff.append(el.toString()).append("+").append(LINE_SEPARATOR);
                } else {
                    buff.append(el.toString()).append(LINE_SEPARATOR);
                }
                ++j;
            }
            last = el;
        }
        if (buff.length() > 0) {
            this.lines.increment(buff.toString().trim());
        }
    }

    private static boolean startsWithAny(String s, String[] prefixes) {
        for (String p : prefixes) {
            if (p.length() <= 0 || !s.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private static String getPackageName(StackTraceElement el) {
        String className = el.getClassName();
        int ci = className.lastIndexOf(46);
        if (ci > 0) {
            return className.substring(0, ci);
        }
        throw new IllegalArgumentException();
    }

    private static String getMethodName(StackTraceElement el) {
        return el.getClassName() + "." + el.getMethodName();
    }

    public String getTopPackages(int num) {
        this.stopCollecting();
        CountMap<String> pkgs = new CountMap<String>(this.packages);
        StringBuilder buff = new StringBuilder();
        buff.append("Top packages over ").append(this.time).append(" ms (").append(this.pauseTime).append(" ms paused), with ").append(this.total).append(" counts:").append(LINE_SEPARATOR);
        buff.append("Rank\tSelf\tPackage").append(LINE_SEPARATOR);
        int i = 0;
        int n = 0;
        while (pkgs.size() > 0 && n < num) {
            int highest = 0;
            ArrayList bests = new ArrayList();
            for (Map.Entry el : pkgs.entrySet()) {
                if ((Integer)el.getValue() > highest) {
                    bests.clear();
                    bests.add(el);
                    highest = (Integer)el.getValue();
                    continue;
                }
                if ((Integer)el.getValue() != highest) continue;
                bests.add(el);
            }
            for (Map.Entry e : bests) {
                pkgs.remove(e.getKey());
                int percent = 100 * highest / Math.max(this.total, 1);
                buff.append(i + 1).append("\t").append(percent).append("%\t").append((String)e.getKey()).append(LINE_SEPARATOR);
                ++n;
            }
            ++i;
        }
        return buff.toString();
    }

    public String getPackageCsv() {
        this.stopCollecting();
        StringBuilder buff = new StringBuilder();
        buff.append("Package,Self").append(LINE_SEPARATOR);
        for (String k : new TreeSet(this.packages.keySet())) {
            int percent = 100 * (Integer)this.packages.get(k) / Math.max(this.total, 1);
            buff.append(k).append(",").append(percent).append(LINE_SEPARATOR);
        }
        return buff.toString();
    }

    public String getTopMethods(int num) {
        this.stopCollecting();
        CountMap<String> selfms = new CountMap<String>(this.selfMethods);
        CountMap<String> stackms = new CountMap<String>(this.stackMethods);
        StringBuilder buff = new StringBuilder();
        buff.append("Top methods over ").append(this.time).append(" ms (").append(this.pauseTime).append(" ms paused), with ").append(this.total).append(" counts:").append(LINE_SEPARATOR);
        buff.append("Rank\tSelf\tStack\tMethod").append(LINE_SEPARATOR);
        int i = 0;
        int n = 0;
        while (selfms.size() > 0 && n < num) {
            int highest = 0;
            ArrayList bests = new ArrayList();
            for (Map.Entry el : selfms.entrySet()) {
                if ((Integer)el.getValue() > highest) {
                    bests.clear();
                    bests.add(el);
                    highest = (Integer)el.getValue();
                    continue;
                }
                if ((Integer)el.getValue() != highest) continue;
                bests.add(el);
            }
            for (Map.Entry e : bests) {
                selfms.remove(e.getKey());
                int selfPercent = 100 * highest / Math.max(this.total, 1);
                int stackPercent = 100 * (Integer)stackms.remove(e.getKey()) / Math.max(this.total, 1);
                buff.append(i + 1).append("\t").append(selfPercent).append("%\t").append(stackPercent).append("%\t").append((String)e.getKey()).append(LINE_SEPARATOR);
                ++n;
            }
            ++i;
        }
        return buff.toString();
    }

    public String getMethodCsv() {
        this.stopCollecting();
        StringBuilder buff = new StringBuilder();
        buff.append("Method,Self").append(LINE_SEPARATOR);
        for (String k : new TreeSet(this.selfMethods.keySet())) {
            int percent = 100 * (Integer)this.selfMethods.get(k) / Math.max(this.total, 1);
            buff.append(k).append(",").append(percent).append(LINE_SEPARATOR);
        }
        return buff.toString();
    }

    public String getTopLines(int num) {
        this.stopCollecting();
        CountMap<String> ls = new CountMap<String>(this.lines);
        StringBuilder buff = new StringBuilder();
        buff.append("Top lines over ").append(this.time).append(" ms (").append(this.pauseTime).append(" ms paused), with ").append(this.total).append(" counts:").append(LINE_SEPARATOR);
        int i = 0;
        int n = 0;
        while (ls.size() > 0 && n < num) {
            int highest = 0;
            ArrayList bests = new ArrayList();
            for (Map.Entry el : ls.entrySet()) {
                if ((Integer)el.getValue() > highest) {
                    bests.clear();
                    bests.add(el);
                    highest = (Integer)el.getValue();
                    continue;
                }
                if ((Integer)el.getValue() != highest) continue;
                bests.add(el);
            }
            for (Map.Entry e : bests) {
                ls.remove(e.getKey());
                int percent = 100 * highest / Math.max(this.total, 1);
                buff.append("Rank: ").append(i + 1).append(", Self: ").append(percent).append("%, Trace: ").append(LINE_SEPARATOR).append((String)e.getKey()).append(LINE_SEPARATOR);
                ++n;
            }
            ++i;
        }
        return buff.toString();
    }

    static {
        String prop = System.getProperty(Profiler.class.getName() + ".INTERVAL");
        INTERVAL = prop == null ? 3 : Integer.parseInt(prop.trim());
        prop = System.getProperty(Profiler.class.getName() + ".DEPTH");
        DEPTH = prop == null ? 4 : Integer.parseInt(prop.trim());
        prop = System.getProperty(Profiler.class.getName() + ".MAX_PACKAGES");
        MAX_PACKAGES = prop == null ? 100 : Integer.parseInt(prop.trim());
        prop = System.getProperty(Profiler.class.getName() + ".MAX_METHODS");
        MAX_METHODS = prop == null ? 1000 : Integer.parseInt(prop.trim());
        prop = System.getProperty(Profiler.class.getName() + ".MAX_LINES");
        MAX_LINES = prop == null ? 1000 : Integer.parseInt(prop.trim());
        prop = System.getProperty(Profiler.class.getName() + ".IGNORE_THREADS");
        IGNORE_THREADS = prop != null ? prop.trim().split(",") : new String[]{"java.lang.Thread.dumpThreads", "java.lang.Thread.getThreads", "java.net.PlainSocketImpl.socketAccept", "java.net.SocketInputStream.socketRead0", "java.net.SocketOutputStream.socketWrite0", "java.lang.UNIXProcess.waitForProcessExit", "java.lang.Object.wait", "java.lang.Thread.sleep", "un.awt.windows.WToolkit.eventLoop", "sun.misc.Unsafe.park", "dalvik.system.VMStack.getThreadStackTrace", "dalvik.system.NativeStart.run"};
        prop = System.getProperty(Profiler.class.getName() + ".IGNORE_PACKAGES");
        IGNORE_PACKAGES = prop != null ? prop.trim().split(",") : new String[]{"java.", "javax.", "sun."};
    }

    private class CountMap<K>
    extends HashMap<K, Integer> {
        private static final long serialVersionUID = 1L;
        int limit;
        int ignoreThreshold;

        CountMap(int limit) {
            super(2 * limit);
            this.ignoreThreshold = 0;
            this.limit = limit;
        }

        CountMap(CountMap<K> map) {
            super(map);
            this.ignoreThreshold = 0;
            this.limit = map.limit;
        }

        void increment(K key) {
            Integer c = (Integer)this.get(key);
            this.put(key, c == null ? 1 : c + 1);
            while (this.size() > this.limit / 2) {
                ++this.ignoreThreshold;
                Iterator ei = this.entrySet().iterator();
                while (ei.hasNext()) {
                    Integer ec = (Integer)ei.next().getValue();
                    if (ec > this.ignoreThreshold) continue;
                    ei.remove();
                }
            }
        }
    }
}

