/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.zabAccept;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.messages.TotalOrderMessage;
import org.vanilladb.comm.protocols.consensusUtils.PaxosObjectProposal;
import org.vanilladb.comm.protocols.consensusUtils.PaxosProposal;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.Nack;
import org.vanilladb.comm.protocols.events.PaxosPropose;
import org.vanilladb.comm.protocols.events.PaxosReturn;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.events.Write;
import org.vanilladb.comm.protocols.events.WriteAck;
import org.vanilladb.comm.protocols.events.ZabCacheTom;
import org.vanilladb.comm.protocols.utils.ProcessSet;

public class ZabAcceptSession
extends Session {
    private ProcessSet correct = null;
    private PaxosProposal tempValue = null;
    private PaxosProposal val = null;
    private long tstamp = 0L;
    private int wAcks = 0;
    private int curr_epoch = 0;
    private long curr_sn = 0L;
    private int epoch = 0;
    private long sn = 0L;
    private boolean proposed = false;
    private long paxosStartTime;

    public ZabAcceptSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof WriteAck) {
            this.handleWriteAck((WriteAck)event);
        } else if (event instanceof Write) {
            this.handleWrite((Write)event);
        } else if (event instanceof PaxosPropose) {
            this.handlePaxosPropose((PaxosPropose)event);
        } else if (event instanceof Nack) {
            this.handleNack((Nack)event);
        } else if (event instanceof Crash) {
            this.handleCrash((Crash)event);
        } else if (event instanceof ProcessInitEvent) {
            this.handleProcessInit((ProcessInitEvent)event);
        }
    }

    private void init() {
        this.tempValue = new PaxosProposal();
        this.val = new PaxosProposal();
        this.val.abort = true;
        this.tempValue.abort = true;
        this.wAcks = 0;
        this.tstamp = this.correct.getSelfRank();
    }

    private void handleProcessInit(ProcessInitEvent event) {
        this.correct = event.getProcessSet();
        this.init();
        try {
            event.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handlePaxosPropose(PaxosPropose pp) {
        if (Logger.getLogger(ZabAcceptSession.class.getName()).isLoggable(Level.FINE)) {
            Logger.getLogger(ZabAcceptSession.class.getName()).fine("Paxos Propose for epoch = " + this.curr_epoch + ", sn = " + this.curr_sn);
            this.paxosStartTime = System.currentTimeMillis();
        }
        this.tstamp += (long)this.correct.getSize();
        this.tempValue = pp.value;
        this.curr_epoch = pp.epoch;
        this.curr_sn = pp.sn;
        this.proposed = true;
        try {
            Write ev = new Write(pp.getChannel(), -1, this);
            ev.getMessage().pushObject((Object)this.tempValue);
            ev.getMessage().pushLong(this.curr_sn);
            ev.getMessage().pushInt(this.curr_epoch);
            ev.getMessage().pushInt(this.correct.getSelfRank());
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleNack(Nack nack) {
        if (Logger.getLogger(ZabAcceptSession.class.getName()).isLoggable(Level.FINE)) {
            Logger.getLogger(ZabAcceptSession.class.getName()).fine("handle nack");
        }
        this.proposed = false;
        try {
            PaxosReturn ev = new PaxosReturn(nack.getChannel(), 1, this);
            this.tempValue.abort = true;
            ev.decision = this.tempValue;
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleWrite(Write write) {
        block12: {
            int sender = write.getMessage().popInt();
            if (!this.correct.getProcess(sender).isCorrect()) {
                return;
            }
            int epoch = write.getMessage().popInt();
            long sn = write.getMessage().popLong();
            if (this.epoch > epoch || this.sn >= sn) {
                if (Logger.getLogger(ZabAcceptSession.class.getName()).isLoggable(Level.FINE)) {
                    Logger.getLogger(ZabAcceptSession.class.getName()).fine("sending nack for epoch = " + epoch + ", sn = " + sn);
                }
                try {
                    Nack ev = new Nack(write.getChannel(), -1, this);
                    ev.source = this.correct.getSelfProcess().getSocketAddress();
                    ev.dest = write.source;
                    ev.setSourceSession(this);
                    ev.init();
                    if (ev.dest.equals(ev.source)) {
                        this.handleNack(ev);
                        break block12;
                    }
                    ev.go();
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                }
            } else {
                if (Logger.getLogger(ZabAcceptSession.class.getName()).isLoggable(Level.FINE)) {
                    Logger.getLogger(ZabAcceptSession.class.getName()).fine("sending WriteAck for epoch = " + epoch + ", sn = " + sn);
                }
                PaxosProposal v = (PaxosProposal)write.getMessage().popObject();
                this.epoch = epoch;
                this.sn = sn;
                this.val = v;
                try {
                    ZabCacheTom zct = new ZabCacheTom(write.getChannel(), 1, this, (TotalOrderMessage)((PaxosObjectProposal)v).obj);
                    zct.init();
                    zct.go();
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                }
                try {
                    WriteAck ev = new WriteAck(write.getChannel(), -1, this);
                    ev.getMessage().pushInt(epoch);
                    ev.getMessage().pushLong(sn);
                    ev.source = this.correct.getSelfProcess().getSocketAddress();
                    ev.dest = write.source;
                    ev.setSourceSession(this);
                    ev.init();
                    ev.go();
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void handleWriteAck(WriteAck wa) {
        if (this.proposed && wa.getMessage().popLong() == this.curr_sn && wa.getMessage().popInt() == this.curr_epoch) {
            ++this.wAcks;
            if (Logger.getLogger(ZabAcceptSession.class.getName()).isLoggable(Level.FINE)) {
                Logger.getLogger(ZabAcceptSession.class.getName()).fine("Valid WriteAck, wAcks = " + this.wAcks + ", Paxos Time = " + (System.currentTimeMillis() - this.paxosStartTime));
            }
            this.writeDecide(wa.getChannel());
        } else if (Logger.getLogger(ZabAcceptSession.class.getName()).isLoggable(Level.FINE)) {
            Logger.getLogger(ZabAcceptSession.class.getName()).fine("invalid WriteAck, wAcks = " + this.wAcks + ", Paxos Time = " + (System.currentTimeMillis() - this.paxosStartTime));
        }
    }

    private void writeDecide(Channel channel) {
        if (this.wAcks > this.correct.getSize() / 2) {
            this.wAcks = 0;
            this.proposed = false;
            try {
                PaxosReturn ev = new PaxosReturn(channel, 1, this);
                this.tempValue.abort = false;
                ev.decision = this.tempValue;
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
            if (Logger.getLogger(ZabAcceptSession.class.getName()).isLoggable(Level.FINE)) {
                Logger.getLogger(ZabAcceptSession.class.getName()).fine("Paxos Time: " + (System.currentTimeMillis() - this.paxosStartTime));
            }
        }
    }

    private void handleCrash(Crash crash) {
        int crashedProcess = crash.getCrashedProcess();
        Logger.getLogger(ZabAcceptSession.class.getName()).fine("Process " + crashedProcess + " failed.");
        this.correct.getProcess(crashedProcess).setCorrect(false);
        try {
            crash.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }
}

