/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.EventScheduler;
import net.sf.appia.core.TimerManager;
import net.sf.appia.core.events.channel.ExternalEvent;
import net.sf.appia.protocols.common.AppiaThreadFactory;

public class Appia {
    protected Vector<EventScheduler> eventSchedulers = new Vector();
    protected TimerManager timerManager = null;
    protected Thread thread = null;
    protected int nEvents = 0;
    private ThreadFactory threadFactory;
    private boolean running = true;
    private String managementMBeanID;
    protected static Appia appia = new Appia();

    public Appia() {
        this.threadFactory = new AppiaThreadFactory();
        this.timerManager = new TimerManager(this.threadFactory);
    }

    public Appia(ThreadFactory thf) {
        this.threadFactory = thf;
        this.timerManager = new TimerManager(this.threadFactory);
    }

    public TimerManager instanceGetTimerManager() {
        return this.timerManager;
    }

    public void instanceSetTimerManager(TimerManager timerManager) {
        if (this.timerManager != null) {
            this.timerManager.stop();
        }
        this.timerManager = timerManager;
        this.timerManager.start();
    }

    public void instanceInsertEventScheduler(EventScheduler eventScheduler) {
        if (!this.eventSchedulers.contains(eventScheduler)) {
            this.eventSchedulers.addElement(eventScheduler);
        }
    }

    public void instanceRemoveEventScheduler(EventScheduler eventScheduler) {
        this.eventSchedulers.removeElement(eventScheduler);
    }

    public void instanceInsertListenRequest(ExternalEvent descriptor) {
    }

    public void instanceRemoveListenRequest(ExternalEvent descriptor) {
    }

    public synchronized void instanceInsertedEvent() {
        this.notify();
        ++this.nEvents;
    }

    public Thread instanceGetAppiaThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceRun() {
        int i;
        this.timerManager.start();
        this.thread = Thread.currentThread();
        for (i = 0; i < this.eventSchedulers.size(); ++i) {
            EventScheduler es = this.eventSchedulers.elementAt(i);
            es.start();
        }
        i = 0;
        while (true) {
            EventScheduler es;
            try {
                es = this.eventSchedulers.elementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                es = null;
            }
            boolean consumedEvent = es != null ? es.consumeEvent() : false;
            Appia appia = this;
            synchronized (appia) {
                if (consumedEvent) {
                    --this.nEvents;
                }
                while (this.running && this.nEvents == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.running) {
                    break;
                }
            }
            if (++i < this.eventSchedulers.size()) continue;
            i = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceStop() {
        Appia appia = this;
        synchronized (appia) {
            this.running = false;
            this.timerManager.stop();
        }
    }

    public static TimerManager getTimerManager() {
        return Appia.appia.timerManager;
    }

    public static void setTimerManager(TimerManager timerManager) {
        appia.instanceSetTimerManager(timerManager);
    }

    public static void insertEventScheduler(EventScheduler eventScheduler) {
        appia.instanceInsertEventScheduler(eventScheduler);
    }

    public static void removeEventScheduler(EventScheduler eventScheduler) {
        appia.instanceRemoveEventScheduler(eventScheduler);
    }

    public static void insertListenRequest(ExternalEvent descriptor) {
        appia.instanceInsertListenRequest(descriptor);
    }

    public static void removeListenRequest(ExternalEvent descriptor) {
        appia.instanceRemoveListenRequest(descriptor);
    }

    public static void run() {
        appia.instanceRun();
    }

    public static void insertedEvent() {
        appia.instanceInsertedEvent();
    }

    public static Thread getAppiaThread() {
        return Appia.appia.thread;
    }

    public synchronized ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory thf) throws AppiaException {
        if (this.timerManager != null) {
            this.timerManager.stop();
        }
        this.threadFactory = thf;
        this.timerManager = new TimerManager(thf);
        this.timerManager.start();
    }

    public void setManagementMBeanID(String id) {
        this.managementMBeanID = id;
    }

    public String getManagementMBeanID() {
        return this.managementMBeanID;
    }
}

