/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import net.sf.appia.core.Appia;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Session;

public class EventScheduler {
    private Appia appia;
    private Event mainHead = null;
    private Event mainTail = null;
    private Event mainLast = null;
    private Event reverseHead = null;
    private Event reverseTail = null;
    private Event waitingHead = null;
    private Event waitingTail = null;
    private int currentDirection = 0;
    private Channel currentChannel = null;
    private Session currentSession = null;

    public EventScheduler() {
        this.appia = Appia.appia;
        this.appia.instanceInsertEventScheduler(this);
    }

    public EventScheduler(Appia appia) {
        this.appia = appia;
        appia.instanceInsertEventScheduler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Event event) {
        if (Thread.currentThread() == this.appia.instanceGetAppiaThread() && this.currentSession != null && event.getChannel() == this.currentChannel && (event.currentSession() == this.currentSession || event.getSourceSession() == this.currentSession)) {
            if (event.getDir() == this.currentDirection) {
                if (this.mainHead == null) {
                    event.setSchedulerData(null);
                    this.mainHead = this.mainTail = event;
                } else {
                    if (this.mainTail == this.mainLast) {
                        this.mainTail = event;
                    }
                    if (this.mainLast == null) {
                        event.setSchedulerData(this.mainHead);
                        this.mainHead = event;
                    } else {
                        event.setSchedulerData(this.mainLast.getSchedulerData());
                        this.mainLast.setSchedulerData(event);
                    }
                }
                this.mainLast = event;
            } else {
                event.setSchedulerData(null);
                if (this.reverseHead == null) {
                    this.reverseHead = event;
                } else {
                    this.reverseTail.setSchedulerData(event);
                }
                this.reverseTail = event;
            }
        } else {
            EventScheduler eventScheduler = this;
            synchronized (eventScheduler) {
                event.setSchedulerData(null);
                if (this.waitingTail == null || event.getPriority() <= this.waitingTail.getPriority()) {
                    if (this.waitingHead == null) {
                        this.waitingHead = event;
                    } else {
                        this.waitingTail.setSchedulerData(event);
                    }
                    this.waitingTail = event;
                } else if (event.getPriority() > this.waitingHead.getPriority()) {
                    event.setSchedulerData(this.waitingHead);
                    this.waitingHead = event;
                } else {
                    Event previous = this.waitingHead;
                    Event current = (Event)this.waitingHead.getSchedulerData();
                    while (event.getPriority() <= current.getPriority()) {
                        previous = current;
                        current = (Event)current.getSchedulerData();
                    }
                    event.setSchedulerData(current);
                    previous.setSchedulerData(event);
                }
            }
        }
        this.appia.instanceInsertedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeEvent() {
        boolean consumed = true;
        Event event = null;
        Session session = null;
        if (this.mainHead != null) {
            event = this.mainHead;
            this.mainHead = (Event)this.mainHead.getSchedulerData();
            if (this.mainHead == null) {
                this.mainTail = null;
            }
        } else if (this.reverseHead != null) {
            event = this.reverseHead;
            this.mainHead = (Event)this.reverseHead.getSchedulerData();
            this.mainTail = this.mainHead == null ? null : this.reverseTail;
            this.reverseHead = null;
            this.reverseTail = null;
        } else {
            EventScheduler eventScheduler = this;
            synchronized (eventScheduler) {
                if (this.waitingHead != null) {
                    event = this.waitingHead;
                    this.waitingHead = (Event)this.waitingHead.getSchedulerData();
                    if (this.waitingHead == null) {
                        this.waitingTail = null;
                    }
                } else {
                    consumed = false;
                }
            }
        }
        if (consumed) {
            event.setSchedulerData(null);
            session = event.popSession();
            if (session != null) {
                this.currentSession = session;
                this.currentDirection = event.getDir();
                this.currentChannel = event.getChannel();
                this.mainLast = null;
                try {
                    session.handle(event);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    System.err.println("--------------------------------Exception report:\nSession: " + session + "\nEvent: " + event + "\nDirection: " + (event.getDir() == 1 ? "UP" : "DOWN") + "\nSourceSession: " + event.getSourceSession() + "\nChannel: " + event.getChannel() + "\n--------------------------------");
                    throw e;
                }
                this.currentSession = null;
            }
        }
        return consumed;
    }

    public Session getHandelingSession() {
        return this.currentSession;
    }

    public Appia getAppiaInstance() {
        return this.appia;
    }

    public void start() {
    }

    public void stop() {
    }
}

