/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import java.util.HashSet;
import java.util.Iterator;
import net.sf.appia.core.AppiaInvalidQoSException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.EventScheduler;
import net.sf.appia.core.Layer;
import net.sf.appia.core.QoSEventRoute;
import net.sf.appia.core.events.channel.ChannelClose;
import net.sf.appia.core.events.channel.ChannelEvent;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.management.jmx.JMXConfiguration;

public class QoS {
    private String qosID;
    protected QoSEventRoute[] eventsRoutes;
    protected Layer[] layers;
    protected Class[][] eventsAccepted = null;
    private Class[] eventsProvided = null;

    public QoS(String id, Layer[] layers) throws AppiaInvalidQoSException {
        this.layers = layers;
        this.qosID = id;
        this.eventsAccepted = new Class[layers.length + 1][];
        HashSet<Class> provided = new HashSet<Class>();
        for (int i = 0; i < layers.length; ++i) {
            Class[] provides = layers[i].getProvidedEvents();
            if (provides != null) {
                for (int j = 0; j < provides.length; ++j) {
                    provided.add(provides[j]);
                }
            }
            this.eventsAccepted[i] = layers[i].getAcceptedEvents();
        }
        provided.add(ChannelInit.class);
        provided.add(ChannelClose.class);
        this.eventsAccepted[this.eventsAccepted.length - 1] = new Class[1];
        this.eventsAccepted[this.eventsAccepted.length - 1][0] = ChannelEvent.class;
        this.eventsProvided = provided.toArray(new Class[0]);
        this.validateQoS();
        this.layers = (Layer[])layers.clone();
        this.makeEventsRoutes();
    }

    public String getQoSID() {
        return this.qosID;
    }

    public Channel createUnboundChannel(String channelID, EventScheduler eventScheduler) {
        return new Channel(channelID, this, eventScheduler, null);
    }

    public Channel createUnboundChannel(String channelID, EventScheduler eventScheduler, JMXConfiguration config) {
        return new Channel(channelID, this, eventScheduler, config);
    }

    public Channel createUnboundChannel(String channelID) {
        return new Channel(channelID, this, new EventScheduler(), null);
    }

    public Channel createUnboundChannel(String channelID, JMXConfiguration config) {
        return new Channel(channelID, this, new EventScheduler(), config);
    }

    public Channel createUnboundChannel(String channelID, EventScheduler eventScheduler, MemoryManager mm) {
        return new Channel(channelID, this, eventScheduler, mm, null);
    }

    public Channel createUnboundChannel(String channelID, EventScheduler eventScheduler, MemoryManager mm, JMXConfiguration config) {
        return new Channel(channelID, this, eventScheduler, mm, config);
    }

    public Channel createUnboundChannel(String channelID, MemoryManager mm) {
        return new Channel(channelID, this, new EventScheduler(), mm, null);
    }

    public Channel createUnboundChannel(String channelID, MemoryManager mm, JMXConfiguration config) {
        return new Channel(channelID, this, new EventScheduler(), mm, config);
    }

    public Layer[] getLayers() {
        return (Layer[])this.layers.clone();
    }

    protected void validateQoS() throws AppiaInvalidQoSException {
        for (int i = 0; i < this.layers.length; ++i) {
            Class[] requires = this.layers[i].getRequiredEvents();
            if (requires == null) continue;
            for (int j = 0; requires != null && j < requires.length; ++j) {
                if (this.hasRequired(requires[j])) continue;
                throw new AppiaInvalidQoSException(" required Event (\"" + requires[j].getName() + "\") not provided");
            }
        }
    }

    protected void makeEventsRoutes() {
        int i;
        HashSet<Class> all = new HashSet<Class>();
        for (i = 0; i < this.eventsProvided.length; ++i) {
            all.add(this.eventsProvided[i]);
        }
        for (i = 0; i < this.eventsAccepted.length; ++i) {
            if (this.eventsAccepted[i] == null) continue;
            for (int j = 0; j < this.eventsAccepted[i].length; ++j) {
                all.add(this.eventsAccepted[i][j]);
            }
        }
        this.eventsRoutes = new QoSEventRoute[all.size()];
        Iterator iter = all.iterator();
        i = 0;
        while (iter.hasNext()) {
            Class eventType = (Class)iter.next();
            this.eventsRoutes[i] = new QoSEventRoute(this, eventType);
            ++i;
        }
    }

    public QoSEventRoute[] getEventsRoutes() {
        return this.eventsRoutes;
    }

    private boolean hasRequired(Class required) {
        for (int i = 0; i < this.eventsProvided.length; ++i) {
            if (!required.isAssignableFrom(this.eventsProvided[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.layers.length != ((QoS)obj).layers.length) {
            return false;
        }
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.layers[i].getClass() == ((QoS)obj).layers[i].getClass()) continue;
            return false;
        }
        return true;
    }
}

