/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core.events;

import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Session;
import net.sf.appia.core.message.Message;

public class SendableEvent
extends Event
implements Cloneable {
    private boolean detached;
    public Object dest;
    public Object source;
    protected Message message;

    public SendableEvent() {
        this.message = new Message();
        this.detached = true;
    }

    public SendableEvent(Channel channel, int dir, Session source) throws AppiaEventException {
        super(channel, dir, source);
        this.message = new Message();
        this.detached = false;
        this.attachToMemory();
    }

    public SendableEvent(Message msg) {
        this.message = msg;
        this.detached = false;
        this.attachToMemory();
    }

    public SendableEvent(Channel channel, int dir, Session source, Message msg) throws AppiaEventException {
        super(channel, dir, source);
        this.message = msg;
        this.detached = false;
        this.attachToMemory();
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
        this.attachToMemory();
    }

    public void setChannel(Channel channel) {
        super.setChannel(channel);
        this.attachToMemory();
    }

    private void attachToMemory() {
        if (this.detached) {
            return;
        }
        if (this.message != null && this.getChannel() != null) {
            this.message.setMemoryManager(this.getChannel().getMemoryManager());
            this.detached = false;
        }
    }

    public void detachFromMemory() {
        if (!this.detached && this.message.getMemoryManager() != null) {
            this.message.setMemoryManager(null);
            this.detached = true;
        }
    }

    public Event cloneEvent() throws CloneNotSupportedException {
        SendableEvent ev = (SendableEvent)super.cloneEvent();
        ev.message = (Message)this.message.clone();
        return ev;
    }
}

