/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.core.message.AppiaOutOfMemory;
import net.sf.appia.core.message.MessageException;
import net.sf.appia.core.message.MsgBuffer;
import net.sf.appia.core.message.MsgWalk;

public class Message
implements Cloneable {
    public static final int INCREASE = 512;
    public static final boolean CHECK = false;
    private static boolean checked = false;
    private static final int SHORTSIZE = 2;
    private static final int INTSIZE = 4;
    private static final int LONGSIZE = 8;
    private static final int BOOLSIZE = 1;
    private static final byte GENERIC_OBJECT = 0;
    private static final byte INET_SOCKET_ADDR = 1;
    private AuxOutputStream aos = null;
    private AuxInputStream ais = null;
    private MsgBuffer mbuf;
    protected Block first = null;
    protected int size = 0;
    protected boolean ro_mode = false;
    protected int ro_off = 0;
    protected int ro_len = 0;
    private MemoryManager memoryManager = null;
    private Object mmLock = new Object();
    protected boolean canBind = true;
    static final boolean debugFull = false;
    static PrintStream debug = System.out;

    public Message() {
        this.init();
    }

    public Message(byte[] data, int offset, int length) {
        Block b;
        this.bind(length);
        this.first = b = new Block(data, offset, length, offset);
        this.size = length;
        this.init();
    }

    private void init() {
        this.mbuf = new MsgBuffer();
    }

    public void setByteArray(byte[] data, int offset, int length) {
        Block b;
        if (this.size > 0) {
            this.unBind(this.size);
        }
        this.bind(length);
        while (this.first != null) {
            --this.first.refs;
            this.first = this.first.next;
        }
        this.first = b = new Block(data, offset, length, offset);
        this.size = length;
        this.ro_mode = false;
        this.ro_len = 0;
        this.ro_off = 0;
    }

    public int length() {
        return this.size;
    }

    public void peek(MsgBuffer mbuf) {
        if (this.first == null) {
            mbuf.data = null;
            mbuf.off = 0;
            mbuf.len = 0;
            return;
        }
        if (this.ro_mode && mbuf.len <= this.ro_len || !this.ro_mode && mbuf.len <= this.first.len) {
            if (this.first.refs > 1) {
                if (this.ro_mode) {
                    this.clearReadOnly();
                } else {
                    this.first = this.copyBlock(this.first, this.first.off, this.first.len);
                }
            }
            mbuf.data = this.first.buf;
            mbuf.off = this.first.off;
        } else {
            this.pop(mbuf);
            this.bind(mbuf.len);
            Block b = new Block(mbuf.data, mbuf.off, mbuf.len, mbuf.off);
            b.next = this.first;
            this.first = b;
            this.size += b.len;
        }
    }

    public int discard(int length) {
        if (this.size - length > 0) {
            this.unBind(Math.min(length, this.size));
        }
        int r = length > this.size ? this.size : length;
        int newsize = this.size - r;
        while (this.size > newsize && this.first != null) {
            int remove;
            if (!this.ro_mode && this.first.refs > 1) {
                this.ro_mode = true;
                this.ro_off = this.first.off;
                this.ro_len = this.first.len;
            }
            if (this.ro_mode) {
                if (this.size - newsize >= this.ro_len) {
                    this.size -= this.ro_len;
                    --this.first.refs;
                    this.first = this.first.next;
                    if (this.first != null) {
                        this.ro_off = this.first.off;
                        this.ro_len = this.first.len;
                        continue;
                    }
                    this.ro_mode = false;
                    this.ro_off = 0;
                    this.ro_len = 0;
                    continue;
                }
                remove = this.size - newsize;
                this.ro_off += remove;
                this.ro_len -= remove;
                this.size -= remove;
                continue;
            }
            if (this.size - newsize >= this.first.len) {
                this.size -= this.first.len;
                this.first = this.first.next;
                continue;
            }
            remove = this.size - newsize;
            this.first.off += remove;
            this.first.len -= remove;
            this.size -= remove;
        }
        return r;
    }

    public void discardAll() {
        this.unBind(this.size);
        this.size = 0;
        while (this.first != null) {
            --this.first.refs;
            this.first = this.first.next;
        }
        this.ro_mode = false;
    }

    public void pop(MsgBuffer mbuf) {
        if (this.first == null) {
            mbuf.data = null;
            mbuf.off = 0;
            mbuf.len = 0;
            return;
        }
        if (this.ro_mode && mbuf.len <= this.ro_len || !this.ro_mode && mbuf.len <= this.first.len) {
            if (this.ro_mode) {
                this.clearReadOnly();
            }
            if (this.first.refs > 1) {
                this.first = this.copyBlock(this.first, this.first.off, this.first.len);
            }
            mbuf.data = this.first.buf;
            mbuf.off = this.first.off;
            this.first.off += mbuf.len;
            this.first.len -= mbuf.len;
            if (this.first.len == 0) {
                --this.first.refs;
                this.first = this.first.next;
            }
            this.size -= mbuf.len;
        } else {
            mbuf.len = mbuf.len > this.size ? this.size : mbuf.len;
            mbuf.off = 0;
            mbuf.data = new byte[mbuf.len];
            int newsize = this.size - mbuf.len;
            int off = 0;
            if (this.ro_mode) {
                System.arraycopy(this.first.buf, this.ro_off, mbuf.data, off, this.ro_len);
                off += this.ro_len;
                --this.first.refs;
                this.first = this.first.next;
                this.size -= this.ro_len;
                this.ro_mode = false;
                this.ro_off = 0;
                this.ro_len = 0;
            }
            while (this.size > newsize && this.first != null) {
                if (this.size - newsize >= this.first.len) {
                    System.arraycopy(this.first.buf, this.first.off, mbuf.data, off, this.first.len);
                    off += this.first.len;
                    this.size -= this.first.len;
                    --this.first.refs;
                    this.first = this.first.next;
                    continue;
                }
                int remove = this.size - newsize;
                System.arraycopy(this.first.buf, this.first.off, mbuf.data, off, remove);
                off += remove;
                if (this.first.refs > 1) {
                    this.first = this.copyBlock(this.first, this.first.off + remove, this.first.len - remove);
                } else {
                    this.first.off += remove;
                    this.first.len -= remove;
                }
                this.size -= remove;
            }
        }
        this.unBind(mbuf.len);
    }

    public void push(MsgBuffer mbuf) {
        if (this.canBind) {
            this.bind(mbuf.len);
        }
        if (this.ro_mode) {
            this.clearReadOnly();
        }
        int l = mbuf.len;
        if (this.first == null || l > this.first.off - this.first.offset || this.first.refs > 1) {
            byte[] a = new byte[l + 512];
            Block b = new Block(a, 0, a.length, a.length - l);
            b.next = this.first;
            this.first = b;
        } else {
            this.first.off -= l;
            this.first.len += l;
        }
        mbuf.data = this.first.buf;
        mbuf.off = this.first.off;
        this.size += l;
    }

    public int truncate(int newLength) {
        int remain = newLength;
        if (newLength >= this.size) {
            return 0;
        }
        if (this.size < newLength) {
            this.unBind(this.size - newLength);
        }
        if (this.ro_mode) {
            this.clearReadOnly();
        }
        Block b = this.first;
        while (remain > 0 && b != null) {
            if (b.refs > 1) {
                this.copyRemain();
                this.first.len = newLength;
                remain = 0;
            } else if (b.len >= remain) {
                b.len = remain;
                b.next = null;
                remain = 0;
            } else {
                remain -= b.len;
            }
            b = b.next;
        }
        this.size = newLength;
        return newLength - remain;
    }

    public void frag(Message m, int length) {
        int remain = length;
        if (this.size <= length) {
            m.first = null;
            m.size = 0;
            return;
        }
        int auxSize = Math.max(this.size - length, 0);
        m.bind(auxSize);
        this.unBind(auxSize);
        if (this.ro_mode) {
            this.clearReadOnly();
        }
        Block copy = null;
        Block prev = null;
        int off = 0;
        Block b = this.first;
        while (remain > 0 && b != null) {
            if (copy == null && b.refs > 1) {
                copy = new Block(new byte[remain], 0, remain, 0);
                off = 0;
                if (prev == null) {
                    this.first = copy;
                } else {
                    prev.next = copy;
                }
            }
            if (b.len == remain) {
                if (copy != null) {
                    System.arraycopy(b.buf, b.off, copy.buf, off, remain);
                    --b.refs;
                }
                m.first = b.next;
                remain = 0;
            } else if (b.len > remain) {
                if (copy != null) {
                    System.arraycopy(b.buf, b.off, copy.buf, off, remain);
                    m.first = this.copyBlock(b, b.off + remain, b.len - remain);
                } else {
                    m.first = new Block(b.buf, b.off + remain, b.offset + b.length - (b.off + remain), b.off + remain);
                    m.first.next = b.next;
                    b.next = null;
                    b.length = m.first.offset - this.first.offset;
                    b.len = remain;
                }
                remain = 0;
            } else {
                if (copy != null) {
                    System.arraycopy(b.buf, b.off, copy.buf, off, b.len);
                    off += b.len;
                    --b.refs;
                }
                remain -= b.len;
            }
            prev = b;
            b = b.next;
        }
        m.size = this.size - length;
        this.size = length;
    }

    public void join(Message m) {
        this.bind(m.length());
        if (this.first == null) {
            this.first = m.first;
            this.size = m.size;
            return;
        }
        if (this.ro_mode) {
            this.clearReadOnly();
        }
        if (m.ro_mode) {
            m.clearReadOnly();
        }
        Block prev = null;
        Block b = this.first;
        while (b != null) {
            if (b.refs > 1) {
                Block aux = this.copyBlock(b, b.off, b.len);
                if (prev == null) {
                    this.first = aux;
                } else {
                    prev.next = aux;
                }
                prev = aux;
            } else {
                prev = b;
            }
            b = b.next;
        }
        prev.next = m.first;
        this.size += m.size;
        m.unBind(m.size);
        m.first = null;
        m.size = 0;
    }

    public byte[] toByteArray() {
        Block b;
        int len = this.length();
        byte[] array = new byte[len];
        int off = 0;
        if (this.ro_mode) {
            System.arraycopy(this.first.buf, this.ro_off, array, off, this.ro_len);
            off += this.ro_len;
            b = this.first.next;
        } else {
            b = this.first;
        }
        while (b != null) {
            System.arraycopy(b.buf, b.off, array, off, b.len);
            off += b.len;
            b = b.next;
        }
        return array;
    }

    public MsgWalk getMsgWalk() {
        if (this.first.refs > 1) {
            this.copyRemain();
        }
        return new MsgWalk(this.first);
    }

    public Object clone() throws CloneNotSupportedException {
        this.bind(this.length());
        Message msg = (Message)super.clone();
        Block b = this.first;
        while (b != null) {
            ++b.refs;
            b = b.next;
        }
        msg.mbuf = new MsgBuffer();
        msg.ais = new AuxInputStream();
        msg.aos = new AuxOutputStream();
        return msg;
    }

    public void popReadOnly(MsgBuffer mbuf) {
        if (this.first == null) {
            mbuf.data = null;
            mbuf.off = 0;
            mbuf.len = 0;
            return;
        }
        if (this.first.refs < 2) {
            if (this.ro_mode) {
                this.first.off = this.ro_off;
                this.first.len = this.ro_len;
                this.ro_mode = false;
                this.ro_off = 0;
                this.ro_len = 0;
            }
            this.pop(mbuf);
            return;
        }
        if (this.ro_mode) {
            if (mbuf.len > this.ro_len) {
                this.pop(mbuf);
                return;
            }
            mbuf.data = this.first.buf;
            mbuf.off = this.ro_off;
            this.ro_off += mbuf.len;
            this.ro_len -= mbuf.len;
            this.size -= mbuf.len;
        } else {
            if (mbuf.len > this.first.len) {
                this.pop(mbuf);
                return;
            }
            mbuf.data = this.first.buf;
            mbuf.off = this.first.off;
            this.ro_off = this.first.off + mbuf.len;
            this.ro_len = this.first.len - mbuf.len;
            this.size -= mbuf.len;
            this.ro_mode = true;
        }
        if (this.ro_len == 0) {
            --this.first.refs;
            this.first = this.first.next;
            this.ro_mode = false;
            this.ro_off = 0;
            this.ro_len = 0;
        }
        this.unBind(mbuf.len);
    }

    public void peekReadOnly(MsgBuffer mbuf) {
        if (this.first == null) {
            mbuf.data = null;
            mbuf.off = 0;
            mbuf.len = 0;
            return;
        }
        if (this.first.refs < 2) {
            if (this.ro_mode) {
                this.first.off = this.ro_off;
                this.first.len = this.ro_len;
                this.ro_mode = false;
                this.ro_off = 0;
                this.ro_len = 0;
            }
            this.peek(mbuf);
            return;
        }
        if (this.ro_mode) {
            if (mbuf.len > this.ro_len) {
                this.peek(mbuf);
                return;
            }
            mbuf.data = this.first.buf;
            mbuf.off = this.ro_off;
        } else {
            if (mbuf.len > this.first.len) {
                this.peek(mbuf);
                return;
            }
            mbuf.data = this.first.buf;
            mbuf.off = this.first.off;
            this.ro_off = this.first.off;
            this.ro_len = this.first.len;
            this.ro_mode = true;
        }
    }

    public MsgWalk getMsgWalkReadOnly() {
        if (this.ro_mode) {
            return new MsgWalk(this.first, this.ro_off, this.ro_len);
        }
        return new MsgWalk(this.first);
    }

    private void clearReadOnly() {
        if (this.first.refs > 1) {
            this.first = this.copyBlock(this.first, this.ro_off, this.ro_len);
        } else {
            this.first.off = this.ro_off;
            this.first.len = this.ro_len;
        }
        this.ro_mode = false;
        this.ro_off = 0;
        this.ro_len = 0;
    }

    private void copyRemain() {
        if (this.first == null) {
            return;
        }
        byte[] a = this.toByteArray();
        Block b = new Block(a, 0, a.length, 0);
        while (this.first != null) {
            --this.first.refs;
            this.first = this.first.next;
        }
        this.first = b;
    }

    private Block copyBlock(Block b, int off, int len) {
        byte[] a = new byte[len];
        Block aux = new Block(a, 0, a.length, a.length - len);
        System.arraycopy(b.buf, off, aux.buf, aux.off, len);
        aux.next = b.next;
        aux.refs = 1;
        --b.refs;
        return aux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManager getMemoryManager() {
        Object object = this.mmLock;
        synchronized (object) {
            return this.memoryManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryManager(MemoryManager newMM) {
        Object object = this.mmLock;
        synchronized (object) {
            if (this.memoryManager == null && newMM != null) {
                if (!newMM.malloc(this.size)) {
                    throw new AppiaOutOfMemory(this.getClass().getName() + " : setMemoryManager");
                }
            } else if (this.memoryManager != null && newMM == null) {
                this.memoryManager.free(this.size);
            } else if (this.memoryManager != null && newMM != null && this.memoryManager != newMM) {
                if (!newMM.malloc(this.size)) {
                    throw new AppiaOutOfMemory(this.getClass().getName() + " : setMemoryManager");
                }
                this.memoryManager.free(this.size);
            }
            this.memoryManager = newMM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unBind(int nBytes) {
        Object object = this.mmLock;
        synchronized (object) {
            if (this.memoryManager != null) {
                this.memoryManager.free(nBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(int nBytes) {
        Object object = this.mmLock;
        synchronized (object) {
            if (this.memoryManager != null && !this.memoryManager.malloc(nBytes)) {
                throw new AppiaOutOfMemory(this.getClass().getName() + " : bind - " + this.memoryManager.getMemoryManagerID());
            }
        }
    }

    public void pushObject(Object obj) {
        if (obj instanceof InetSocketAddress) {
            this.pushInetSocketAddress((InetSocketAddress)obj);
            this.pushByte((byte)1);
            return;
        }
        if (this.aos == null) {
            this.aos = new AuxOutputStream();
        }
        this.aos.setInternal();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(this.aos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException ex) {
            throw new MessageException("Error writing object to message.", ex);
        }
        this.mbuf.len = this.aos.length();
        this.push(this.mbuf);
        this.aos.copyInternalTo(this.mbuf.data, this.mbuf.off, this.mbuf.len);
        this.pushInt(this.mbuf.len);
        this.pushByte((byte)0);
    }

    public void pushLong(long l) {
        this.mbuf.len = 8;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = (byte)((int)(l >>> 56) & 0xFF);
        this.mbuf.data[this.mbuf.off + 1] = (byte)((int)(l >>> 48) & 0xFF);
        this.mbuf.data[this.mbuf.off + 2] = (byte)((int)(l >>> 40) & 0xFF);
        this.mbuf.data[this.mbuf.off + 3] = (byte)((int)(l >>> 32) & 0xFF);
        this.mbuf.data[this.mbuf.off + 4] = (byte)((int)(l >>> 24) & 0xFF);
        this.mbuf.data[this.mbuf.off + 5] = (byte)((int)(l >>> 16) & 0xFF);
        this.mbuf.data[this.mbuf.off + 6] = (byte)((int)(l >>> 8) & 0xFF);
        this.mbuf.data[this.mbuf.off + 7] = (byte)((int)(l >>> 0) & 0xFF);
    }

    public void pushInt(int i) {
        this.mbuf.len = 4;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = (byte)(i >>> 24 & 0xFF);
        this.mbuf.data[this.mbuf.off + 1] = (byte)(i >>> 16 & 0xFF);
        this.mbuf.data[this.mbuf.off + 2] = (byte)(i >>> 8 & 0xFF);
        this.mbuf.data[this.mbuf.off + 3] = (byte)(i >>> 0 & 0xFF);
    }

    public void pushShort(short s) {
        this.mbuf.len = 2;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = (byte)(s >>> 8 & 0xFF);
        this.mbuf.data[this.mbuf.off + 1] = (byte)(s >>> 0 & 0xFF);
    }

    public void pushBoolean(boolean b) {
        this.mbuf.len = 1;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = (byte)(b ? 1 : 0);
    }

    public void pushDouble(double d) {
        this.pushLong(Double.doubleToLongBits(d));
    }

    public void pushFloat(float f) {
        this.pushInt(Float.floatToIntBits(f));
    }

    public void pushUnsignedInt(long ui) {
        this.mbuf.len = 4;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = (byte)(ui >>> 24 & 0xFFL);
        this.mbuf.data[this.mbuf.off + 1] = (byte)(ui >>> 16 & 0xFFL);
        this.mbuf.data[this.mbuf.off + 2] = (byte)(ui >>> 8 & 0xFFL);
        this.mbuf.data[this.mbuf.off + 3] = (byte)(ui >>> 0 & 0xFFL);
    }

    public void pushUnsignedShort(int us) {
        this.mbuf.len = 2;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = (byte)(us >>> 8 & 0xFF);
        this.mbuf.data[this.mbuf.off + 1] = (byte)(us >>> 0 & 0xFF);
    }

    public void pushByte(byte b) {
        this.mbuf.len = 1;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = b;
    }

    public void pushUnsignedByte(int ub) {
        this.mbuf.len = 1;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + 0] = (byte)(ub & 0xFF);
    }

    public void pushString(String str) {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        this.mbuf.len = utflen + 2;
        this.push(this.mbuf);
        if (utflen > 65535) {
            throw new MessageException("Error writing string to message.", new UTFDataFormatException());
        }
        this.mbuf.data[this.mbuf.off + count++] = (byte)(utflen >>> 8 & 0xFF);
        this.mbuf.data[this.mbuf.off + count++] = (byte)(utflen >>> 0 & 0xFF);
        i = 0;
        while (i < strlen) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.mbuf.data[this.mbuf.off + count++] = (byte)c;
            } else if (c > '\u07ff') {
                this.mbuf.data[this.mbuf.off + count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.mbuf.data[this.mbuf.off + count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.mbuf.data[this.mbuf.off + count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.mbuf.data[this.mbuf.off + count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.mbuf.data[this.mbuf.off + count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    private void pushInetSocketAddress(InetSocketAddress address) {
        MsgBuffer mbuf = new MsgBuffer();
        mbuf.len = 6;
        this.push(mbuf);
        mbuf.data[mbuf.off + 0] = (byte)(address.getPort() >>> 8 & 0xFF);
        mbuf.data[mbuf.off + 1] = (byte)(address.getPort() >>> 0 & 0xFF);
        System.arraycopy(address.getAddress().getAddress(), 0, mbuf.data, mbuf.off + 2, 4);
    }

    public Object popObject() {
        byte objectType = this.popByte();
        if (objectType == 1) {
            return this.popInetSocketAddress();
        }
        if (this.ais == null) {
            this.ais = new AuxInputStream();
        }
        this.mbuf.len = this.popInt();
        this.popReadOnly(this.mbuf);
        this.ais.setBuffer(this.mbuf.data, this.mbuf.off, this.mbuf.len);
        try {
            ObjectInputStream ois = new ObjectInputStream(this.ais);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new MessageException("IO error reading object from message.", e);
        }
        catch (ClassNotFoundException e) {
            throw new MessageException("Trying to read an unknown object from message.", e);
        }
        catch (Exception ex) {
            throw new MessageException("Error reading object from message.", ex);
        }
    }

    public long popLong() {
        this.mbuf.len = 8;
        this.popReadOnly(this.mbuf);
        long ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        long ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        long ch3 = this.mbuf.data[this.mbuf.off + 2] & 0xFF;
        long ch4 = this.mbuf.data[this.mbuf.off + 3] & 0xFF;
        long ch5 = this.mbuf.data[this.mbuf.off + 4] & 0xFF;
        long ch6 = this.mbuf.data[this.mbuf.off + 5] & 0xFF;
        long ch7 = this.mbuf.data[this.mbuf.off + 6] & 0xFF;
        long ch8 = this.mbuf.data[this.mbuf.off + 7] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4 | ch5 | ch6 | ch7 | ch8) < 0L) {
            throw new MessageException("Error reading long value.", new EOFException());
        }
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + (ch8 << 0);
    }

    public int popInt() {
        this.mbuf.len = 4;
        this.popReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        int ch3 = this.mbuf.data[this.mbuf.off + 2] & 0xFF;
        int ch4 = this.mbuf.data[this.mbuf.off + 3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new MessageException("Error reading integer from message.", new EOFException());
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public short popShort() {
        this.mbuf.len = 2;
        this.popReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        if ((ch1 | ch2) < 0) {
            throw new MessageException("Error reading short value.", new EOFException());
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public boolean popBoolean() {
        this.mbuf.len = 1;
        this.popReadOnly(this.mbuf);
        int ch = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        if (ch < 0) {
            throw new MessageException("Error reading boolean value.", new EOFException());
        }
        return ch != 0;
    }

    public double popDouble() {
        return Double.longBitsToDouble(this.popLong());
    }

    public float popFloat() {
        return Float.intBitsToFloat(this.popInt());
    }

    public long popUnsignedInt() {
        this.mbuf.len = 4;
        this.popReadOnly(this.mbuf);
        long ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        long ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        long ch3 = this.mbuf.data[this.mbuf.off + 2] & 0xFF;
        long ch4 = this.mbuf.data[this.mbuf.off + 3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0L) {
            throw new MessageException("Error reading Unsigned int value.", new EOFException());
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public int popUnsignedShort() {
        this.mbuf.len = 2;
        this.popReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        if ((ch1 | ch2) < 0) {
            throw new MessageException("Error reading Unsigned short value.", new EOFException());
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public byte popByte() {
        this.mbuf.len = 1;
        this.popReadOnly(this.mbuf);
        return this.mbuf.data[this.mbuf.off + 0];
    }

    public int popUnsignedByte() {
        this.mbuf.len = 1;
        this.popReadOnly(this.mbuf);
        return this.mbuf.data[this.mbuf.off + 0] & 0xFF;
    }

    public String popString() {
        int utflen;
        this.mbuf.len = 2;
        this.popReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        if ((ch1 | ch2) < 0) {
            throw new MessageException("Error reading string from message.", new EOFException());
        }
        this.mbuf.len = utflen = (ch1 << 8) + (ch2 << 0);
        char[] str = new char[utflen];
        this.popReadOnly(this.mbuf);
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = this.mbuf.data[this.mbuf.off + count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    byte char2 = this.mbuf.data[this.mbuf.off + (count += 2) - 1];
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    byte char2 = this.mbuf.data[this.mbuf.off + (count += 3) - 2];
                    byte char3 = this.mbuf.data[this.mbuf.off + count - 1];
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new MessageException("Error reading string from message (Wrong string size).", new EOFException());
                }
            }
        }
        return new String(str, 0, strlen);
    }

    private InetSocketAddress popInetSocketAddress() {
        MsgBuffer mbuf = new MsgBuffer();
        mbuf.len = 6;
        this.pop(mbuf);
        StringBuilder strBuilder = new StringBuilder();
        int i = 0;
        while (i < 3) {
            strBuilder.append(mbuf.data[mbuf.off + i + 2] & 0xFF);
            strBuilder.append(".");
            ++i;
        }
        strBuilder.append(mbuf.data[mbuf.off + 3 + 2] & 0xFF);
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(strBuilder.toString());
        }
        catch (UnknownHostException ex) {
            throw new MessageException("Unable to retrieve the IP address \"" + strBuilder.toString() + "\" correctly.", ex);
        }
        int port = (mbuf.data[mbuf.off] & 0xFF) << 8;
        return new InetSocketAddress(inet, port |= (mbuf.data[mbuf.off + 1] & 0xFF) << 0);
    }

    public Object peekObject() {
        int size;
        if (this.size <= 0) {
            return null;
        }
        byte objectType = this.popByte();
        if (objectType == 1) {
            InetSocketAddress addr = this.peekInetSocketAddress();
            this.pushByte(objectType);
            return addr;
        }
        if (this.ais == null) {
            this.ais = new AuxInputStream();
        }
        this.mbuf.len = size = this.popInt();
        this.peekReadOnly(this.mbuf);
        this.ais.setBuffer(this.mbuf.data, this.mbuf.off, this.mbuf.len);
        try {
            ObjectInputStream ois = new ObjectInputStream(this.ais);
            Object obj = ois.readObject();
            this.pushInt(size);
            this.pushByte(objectType);
            return obj;
        }
        catch (Exception ex) {
            this.pushInt(size);
            this.pushByte(objectType);
            throw new MessageException("Error peeking object.", ex);
        }
    }

    public long peekLong() {
        this.mbuf.len = 8;
        this.peekReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        int ch3 = this.mbuf.data[this.mbuf.off + 2] & 0xFF;
        int ch4 = this.mbuf.data[this.mbuf.off + 3] & 0xFF;
        int ch5 = this.mbuf.data[this.mbuf.off + 4] & 0xFF;
        int ch6 = this.mbuf.data[this.mbuf.off + 5] & 0xFF;
        int ch7 = this.mbuf.data[this.mbuf.off + 6] & 0xFF;
        int ch8 = this.mbuf.data[this.mbuf.off + 7] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4 | ch5 | ch6 | ch7 | ch8) < 0) {
            throw new MessageException("Error peeking value.", new EOFException());
        }
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + (ch8 << 0);
    }

    public int peekInt() {
        this.mbuf.len = 4;
        this.peekReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        int ch3 = this.mbuf.data[this.mbuf.off + 2] & 0xFF;
        int ch4 = this.mbuf.data[this.mbuf.off + 3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new MessageException("Error peeking int value.", new EOFException());
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public short peekShort() {
        this.mbuf.len = 2;
        this.peekReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        if ((ch1 | ch2) < 0) {
            throw new MessageException("Error reading short value.", new EOFException());
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public boolean peekBoolean() {
        this.mbuf.len = 1;
        this.peekReadOnly(this.mbuf);
        int ch = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        if (ch < 0) {
            throw new MessageException("Error peeking boolean value.", new EOFException());
        }
        return ch != 0;
    }

    public double peekDouble() {
        return Double.longBitsToDouble(this.peekLong());
    }

    public float peekFloat() {
        return Float.intBitsToFloat(this.peekInt());
    }

    public long peekUnsignedInt() {
        this.mbuf.len = 4;
        this.peekReadOnly(this.mbuf);
        long ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        long ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        long ch3 = this.mbuf.data[this.mbuf.off + 2] & 0xFF;
        long ch4 = this.mbuf.data[this.mbuf.off + 3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0L) {
            throw new MessageException("Error peeking unsigned integer value.", new EOFException());
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public int peekUnsignedShort() {
        this.mbuf.len = 2;
        this.peekReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        if ((ch1 | ch2) < 0) {
            throw new MessageException("Error peeking unsigned short value.", new EOFException());
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public byte peekByte() {
        this.mbuf.len = 1;
        this.peekReadOnly(this.mbuf);
        return this.mbuf.data[this.mbuf.off + 0];
    }

    public int peekUnsignedByte() {
        this.mbuf.len = 1;
        this.peekReadOnly(this.mbuf);
        return this.mbuf.data[this.mbuf.off + 0] & 0xFF;
    }

    public String peekString() {
        int utflen;
        this.mbuf.len = 2;
        this.popReadOnly(this.mbuf);
        int ch1 = this.mbuf.data[this.mbuf.off + 0] & 0xFF;
        int ch2 = this.mbuf.data[this.mbuf.off + 1] & 0xFF;
        if ((ch1 | ch2) < 0) {
            throw new MessageException("Error peeking string from message.", new EOFException());
        }
        this.mbuf.len = utflen = (ch1 << 8) + (ch2 << 0);
        char[] str = new char[utflen];
        this.peekReadOnly(this.mbuf);
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = this.mbuf.data[this.mbuf.off + count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    byte char2 = this.mbuf.data[this.mbuf.off + (count += 2) - 1];
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    byte char2 = this.mbuf.data[this.mbuf.off + (count += 3) - 2];
                    byte char3 = this.mbuf.data[this.mbuf.off + count - 1];
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                }
            }
        }
        this.mbuf.len = 2;
        this.push(this.mbuf);
        this.mbuf.data[this.mbuf.off + count++] = (byte)(utflen >>> 8 & 0xFF);
        this.mbuf.data[this.mbuf.off + count++] = (byte)(utflen >>> 0 & 0xFF);
        return new String(str, 0, strlen);
    }

    private InetSocketAddress peekInetSocketAddress() {
        MsgBuffer mbuf = new MsgBuffer();
        mbuf.len = 6;
        this.peek(mbuf);
        StringBuilder strBuilder = new StringBuilder();
        int i = 0;
        while (i < 3) {
            strBuilder.append(mbuf.data[mbuf.off + i + 2] & 0xFF);
            strBuilder.append(".");
            ++i;
        }
        strBuilder.append(mbuf.data[mbuf.off + 3 + 2] & 0xFF);
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(strBuilder.toString());
        }
        catch (UnknownHostException ex) {
            throw new MessageException("Unable to retrieve the IP address \"" + strBuilder.toString() + "\" correctly.", ex);
        }
        int port = (mbuf.data[mbuf.off] & 0xFF) << 8;
        return new InetSocketAddress(inet, port |= (mbuf.data[mbuf.off + 1] & 0xFF) << 0);
    }

    private void check() {
        if (this.aos == null) {
            this.aos = new AuxOutputStream();
        }
        if (this.ais == null) {
            this.ais = new AuxInputStream();
        }
        byte[] aux = new byte[24];
        this.aos.setBuffer(aux, 0, aux.length);
        DataOutputStream dos = new DataOutputStream(this.aos);
        this.ais.setBuffer(aux, 0, aux.length);
        DataInputStream dis = new DataInputStream(this.ais);
        try {
            this.aos.setBuffer(aux, 0, aux.length);
            dos.writeShort(-514);
            this.pushShort((short)-514);
            this.mbuf.len = this.length();
            if (this.mbuf.len != this.aos.length()) {
                throw new Error("Size  mismatch in type Short");
            }
            this.peek(this.mbuf);
            if (!this.equalBytes(this.mbuf.data, this.mbuf.off, aux, 0, this.mbuf.len)) {
                throw new Error("Raw contents mismatch in type Short");
            }
            if (this.popShort() != -514) {
                throw new Error("Value mismatch in type Short");
            }
            this.aos.setBuffer(aux, 0, aux.length);
            dos.writeInt(-134480386);
            this.pushInt(-134480386);
            this.mbuf.len = this.length();
            if (this.mbuf.len != this.aos.length()) {
                throw new Error("Size  mismatch in type Int");
            }
            this.peek(this.mbuf);
            if (!this.equalBytes(this.mbuf.data, this.mbuf.off, aux, 0, this.mbuf.len)) {
                throw new Error("Raw contents mismatch in type Int");
            }
            if (this.popInt() != -134480386) {
                throw new Error("Value mismatch in type Int");
            }
            this.aos.setBuffer(aux, 0, aux.length);
            dos.writeLong(-119247870L);
            this.pushLong(-119247870L);
            this.mbuf.len = this.length();
            if (this.mbuf.len != this.aos.length()) {
                throw new Error("Size  mismatch in type Long");
            }
            this.peek(this.mbuf);
            if (!this.equalBytes(this.mbuf.data, this.mbuf.off, aux, 0, this.mbuf.len)) {
                throw new Error("Raw contents mismatch in type Long");
            }
            if (this.popLong() != -119247870L) {
                throw new Error("Value mismatch in type Long");
            }
            this.aos.setBuffer(aux, 0, aux.length);
            dos.writeFloat(-1.3448038E8f);
            this.pushFloat(-1.3448038E8f);
            this.mbuf.len = this.length();
            if (this.mbuf.len != this.aos.length()) {
                throw new Error("Size  mismatch in type Float");
            }
            this.peek(this.mbuf);
            if (!this.equalBytes(this.mbuf.data, this.mbuf.off, aux, 0, this.mbuf.len)) {
                throw new Error("Raw contents mismatch in type Float");
            }
            if (this.popFloat() != -1.3448038E8f) {
                throw new Error("Value mismatch in type Float");
            }
            this.aos.setBuffer(aux, 0, aux.length);
            dos.writeDouble(-1.34480386E8);
            this.pushDouble(-1.34480386E8);
            this.mbuf.len = this.length();
            if (this.mbuf.len != this.aos.length()) {
                throw new Error("Size  mismatch in type Double");
            }
            this.peek(this.mbuf);
            if (!this.equalBytes(this.mbuf.data, this.mbuf.off, aux, 0, this.mbuf.len)) {
                throw new Error("Raw contents mismatch in type Double");
            }
            if (this.popDouble() != -1.34480386E8) {
                throw new Error("Value mismatch in type Double");
            }
            this.aos.setBuffer(aux, 0, aux.length);
            dos.writeBoolean(true);
            this.pushBoolean(true);
            this.mbuf.len = this.length();
            if (this.mbuf.len != this.aos.length()) {
                throw new Error("Size  mismatch in type Boolean");
            }
            if (!this.popBoolean()) {
                throw new Error("Value mismatch in type Boolean");
            }
            dos.close();
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Error("DHHH");
        }
        this.discard(this.length());
        checked = true;
    }

    private boolean equalBytes(byte[] a1, int a1_off, byte[] a2, int a2_off, int len) {
        int i = 0;
        while (i < len) {
            if (a1[a1_off + i] != a2[a2_off + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class AuxInputStream
    extends InputStream {
        private byte[] buf;
        private int off;
        private int len;

        private AuxInputStream() {
        }

        public void setBuffer(byte[] buf, int off, int len) {
            this.buf = buf;
            this.off = off;
            this.len = len;
        }

        public int available() {
            return this.len;
        }

        public int read() {
            if (this.len == 0) {
                return -1;
            }
            --this.len;
            return this.buf[this.off++] & 0xFF;
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            if (len == 0) {
                return -1;
            }
            if (len > this.len) {
                len = this.len;
            }
            System.arraycopy(this.buf, this.off, b, off, len);
            this.off += len;
            this.len -= len;
            return len;
        }

        public long skip(long n) {
            if (n > (long)this.len) {
                n = this.len;
            }
            this.off = (int)((long)this.off + n);
            this.len = (int)((long)this.len - n);
            return n;
        }

        public void close() {
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readlimit) {
        }

        public void reset() {
        }
    }

    public class AuxOutputStream
    extends OutputStream {
        private byte[] buf;
        private int off;
        private int len;
        private byte[] internal = new byte[256];
        private boolean useInternal = true;
        private int init_off;

        public void setBuffer(byte[] buf, int off, int len) {
            this.buf = buf;
            this.off = off;
            this.len = len;
            this.useInternal = false;
            this.init_off = off;
        }

        public void setInternal() {
            this.buf = this.internal;
            this.off = 0;
            this.len = this.internal.length;
            this.useInternal = true;
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) {
            if (len > this.len) {
                if (this.useInternal) {
                    this.increaseCapacity(len - this.len);
                } else {
                    len = this.len;
                }
            }
            System.arraycopy(b, off, this.buf, this.off, len);
            this.off += len;
            this.len -= len;
        }

        public void write(int b) {
            if (this.len == 0) {
                if (this.useInternal) {
                    this.increaseCapacity(1);
                } else {
                    return;
                }
            }
            --this.len;
            this.buf[this.off++] = (byte)b;
        }

        public int copyInternalTo(byte[] buf, int off, int len) {
            if (len > this.internal.length) {
                len = this.internal.length;
            }
            System.arraycopy(this.internal, 0, buf, off, len);
            return len;
        }

        public int length() {
            return this.off - this.init_off;
        }

        private void increaseCapacity(int moreRequired) {
            this.internal = new byte[(this.buf.length + moreRequired) * 2];
            System.arraycopy(this.buf, 0, this.internal, 0, this.buf.length);
            this.len = this.internal.length - (this.buf.length - this.len);
            this.buf = this.internal;
        }
    }

    public class Block {
        public byte[] buf;
        public int offset;
        public int length;
        public int off;
        public int len;
        public Block next = null;
        public int refs = 1;

        public Block() {
        }

        public Block(byte[] buf, int off, int len, int pos) {
            this.buf = buf;
            this.offset = off;
            this.length = len;
            this.off = pos;
            this.len = this.length - (pos - off);
        }
    }
}

