/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.management;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.management.Notification;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.management.SensorSession;
import net.sf.appia.management.SensorSessionListener;

public abstract class AbstractSensorSession
extends Session
implements SensorSession {
    private List<SensorSessionListener> listeners = new ArrayList<SensorSessionListener>();
    private long sequenceNumber = 0L;

    public AbstractSensorSession(Layer layer) {
        super(layer);
    }

    @Override
    public void addSensorListener(SensorSessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSensorListener(SensorSessionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifySensorListeners(Notification notif) {
        ListIterator<SensorSessionListener> it = this.listeners.listIterator();
        while (it.hasNext()) {
            SensorSessionListener listener = it.next();
            listener.onNotification(notif);
        }
    }

    @Override
    public long getNotificationSequenceNumber() {
        return this.sequenceNumber++;
    }
}

