/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.management.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import net.sf.appia.core.AppiaMBeanContainer;
import net.sf.appia.core.Channel;
import net.sf.appia.management.AppiaManagementException;
import org.apache.log4j.Logger;

public class GenericActuator {
    private DynamicMBean bean = null;
    private static Logger log = Logger.getLogger(GenericActuator.class);

    public void connect(String namingHost, int namingPort, String channelName) throws AppiaManagementException {
        DynamicMBean proxy = null;
        try {
            String strURL = "service:jmx:rmi:///jndi/rmi://" + namingHost + ":" + namingPort + "/jmxrmi";
            JMXServiceURL url = new JMXServiceURL(strURL);
            log.debug((Object)("Connecting to URL: " + strURL));
            JMXConnector connector = JMXConnectorFactory.connect(url);
            log.debug((Object)"Retrieving MBean server connection...");
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            log.debug((Object)("Getting instance of MBean for channel: " + channelName));
            ObjectName delegateName = ObjectName.getInstance(Channel.class.getName() + ":name=" + channelName);
            proxy = MBeanServerInvocationHandler.newProxyInstance(connection, delegateName, DynamicMBean.class, false);
        }
        catch (MalformedObjectNameException e) {
            throw new AppiaManagementException(e);
        }
        catch (MalformedURLException e) {
            throw new AppiaManagementException(e);
        }
        catch (NullPointerException e) {
            throw new AppiaManagementException(e);
        }
        catch (IOException e) {
            throw new AppiaManagementException(e);
        }
        this.bean = proxy;
        log.debug((Object)"JMX Client connected.");
    }

    public void getLocalMBean(String managementMBeanID, String channelName) {
        String beanID = managementMBeanID + ":" + channelName;
        this.bean = AppiaMBeanContainer.getInstance().getBean(beanID);
        if (this.bean != null) {
            log.debug((Object)("Retrieved instance of MBean for ID: " + beanID));
        } else {
            log.warn((Object)("MBean for ID " + beanID + " does not exist."));
        }
    }

    public Object invoke(String action, Object[] params, String[] signature) throws AppiaManagementException {
        try {
            return this.bean.invoke(action, params, signature);
        }
        catch (MBeanException e) {
            throw new AppiaManagementException(e);
        }
        catch (ReflectionException e) {
            throw new AppiaManagementException(e);
        }
    }

    public Object getAttribute(String attribute) throws AppiaManagementException {
        try {
            return this.bean.getAttribute(attribute);
        }
        catch (AttributeNotFoundException e) {
            throw new AppiaManagementException(e);
        }
        catch (MBeanException e) {
            throw new AppiaManagementException(e);
        }
        catch (ReflectionException e) {
            throw new AppiaManagementException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws AppiaManagementException {
        try {
            this.bean.setAttribute(attribute);
        }
        catch (AttributeNotFoundException e) {
            throw new AppiaManagementException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new AppiaManagementException(e);
        }
        catch (MBeanException e) {
            throw new AppiaManagementException(e);
        }
        catch (ReflectionException e) {
            throw new AppiaManagementException(e);
        }
    }
}

