/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.fifo;

import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Direction;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.TimeProvider;
import net.sf.appia.core.events.AppiaMulticast;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelClose;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.core.events.channel.Debug;
import net.sf.appia.core.message.Message;
import net.sf.appia.core.message.MsgBuffer;
import net.sf.appia.protocols.common.FIFOUndeliveredEvent;
import net.sf.appia.protocols.common.RegisterSocketEvent;
import net.sf.appia.protocols.common.SendableNotDeliveredEvent;
import net.sf.appia.protocols.fifo.AckEvent;
import net.sf.appia.protocols.fifo.FIFOConfigEvent;
import net.sf.appia.protocols.fifo.FifoTimer;
import net.sf.appia.protocols.fifo.Header;
import net.sf.appia.protocols.fifo.PeerInfo;
import net.sf.appia.protocols.fifo.WaitingMessage;
import net.sf.appia.protocols.frag.MaxPDUSizeEvent;

public class FifoSession
extends Session {
    private HashMap<Object, PeerInfo> addresses;
    private LinkedList<WaitingMessage> messages;
    private LinkedList<Channel> channels;
    private Channel timerChannel;
    private long timerPeriod = 750L;
    private int timersToResend = 3;
    private int currentTTR = 3;
    private int nResends = 10;
    private TimeProvider timeProvider = null;
    private Object myAddr = null;
    private boolean changeTimer = false;
    private PrintStream debugOutput = System.out;

    public FifoSession(Layer l) {
        super(l);
        this.addresses = new HashMap();
        this.messages = new LinkedList();
        this.channels = new LinkedList();
    }

    public void handle(Event e) {
        if (e instanceof ChannelInit) {
            this.handleInit((ChannelInit)e);
        } else if (e instanceof ChannelClose) {
            this.handleChannelClose((ChannelClose)e);
        } else if (e instanceof AckEvent) {
            this.handleAck((AckEvent)e);
        } else if (e instanceof SendableEvent) {
            this.handleSendable((SendableEvent)e);
        } else if (e instanceof FifoTimer) {
            this.handleTimer((FifoTimer)e);
        } else if (e instanceof FIFOConfigEvent) {
            this.handleConfigEvent((FIFOConfigEvent)e);
        } else if (e instanceof Debug) {
            this.handleDebug((Debug)e);
        } else if (e instanceof MaxPDUSizeEvent) {
            this.handlePDUSize((MaxPDUSizeEvent)e);
        } else if (e instanceof RegisterSocketEvent) {
            this.handleRegisterSocket((RegisterSocketEvent)e);
        } else if (e instanceof SendableNotDeliveredEvent) {
            this.handleSendableNotDelivered((SendableNotDeliveredEvent)e);
        } else {
            try {
                e.go();
            }
            catch (AppiaEventException appiaEventException) {
                // empty catch block
            }
        }
    }

    private void handleInit(ChannelInit e) {
        this.timeProvider = e.getChannel().getTimeProvider();
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            System.err.println("(FIFO:handleInit) Unexpected event exception in FifoSession");
        }
        if (this.channels.size() == 0) {
            this.requestPeriodicTimer(e.getChannel());
        }
        this.channels.add(e.getChannel());
    }

    private void handleChannelClose(ChannelClose e) {
        this.channels.remove(e.getChannel());
        if (e.getChannel() == this.timerChannel && this.channels.size() > 0) {
            this.timerChannel = this.channels.getFirst();
            this.requestPeriodicTimer(this.timerChannel);
        }
        for (PeerInfo p : this.addresses.values()) {
            p.removeChannel(e.getChannel());
        }
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleConfigEvent(FIFOConfigEvent e) {
        if (e.isPeriodDef()) {
            this.timerPeriod = e.getPeriod();
            this.changeTimer = true;
        }
        if (e.isWindowDef()) {
            int newWindow = e.getWindow();
            for (PeerInfo p : this.addresses.values()) {
                p.windowChange(newWindow);
            }
        }
        if (e.isTimersToResendDef()) {
            this.timersToResend = e.getTimersToResend();
        }
        if (e.isNumResendsDef()) {
            this.nResends = e.getNumResends();
        }
    }

    private void handlePDUSize(MaxPDUSizeEvent e) {
        try {
            e.pduSize -= 8;
            e.go();
        }
        catch (AppiaEventException ex) {
            System.err.println("Unexpected event exception when forwarding MaxPDUSize event in FIFO");
        }
    }

    private void handleSendableNotDelivered(SendableNotDeliveredEvent e) {
        if (e.getEvent().dest == null) {
            return;
        }
        PeerInfo p = this.addresses.get(e.getEvent().dest);
        if (p == null) {
            return;
        }
        this.giveup(p, e.getEvent());
    }

    private void handleDebug(Debug e) {
        int q = e.getQualifierMode();
        if (q == 0) {
            this.debugOutput = new PrintStream(e.getOutput());
            this.debugOutput.println("FIFO: Debugging started");
        } else if (q == 1) {
            this.debugOutput = null;
        } else if (q == 2) {
            this.printState(new PrintStream(this.debugOutput));
        }
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void printState(PrintStream out) {
        out.println("FIFO Session state dumping:");
        out.println("Period : " + this.timerPeriod + "ms");
        out.println("Current number of peers: " + this.addresses.size());
        out.println("Buffer of messages size is " + this.messages.size());
        int count = 0;
        for (PeerInfo p : this.addresses.values()) {
            out.println("Host " + count + ": " + (p.peer instanceof InetSocketAddress ? ((InetSocketAddress)p.peer).getAddress().getHostAddress() : "") + " Port:" + (p.peer instanceof InetSocketAddress ? "" + ((InetSocketAddress)p.peer).getPort() : ""));
            out.println("  Next sequence number to be sent: " + p.nextOutgoing);
            out.println("  Next sequence number expected: " + p.nextIncoming);
            out.println("  First message still waiting for acknowledgment: " + p.firstUnconfirmed);
            out.println("  There are " + p.getPendingMessages() + " messages waiting to be acknowledged.");
            ++count;
        }
        out.println("Debug output is currently " + (this.debugOutput == null ? "off" : "on"));
    }

    private void handleRegisterSocket(RegisterSocketEvent rse) {
        if (rse.getDir() == 1 && !rse.error) {
            this.myAddr = new InetSocketAddress(rse.localHost, rse.port);
        }
        try {
            rse.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleAck(AckEvent e) {
        if (e.getDir() != 1) {
            this.handleSendable(e);
            return;
        }
        PeerInfo p = this.addresses.get(e.source);
        if (p == null) {
            return;
        }
        MsgBuffer msgBuf = new MsgBuffer();
        msgBuf.len = 4;
        e.getMessage().pop(msgBuf);
        if (this.hasSynActive(msgBuf)) {
            int confirmation = this.byteToSeq(msgBuf);
            this.confirmedUntil(p, confirmation);
        }
    }

    private void handleSendable(SendableEvent e) {
        switch (e.getDir()) {
            case 1: {
                this.processIncoming(e);
                break;
            }
            case -1: {
                this.processOutgoing(e);
            }
        }
    }

    private WaitingMessage prepareMessage(SendableEvent e) {
        WaitingMessage we = new WaitingMessage(e, this.nResends);
        this.messages.addLast(we);
        return we;
    }

    private void sendMessage(WaitingMessage we, Header header) {
        SendableEvent clone = null;
        try {
            clone = (SendableEvent)we.event.cloneEvent();
        }
        catch (CloneNotSupportedException ex) {
            System.err.println("(FIFO) could not clone event!");
        }
        header.peer.usedOn(this.timeProvider.currentTimeMillis());
        clone.dest = header.peer.peer;
        header.pushHeader(clone, header.peer.nextIncoming);
        try {
            clone.setSourceSession(this);
            clone.init();
            clone.go();
        }
        catch (AppiaEventException ex) {
            System.err.println("(Fifo:sendMessage) Unexpected exception in FifoSession: " + ex.getMessage());
        }
    }

    private void makeMulticast(Object[] dests, WaitingMessage we) {
        PeerInfo peer = null;
        Header header = null;
        int i = 0;
        while (i < dests.length) {
            peer = this.addresses.get(dests[i]);
            if (peer == null) {
                peer = this.newPeer(dests[i], we.event.getChannel());
            } else {
                peer.usedOn(this.timeProvider.currentTimeMillis());
            }
            header = new Header(peer, we);
            peer.headers.addLast(header);
            this.sendMessage(we, header);
            we.addHeader(header);
            peer.incOutgoing();
            ++i;
        }
    }

    private void processOutgoing(SendableEvent e) {
        WaitingMessage we = this.prepareMessage(e);
        PeerInfo peer = null;
        Header header = null;
        if (e.dest instanceof AppiaMulticast) {
            AppiaMulticast am = (AppiaMulticast)e.dest;
            Object[] dests = am.getDestinations();
            this.makeMulticast(dests, we);
        } else {
            peer = this.addresses.get(e.dest);
            if (peer == null) {
                peer = this.newPeer(e.dest, e.getChannel());
            } else {
                peer.usedOn(this.timeProvider.currentTimeMillis());
            }
            header = new Header(peer, we);
            peer.headers.addLast(header);
            this.sendMessage(we, header);
            we.addHeader(header);
            peer.incOutgoing();
        }
    }

    private void processIncoming(SendableEvent e) {
        MsgBuffer header = new MsgBuffer();
        header.len = 8;
        e.getMessage().pop(header);
        PeerInfo p = this.checkConnection(e, header);
        if (p == null) {
            return;
        }
        p.usedOn(this.timeProvider.currentTimeMillis());
        if (this.checkOrder(p, e, header)) {
            this.dequeue(p);
        }
    }

    private void confirmedUntil(PeerInfo peer, int seq) {
        peer.confirmedUntil(seq);
        peer.usedOn(this.timeProvider.currentTimeMillis());
        ListIterator it = peer.headers.listIterator();
        boolean done = false;
        Header h = null;
        while (it.hasNext() && !done) {
            h = (Header)it.next();
            if (h.sequenceNumber < seq) {
                --h.waitingMessage.endPoints;
                h.waitingMessage.removeHeader(h);
                if (h.waitingMessage.endPoints <= 0) {
                    this.messages.remove(h.waitingMessage);
                }
                it.remove();
                continue;
            }
            done = true;
        }
    }

    private void processUnackedMessages() {
        for (PeerInfo peer : this.addresses.values()) {
            if (!peer.mustSendAck(peer.nextIncoming)) continue;
            this.sendAck(peer);
        }
    }

    private boolean isTimeToResend() {
        --this.currentTTR;
        if (this.currentTTR == 0) {
            this.currentTTR = this.timersToResend;
            return true;
        }
        return false;
    }

    private void processResend() {
        long currentTime = this.timeProvider.currentTimeMillis();
        long delta = 0L;
        boolean stop = false;
        WaitingMessage message = null;
        LinkedList<WaitingMessage> localBuffer = new LinkedList<WaitingMessage>();
        ListIterator it = this.messages.listIterator();
        while (!stop && it.hasNext()) {
            message = (WaitingMessage)it.next();
            delta = currentTime - message.timeStamp;
            if (delta > this.timerPeriod) {
                it.remove();
                localBuffer.addLast(message);
                continue;
            }
            stop = true;
        }
        for (WaitingMessage waiting : localBuffer) {
            this.resendMessage(waiting);
        }
    }

    private void resendMessage(WaitingMessage we) {
        --we.nResends;
        if (we.nResends < 0) {
            for (Header header : we.getHeaders()) {
                this.giveup(header.peer, we.event);
            }
        } else {
            we.timeStamp = this.timeProvider.currentTimeMillis();
            for (Header header : we.getHeaders()) {
                this.sendMessage(we, header);
            }
            this.messages.addLast(we);
        }
    }

    private void handleTimer(FifoTimer timer) {
        if (this.isTimeToResend()) {
            this.processResend();
            this.cleanOldPeers();
        }
        this.processUnackedMessages();
        if (this.changeTimer) {
            Channel channel = timer.getChannel();
            timer.setQualifierMode(1);
            timer.setDir(Direction.invert(timer.getDir()));
            timer.setSourceSession(this);
            try {
                timer.init();
                timer.go();
            }
            catch (AppiaEventException ex) {
                System.err.println("(FIFO:handleTimer) Error when trying to send timer with qulifier OFF");
            }
            this.requestPeriodicTimer(channel);
            this.changeTimer = false;
        } else {
            try {
                timer.go();
            }
            catch (AppiaEventException appiaEventException) {
                // empty catch block
            }
        }
    }

    private void cleanOldPeers() {
        Iterator<Map.Entry<Object, PeerInfo>> peers = this.addresses.entrySet().iterator();
        PeerInfo peer = null;
        long now = this.timeProvider.currentTimeMillis();
        while (peers.hasNext()) {
            peer = peers.next().getValue();
            if (!peer.isOld(now)) continue;
            peers.remove();
        }
    }

    private void requestPeriodicTimer(Channel channel) {
        this.timerChannel = channel;
        try {
            new FifoTimer(this.timerPeriod, channel, (Session)this).go();
        }
        catch (AppiaException ex) {
            System.err.println("(FIFO:handleInit) Unexpected Appia Exception whentrying to send FifoTimer");
        }
    }

    private void giveup(PeerInfo p, SendableEvent s) {
        if (!p.failed) {
            this.addresses.remove(p.peer);
            p.failed = true;
        }
        SendableEvent unAckedEvent = null;
        if (s.dest instanceof AppiaMulticast) {
            try {
                unAckedEvent = (SendableEvent)s.cloneEvent();
            }
            catch (CloneNotSupportedException ex) {
                System.err.println("(FIFO:giveup) Could not clone event!");
            }
            unAckedEvent.dest = p.peer;
        } else {
            unAckedEvent = s;
            unAckedEvent.getMessage().pop(new MsgBuffer(new byte[8], 0, 8));
        }
        try {
            FIFOUndeliveredEvent e = new FIFOUndeliveredEvent(s.getChannel(), this, unAckedEvent);
            e.go();
        }
        catch (AppiaEventException ex) {
            switch (ex.type) {
                case 5: {
                    break;
                }
                case 4: {
                    System.err.println("Unknown session exception catched in FifoSession");
                    break;
                }
                case 2: {
                    System.err.println("Missing attribute exception catched in FifoSession");
                    break;
                }
                case 1: {
                    System.err.println("Impossible exception event not initialized in FifoSession");
                }
            }
        }
    }

    private void sendAck(PeerInfo p) {
        AckEvent ack = null;
        try {
            ack = new AckEvent(p.getChannel(), this, p.peer, this.myAddr);
            Message m = p.getChannel().getMessageFactory().newMessage();
            MsgBuffer msgBuf = new MsgBuffer();
            msgBuf.len = 4;
            m.push(msgBuf);
            this.seqToByte(msgBuf, p.nextIncoming, true);
            ack.setMessage(m);
            ack.go();
            p.ackSentNow();
            p.usedOn(this.timeProvider.currentTimeMillis());
        }
        catch (AppiaEventException ex) {
            System.err.println("(FIFO:sendAck) Unexpected event exception in FifoSession");
        }
    }

    private void seqToByte(MsgBuffer buf, int seq, boolean syn) {
        buf.data[buf.off + 3] = (byte)((byte)(0xFF & seq >> 24) | (byte)(syn ? 128 : 0));
        buf.data[buf.off + 2] = (byte)(0xFF & seq >> 16);
        buf.data[buf.off + 1] = (byte)(0xFF & seq >> 8);
        buf.data[buf.off] = (byte)(0xFF & seq);
    }

    private int byteToSeq(MsgBuffer buf) {
        return (buf.data[buf.off + 3] & 0x7F) << 24 | (buf.data[buf.off + 2] & 0xFF) << 16 | (buf.data[buf.off + 1] & 0xFF) << 8 | buf.data[buf.off] & 0xFF;
    }

    private boolean hasSynActive(MsgBuffer buf) {
        return (buf.data[buf.off + 3] & 0x80) != 0;
    }

    private PeerInfo newPeer(Object who, Channel c) {
        PeerInfo newpeer = new PeerInfo(who, c);
        this.addresses.put(who, newpeer);
        return newpeer;
    }

    @Deprecated
    protected void addMessage(WaitingMessage message) {
        this.messages.addLast(message);
    }

    @Deprecated
    protected void removeMessage(WaitingMessage message) {
        this.messages.remove(message);
    }

    @Deprecated
    protected int sizeOfBuffer() {
        return this.messages.size();
    }

    @Deprecated
    protected Object[] getArrayOfBuffer() {
        return this.messages.toArray();
    }

    private PeerInfo checkConnection(SendableEvent e, MsgBuffer header) {
        boolean syn = this.hasSynActive(header);
        header.off += 4;
        header.off -= 4;
        PeerInfo p = this.addresses.get(e.source);
        if (syn) {
            if (p != null && !p.isHisSynSent()) {
                p.synReceived(this.byteToSeq(header));
            } else {
                if (p != null && !p.isDuplicatedSyn(this.byteToSeq(header))) {
                    this.addresses.remove(e.source);
                    p.failed = true;
                }
                if (p == null || !p.isDuplicatedSyn(this.byteToSeq(header))) {
                    p = this.newPeer(e.source, e.getChannel());
                    p.synReceived(this.byteToSeq(header));
                }
            }
        }
        return p;
    }

    private boolean checkOrder(PeerInfo p, SendableEvent e, MsgBuffer header) {
        int seqNumber = this.byteToSeq(header);
        header.off += 4;
        int confirmation = this.byteToSeq(header);
        if (this.hasSynActive(header)) {
            this.confirmedUntil(p, confirmation);
        }
        if (p.isNext(seqNumber)) {
            p.incIncoming();
            try {
                e.go();
            }
            catch (AppiaEventException ex) {
                System.err.println("Unexpected event not initialized exception in FifoSession");
            }
            return true;
        }
        if (!p.isDuplicated(seqNumber)) {
            p.enqueueIncoming(e, seqNumber);
        } else {
            p.forceAck();
        }
        return false;
    }

    private void dequeue(PeerInfo p) {
        SendableEvent e;
        while ((e = p.dequeueNextIncoming()) != null) {
            p.incIncoming();
            try {
                e.go();
            }
            catch (AppiaEventException ex) {
                System.err.println("Unexpected event in FifoSession");
            }
        }
    }
}

