/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.fifo;

import java.util.LinkedList;
import net.sf.appia.core.Channel;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.protocols.fifo.Header;
import net.sf.appia.protocols.fifo.PeerWaitingMessage;

public class PeerInfo {
    protected static final int DEFAULT_QUEUE_SIZE = 11;
    public int nextOutgoing;
    public int firstUnconfirmed;
    public int nextIncoming;
    public int lastAckSent;
    public int peerSyn;
    private boolean isMySynSent;
    private boolean isHisSynSent;
    private PeerWaitingMessage[] waitQueue;
    private int queueSize = 11;
    public boolean failed = false;
    public long lastUsed;
    public LinkedList<Header> headers;
    private LinkedList<Channel> channels;
    public Object peer;

    public PeerInfo(Object peer, Channel c) {
        long now = c.getTimeProvider().currentTimeMillis();
        this.headers = new LinkedList();
        this.channels = new LinkedList();
        this.channels.add(c);
        this.peer = peer;
        this.nextOutgoing = (int)(now % Integer.MAX_VALUE);
        this.nextIncoming = 0;
        this.firstUnconfirmed = this.nextOutgoing;
        this.lastAckSent = -1;
        this.waitQueue = new PeerWaitingMessage[this.queueSize];
        this.isMySynSent = false;
        this.isHisSynSent = false;
        this.lastUsed = now;
    }

    public void addChannel(Channel c) {
        if (!this.channels.contains(c)) {
            this.channels.add(c);
        }
    }

    public void removeChannel(Channel c) {
        this.channels.remove(c);
    }

    public Channel getChannel() {
        return this.channels.getLast();
    }

    public void usedOn(long millis) {
        this.lastUsed = millis;
    }

    public boolean isOld(long now) {
        return now - this.lastUsed >= 2000L;
    }

    public void incOutgoing() {
        this.nextOutgoing = (long)this.nextOutgoing + 1L == 0x80000000L ? 0 : ++this.nextOutgoing;
    }

    public void incIncoming() {
        this.nextIncoming = (long)this.nextIncoming + 1L == 0x80000000L ? 0 : ++this.nextIncoming;
    }

    public boolean isNext(int check) {
        return this.isHisSynSent && this.nextIncoming == check;
    }

    public boolean isDuplicated(int check) {
        return this.nextIncoming > check || this.nextIncoming < 0x40000000 && check > 0x40000000;
    }

    public boolean isDuplicatedSyn(int check) {
        return !this.isHisSynSent || this.peerSyn == check;
    }

    public void ackSentNow() {
        this.lastAckSent = this.nextIncoming;
    }

    public boolean mustSendAck(int check) {
        return this.lastAckSent < check || this.nextIncoming < this.lastAckSent;
    }

    public boolean mustSendAck() {
        return this.nextIncoming < this.lastAckSent;
    }

    public SendableEvent dequeueNextIncoming() {
        if (this.nextIncoming < this.queueSize) {
            return null;
        }
        int queueIndex = this.nextIncoming % this.queueSize;
        if (this.waitQueue[queueIndex] == null) {
            return null;
        }
        SendableEvent ret = this.waitQueue[queueIndex].e;
        this.waitQueue[queueIndex] = null;
        return ret;
    }

    public void enqueueIncoming(SendableEvent e, int seqNumber) {
        if (seqNumber - this.nextIncoming > this.queueSize || seqNumber < this.queueSize) {
            return;
        }
        int queueIndex = seqNumber % this.queueSize;
        if (this.waitQueue[queueIndex] == null) {
            this.waitQueue[queueIndex] = new PeerWaitingMessage(e, seqNumber);
        }
    }

    public void confirmedUntil(int seq) {
        if (this.firstUnconfirmed < seq && seq <= this.nextOutgoing) {
            this.firstUnconfirmed = seq;
        } else if (this.firstUnconfirmed > this.nextOutgoing && (this.firstUnconfirmed < seq || seq <= this.nextOutgoing)) {
            this.firstUnconfirmed = seq;
        }
    }

    boolean isAcknowledged(int seq) {
        return this.firstUnconfirmed > seq || this.firstUnconfirmed < 0x40000000 && seq > 0x40000000;
    }

    public int getPendingMessages() {
        return this.nextOutgoing - this.firstUnconfirmed > 0 ? this.nextOutgoing - this.firstUnconfirmed : Integer.MAX_VALUE - this.firstUnconfirmed + 1 + this.nextOutgoing;
    }

    public boolean sendSynAck() {
        return this.isHisSynSent();
    }

    public boolean sendMySyn() {
        if (this.isMySynSent) {
            return false;
        }
        this.isMySynSent = true;
        return true;
    }

    public boolean isHisSynSent() {
        return this.isHisSynSent;
    }

    public void synReceived(int nextIncoming) {
        this.nextIncoming = nextIncoming;
        this.lastAckSent = nextIncoming - 1;
        this.peerSyn = nextIncoming;
        this.isHisSynSent = true;
    }

    public void forceAck() {
        this.lastAckSent = this.lastAckSent == 0 ? Integer.MAX_VALUE : this.lastAckSent - 1;
    }

    public void windowChange(int newWindow) {
        PeerWaitingMessage[] newQueue = new PeerWaitingMessage[newWindow];
        int i = this.nextIncoming;
        int j = Math.min(newWindow, this.queueSize) + this.nextIncoming;
        while (i < j) {
            newQueue[i % newWindow] = this.waitQueue[i % this.queueSize];
            ++i;
        }
        this.waitQueue = newQueue;
        this.queueSize = newWindow;
    }

    public String toString() {
        return "[Fifo peer: " + this.peer + " hasFailed=" + this.failed + "]";
    }
}

