/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.fifo;

import java.util.LinkedList;
import net.sf.appia.core.events.AppiaMulticast;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.protocols.fifo.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitingMessage {
    public SendableEvent event;
    protected int endPoints;
    protected int nResends;
    protected long timeStamp;
    private LinkedList<Header> headers;

    public WaitingMessage(SendableEvent e, int nResends) {
        this.init(e, nResends);
        this.timeStamp = e.getChannel().getTimeProvider().currentTimeMillis();
    }

    public WaitingMessage(SendableEvent e, long ts, int nResends) {
        this.init(e, nResends);
        this.timeStamp = ts;
    }

    public void addHeader(Header h) {
        this.headers.addLast(h);
    }

    public void removeHeader(Header h) {
        this.headers.remove(h);
    }

    public Object[] toHeaderArray() {
        return this.headers.toArray();
    }

    public LinkedList<Header> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (o instanceof WaitingMessage) {
            WaitingMessage we = (WaitingMessage)o;
            return this.event.equals(we.event) && this.endPoints == we.endPoints && this.timeStamp == we.timeStamp;
        }
        return false;
    }

    private void init(SendableEvent e, int nResends) {
        this.event = e;
        this.endPoints = e.dest instanceof AppiaMulticast ? ((AppiaMulticast)e.dest).getDestinations().length : 1;
        this.headers = new LinkedList();
        this.nResends = nResends;
    }
}

