/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.frag;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelClose;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.core.events.channel.Debug;
import net.sf.appia.core.message.Message;
import net.sf.appia.core.message.MessageFactory;
import net.sf.appia.protocols.frag.FragEvent;
import net.sf.appia.protocols.frag.FragTimer;
import net.sf.appia.protocols.frag.MaxPDUSizeEvent;
import net.sf.appia.xml.interfaces.InitializableSession;
import net.sf.appia.xml.utils.SessionProperties;

public class FragSession
extends Session
implements InitializableSession {
    private static final int INIT_HASHMAP_SIZE = 19;
    private int msgSeq = 0;
    private HashMap pdus;
    private HashMap sources;
    private final int fragHeaderSize = 8;
    private int paramFragSize = -1;
    public static final int TIMER_PERIOD = 30000;
    private Channel timerChannel = null;
    private MessageFactory messageFactory = null;
    private PrintStream debugOutput = System.err;

    public FragSession(Layer layer) {
        super(layer);
        this.pdus = new HashMap(19);
        this.sources = new HashMap();
    }

    public void init(SessionProperties params) {
        if (params.containsKey("frag_size")) {
            this.paramFragSize = params.getInt("frag_size");
        }
    }

    private FragHolder findFragHolder(Object who, int msgId) {
        ArrayList msgs = (ArrayList)this.sources.get(who);
        if (msgs == null) {
            return null;
        }
        int i = 0;
        while (i < msgs.size()) {
            FragHolder f = (FragHolder)msgs.get(i);
            if (f.msgId == msgId) {
                return f;
            }
            ++i;
        }
        return null;
    }

    private void addFragHolder(FragHolder fh) {
        ArrayList<FragHolder> msgs = (ArrayList<FragHolder>)this.sources.get(fh.source);
        if (msgs == null) {
            msgs = new ArrayList<FragHolder>();
            this.sources.put(fh.source, msgs);
        }
        msgs.add(fh);
    }

    private void removeFragHolder(FragHolder fh) {
        ArrayList msgs = (ArrayList)this.sources.get(fh.source);
        if (msgs == null) {
            return;
        }
        msgs.remove(fh);
    }

    public void handle(Event e) {
        if (e instanceof Debug) {
            this.handleDebug((Debug)e);
        } else if (e instanceof ChannelInit) {
            this.initChannel((ChannelInit)e);
        } else if (e instanceof ChannelClose) {
            this.closedChannel((ChannelClose)e);
        } else if (e instanceof MaxPDUSizeEvent) {
            this.setPDUSize((MaxPDUSizeEvent)e);
        } else if (e instanceof FragTimer) {
            this.updateHolding();
        } else if (e instanceof SendableEvent) {
            if (e.getDir() == 1) {
                this.reassembly((SendableEvent)e);
            } else {
                this.split((SendableEvent)e);
            }
        } else {
            try {
                e.go();
            }
            catch (AppiaEventException appiaEventException) {
                // empty catch block
            }
        }
    }

    private void initChannel(ChannelInit ev) {
        if (this.timerChannel == null) {
            this.sendTimer(ev.getChannel());
        }
        this.queryPDUSize(ev);
        this.messageFactory = ev.getChannel().getMessageFactory();
    }

    private void closedChannel(ChannelClose ev) {
        if (ev.getChannel() == this.timerChannel) {
            this.timerChannel = null;
        }
        try {
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void sendTimer(Channel channel) {
        try {
            new FragTimer(30000L, channel, (Session)this, 0).go();
            this.timerChannel = channel;
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
            this.timerChannel = null;
        }
        catch (AppiaException ex) {
            ex.printStackTrace();
            this.timerChannel = null;
        }
    }

    private void updateHolding() {
        Iterator iter = this.sources.values().iterator();
        while (iter.hasNext()) {
            ArrayList msgs = (ArrayList)iter.next();
            Iterator i = msgs.iterator();
            while (i.hasNext()) {
                FragHolder f = (FragHolder)i.next();
                if (f.secondChance) {
                    i.remove();
                    continue;
                }
                f.secondChance = true;
            }
            if (msgs.size() != 0) continue;
            iter.remove();
        }
    }

    private void queryPDUSize(ChannelInit e) {
        try {
            this.pdus.put(e.getChannel(), new PDUSize());
            MaxPDUSizeEvent max = new MaxPDUSizeEvent(e.getChannel(), -1, this);
            max.init();
            e.go();
            max.go();
        }
        catch (AppiaEventException ex) {
            switch (ex.type) {
                case 4: {
                    System.err.println("An exception stating that this class does not belong to the channel was raised in Frag");
                    break;
                }
                case 2: {
                    System.err.println("Missing attribute exception in Frag");
                    break;
                }
                case 5: {
                    System.err.println("The peer send an Unwanted event in Frag");
                    break;
                }
                case 1: {
                    System.err.println("Event not initialized exception ocurred after initialization in Frag");
                }
            }
        }
    }

    private void setPDUSize(MaxPDUSizeEvent e) {
        PDUSize p = (PDUSize)this.pdus.get(e.getChannel());
        p.size = e.pduSize - 8;
        p.def = true;
        while (!p.holding.isEmpty()) {
            this.split((SendableEvent)p.holding.removeFirst());
        }
        p.holding = null;
    }

    private void split(SendableEvent e) {
        if (this.paramFragSize > 0) {
            this.splitMessage(e, this.paramFragSize);
        } else {
            PDUSize p = (PDUSize)this.pdus.get(e.getChannel());
            if (p.def) {
                this.splitMessage(e, p.size);
            } else {
                p.holding.add(e);
            }
        }
    }

    private void splitMessage(SendableEvent e, int fragSize) {
        Message orig = e.getMessage();
        try {
            int maxLength = fragSize;
            int nFrags = this.getFrags(orig.length(), maxLength);
            if (orig.length() > maxLength) {
                Message m = this.messageFactory.newMessage();
                orig.frag(m, maxLength);
                orig.pushInt(nFrags);
                orig.pushInt(this.msgSeq);
                e.go();
                orig = m;
                int fragNumber = 1;
                while (fragNumber < nFrags) {
                    FragEvent f = new FragEvent(e, this);
                    if (orig.length() > maxLength) {
                        m = this.messageFactory.newMessage();
                        orig.frag(m, maxLength);
                    } else {
                        m = null;
                    }
                    orig.pushInt(fragNumber++);
                    orig.pushInt(this.msgSeq);
                    f.setMessage(orig);
                    f.go();
                    orig = m;
                }
            } else {
                orig.pushInt(nFrags);
                orig.pushInt(this.msgSeq);
                e.go();
            }
            ++this.msgSeq;
        }
        catch (AppiaEventException ex) {
            ++this.msgSeq;
            System.err.println("Unexpected event exception while fragmenting message");
        }
    }

    private void reassembly(SendableEvent e) {
        if (this.timerChannel == null) {
            this.sendTimer(e.getChannel());
        }
        try {
            int msgId = e.getMessage().popInt();
            int nFrags = e.getMessage().popInt();
            FragHolder fHold = null;
            if (e instanceof FragEvent) {
                fHold = this.findFragHolder(e.source, msgId);
                if (fHold == null) {
                    fHold = new FragHolder(e.source, msgId);
                    this.addFragHolder(fHold);
                }
                fHold.ensureSize(nFrags + 1);
                fHold.frags.set(nFrags, e.getMessage());
            } else {
                if (nFrags <= 1) {
                    e.go();
                    return;
                }
                fHold = this.findFragHolder(e.source, msgId);
                if (fHold == null) {
                    fHold = new FragHolder(e.source, msgId, nFrags);
                    this.addFragHolder(fHold);
                }
                fHold.e = e;
                fHold.ensureSize(nFrags);
                fHold.frags.set(0, e.getMessage());
            }
            if (this.receivedAll(fHold.frags)) {
                Message msg = (Message)fHold.frags.get(0);
                int i = 1;
                while (i < fHold.frags.size()) {
                    msg.join((Message)fHold.frags.get(i));
                    ++i;
                }
                fHold.e.setMessage(msg);
                fHold.e.go();
                this.removeFragHolder(fHold);
            } else {
                fHold.secondChance = false;
            }
        }
        catch (AppiaEventException ex) {
            System.err.println("Unexpected event exception while reassembling message");
        }
    }

    private void handleDebug(Debug e) {
        int q = e.getQualifierMode();
        if (q == 0) {
            this.debugOutput = new PrintStream(e.getOutput());
            this.debugOutput.println("Frag: Debugging started");
        } else if (q == 1) {
            this.debugOutput = null;
        } else if (q == 2) {
            this.printState(new PrintStream(e.getOutput()));
        }
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void printState(PrintStream out) {
        out.println("Frag Session state dumping:");
        Iterator ipdus = this.pdus.keySet().iterator();
        if (ipdus.hasNext()) {
            out.println("List of channels:");
        } else {
            out.println("No channels available");
        }
        while (ipdus.hasNext()) {
            Channel c = (Channel)ipdus.next();
            out.print("Channel name: " + c.getChannelID() + " Defined: ");
            PDUSize p = (PDUSize)this.pdus.get(c);
            if (p.def) {
                out.println("yes. Max PDU size: " + p.size);
                continue;
            }
            out.println("no.");
        }
        Iterator iter = this.sources.values().iterator();
        if (iter.hasNext()) {
            out.println("Pending messages:");
        } else {
            out.println("No pending messages.");
        }
        while (iter.hasNext()) {
            ArrayList msgs = (ArrayList)iter.next();
            int i = 0;
            while (i < msgs.size()) {
                FragHolder f = (FragHolder)msgs.get(i);
                int r = 0;
                int j = 0;
                while (j < f.frags.size()) {
                    if (f.frags.get(j) != null) {
                        ++r;
                    }
                    ++j;
                }
                out.println("Current message number of frags: " + f.frags.size() + " Fragments received: " + r + " SecondChance: " + f.secondChance);
                ++i;
            }
        }
        out.println("Debug output is currently " + (this.debugOutput == null ? "off" : "on"));
    }

    private int getFrags(int length, int maxsize) {
        int frags = length / maxsize;
        if (length % maxsize > 0) {
            ++frags;
        }
        return frags;
    }

    private boolean receivedAll(ArrayList a) {
        return a.indexOf(null) < 0;
    }

    private class FragHolder {
        private static final int DEFAULT_NUMBER_FRAGS = 10;
        public ArrayList frags;
        public Object source;
        public int msgId;
        public SendableEvent e = null;
        public boolean secondChance = false;

        public FragHolder(Object source, int msgId) {
            this.source = source;
            this.msgId = msgId;
            this.frags = new ArrayList(10);
        }

        public FragHolder(Object source, int msgId, int nFrags) {
            this.source = source;
            this.msgId = msgId;
            this.frags = new ArrayList(nFrags);
        }

        public void ensureSize(int size) {
            while (this.frags.size() < size) {
                this.frags.add(null);
            }
        }
    }

    private class PDUSize {
        public boolean def = false;
        public int size;
        public LinkedList holding = new LinkedList();
    }
}

