/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.nakfifo.multicast;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import net.sf.appia.core.AppiaError;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.AppiaMulticast;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelClose;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.protocols.common.FIFOUndeliveredEvent;
import net.sf.appia.protocols.common.SendableNotDeliveredEvent;
import net.sf.appia.protocols.frag.MaxPDUSizeEvent;
import net.sf.appia.protocols.nakfifo.IgnoreEvent;
import net.sf.appia.protocols.nakfifo.MessageUtils;
import net.sf.appia.protocols.nakfifo.NackEvent;
import net.sf.appia.protocols.nakfifo.Nacked;
import net.sf.appia.protocols.nakfifo.NakFifoTimer;
import net.sf.appia.protocols.nakfifo.Peer;
import net.sf.appia.protocols.nakfifo.PingEvent;
import net.sf.appia.protocols.nakfifo.multicast.ConfirmEvent;
import net.sf.appia.protocols.nakfifo.multicast.UpdateEvent;
import net.sf.appia.xml.interfaces.InitializableSession;
import net.sf.appia.xml.utils.SessionProperties;
import org.apache.log4j.Logger;

public class NakFifoMulticastSession
extends Session
implements InitializableSession {
    private static Logger log = Logger.getLogger(NakFifoMulticastSession.class);
    public static final long DEFAULT_TIMER_PERIOD = 700L;
    public static final long DEFAULT_RESEND_TIME = 5000L;
    public static final long DEFAULT_MAX_APPL_TIME = 180000L;
    public static final long DEFAULT_MAX_RECV_TIME = 60000L;
    public static final long DEFAULT_MAX_SENT_TIME = 45000L;
    public static final long DEFAULT_CONFIRM_ROUNDS = 0L;
    private long param_TIMER_PERIOD = 700L;
    private long param_RESEND_NACK_ROUNDS = 5000L / this.param_TIMER_PERIOD;
    private long param_MAX_APPL_ROUNDS = 180000L / this.param_TIMER_PERIOD;
    private long param_MAX_RECV_ROUNDS = 60000L / this.param_TIMER_PERIOD;
    private long param_MAX_SENT_ROUNDS = 45000L / this.param_TIMER_PERIOD;
    private long param_CONFIRM_ROUNDS = 0L;
    private long first_msg_sent;
    private long last_msg_sent;
    private long rounds_confirm = 0L;
    private HashMap peers = new HashMap();
    private Channel timerChannel = null;
    private MessageUtils utils = new MessageUtils();
    public static final boolean debugFull = true;
    public static final int debugListLimit = 10;

    public NakFifoMulticastSession(Layer layer) {
        super(layer);
        this.last_msg_sent = System.currentTimeMillis() & Integer.MAX_VALUE;
        if (this.last_msg_sent == Integer.MAX_VALUE) {
            --this.last_msg_sent;
        }
        this.first_msg_sent = this.last_msg_sent + 1L;
    }

    public void init(SessionProperties params) {
        if (params.containsKey("timer_period")) {
            this.param_TIMER_PERIOD = params.getLong("timer_period");
        }
        if (params.containsKey("resend_nack_time")) {
            this.param_RESEND_NACK_ROUNDS = params.getLong("resend_nack_time") / this.param_TIMER_PERIOD;
        }
        if (params.containsKey("max_appl_time")) {
            this.param_MAX_APPL_ROUNDS = params.getLong("max_appl_time") / this.param_TIMER_PERIOD;
        }
        if (params.containsKey("max_recv_time")) {
            this.param_MAX_RECV_ROUNDS = params.getLong("max_recv_time") / this.param_TIMER_PERIOD;
        }
        if (params.containsKey("max_sent_time")) {
            this.param_MAX_SENT_ROUNDS = params.getLong("max_sent_time") / this.param_TIMER_PERIOD;
        }
        if (params.containsKey("confirm_rounds")) {
            this.param_CONFIRM_ROUNDS = params.getLong("confirm_rounds");
        }
    }

    public void handle(Event event) {
        if (event instanceof NackEvent) {
            this.handleNack((NackEvent)event);
            return;
        }
        if (event instanceof IgnoreEvent) {
            this.handleIgnore((IgnoreEvent)event);
            return;
        }
        if (event instanceof PingEvent) {
            this.handlePing((PingEvent)event);
            return;
        }
        if (event instanceof UpdateEvent) {
            this.handleUpdate((UpdateEvent)event);
            return;
        }
        if (event instanceof ConfirmEvent) {
            this.handleConfirm((ConfirmEvent)event);
            return;
        }
        if (event instanceof NakFifoTimer) {
            this.handleNakFifoTimer((NakFifoTimer)event);
            return;
        }
        if (event instanceof SendableNotDeliveredEvent) {
            this.handleSendableNotDelivered((SendableNotDeliveredEvent)event);
            return;
        }
        if (event instanceof SendableEvent) {
            this.handleSendable((SendableEvent)event);
            return;
        }
        if (event instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)event);
            return;
        }
        if (event instanceof ChannelClose) {
            this.handleChannelClose((ChannelClose)event);
            return;
        }
        if (event instanceof MaxPDUSizeEvent) {
            this.handleMaxPDUSize((MaxPDUSizeEvent)event);
            return;
        }
        log.warn((Object)("Unwanted event (\"" + event.getClass().getName() + "\") received. Continued..."));
        try {
            event.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleChannelInit(ChannelInit ev) {
        try {
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        if (this.timerChannel == null) {
            this.sendTimer(ev.getChannel());
        }
        log.debug((Object)("Params: " + ev.getChannel().getChannelID() + "\n\tTIMER_PERIOD=" + this.param_TIMER_PERIOD + "\n\tMAX_APPL_ROUNDS=" + this.param_MAX_APPL_ROUNDS + "\n\tMAX_RECV_ROUNDS=" + this.param_MAX_RECV_ROUNDS + "\n\tMAX_SENT_ROUNDS=" + this.param_MAX_SENT_ROUNDS + "\n\tRESEND_NACK_ROUNDS=" + this.param_RESEND_NACK_ROUNDS + "\n\tCONFIRM_ROUNDS=" + this.param_CONFIRM_ROUNDS));
    }

    private void handleChannelClose(ChannelClose ev) {
        try {
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        if (ev.getChannel() == this.timerChannel) {
            this.timerChannel = null;
            Iterator iter = this.peers.values().iterator();
            while (iter.hasNext() && this.timerChannel == null) {
                Peer peer = (Peer)iter.next();
                if (peer.last_channel == null) continue;
                this.sendTimer(peer.last_channel);
            }
            if (this.timerChannel != null) {
                log.debug((Object)("Sent new timer in channel " + this.timerChannel.getChannelID()));
            } else {
                log.warn((Object)"Unable to send timer. Corret operation is not garanteed");
            }
        }
    }

    private void handleMaxPDUSize(MaxPDUSizeEvent event) {
        if (event.getDir() == 1) {
            event.pduSize -= 5;
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleSendableNotDelivered(SendableNotDeliveredEvent ev) {
        try {
            FIFOUndeliveredEvent event = new FIFOUndeliveredEvent(ev.getChannel(), this, ev.getEvent());
            event.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleSendable(SendableEvent event) {
        if (event.getDir() == 1) {
            long seq;
            byte flags = event.getMessage().popByte();
            if ((flags & 1) != 0) {
                log.debug((Object)"Received message with ignore flag. Ignoring.");
                try {
                    event.go();
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                }
                return;
            }
            Peer peer = (Peer)this.peers.get(event.source);
            if (peer == null) {
                peer = this.createPeer(event.source, this.last_msg_sent, event.getChannel());
            }
            if ((seq = this.utils.popSeq(event.getMessage(), peer.last_msg_delivered, false)) < 0L) {
                log.debug((Object)("Problems reading sequence number discarding event " + event + " from " + event.source.toString()));
                return;
            }
            this.receive(peer, event, seq, seq);
            return;
        }
        if (event.getDir() == -1) {
            if (event.dest instanceof InetSocketAddress && ((InetSocketAddress)event.dest).getAddress().isMulticastAddress()) {
                log.debug((Object)"Destination is a IP Multicast address. Ignored.");
                event.getMessage().pushByte((byte)1);
                try {
                    event.go();
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                }
                return;
            }
            ++this.last_msg_sent;
            try {
                SendableEvent clone = (SendableEvent)event.cloneEvent();
                if (event.dest instanceof AppiaMulticast) {
                    Object[] dests = ((AppiaMulticast)event.dest).getDestinations();
                    int i = 0;
                    while (i < dests.length) {
                        this.sending(clone, dests[i], this.last_msg_sent);
                        ++i;
                    }
                } else {
                    this.sending(clone, event.dest, this.last_msg_sent);
                }
                this.utils.pushSeq(event.getMessage(), this.last_msg_sent);
                event.getMessage().pushByte((byte)0);
                event.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
                log.warn((Object)"To mantain coerence, sending undelivered.");
                this.sendFIFOUndelivered(event, event.dest);
                return;
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
                log.warn((Object)"To mantain coerence, sending undelivered.");
                this.sendFIFOUndelivered(event, event.dest);
                return;
            }
            return;
        }
        log.warn((Object)("Direction is wrong. Discarding event " + event));
    }

    private void handlePing(PingEvent ev) {
        if (ev.getDir() != 1) {
            log.warn((Object)"Discarding Ping event due to wrong diretion.");
            return;
        }
        Peer peer = (Peer)this.peers.get(ev.source);
        if (peer == null) {
            log.debug((Object)("Received Ping from unknown peer (" + ev.source + "). Ignoring confirm."));
            ev.getMessage().discard(4);
        } else {
            long confirmed = this.utils.popSeq(ev.getMessage(), peer.last_msg_confirmed, false);
            if (confirmed < 0L) {
                log.debug((Object)("Problems reading confirm sequence number from " + ev.source));
            } else {
                this.confirmed(peer, confirmed, ev.getChannel());
            }
        }
        this.handleSendable(ev);
    }

    private void handleNack(NackEvent ev) {
        Peer peer = (Peer)this.peers.get(ev.source);
        if (peer == null) {
            peer = this.createPeer(ev.source, this.last_msg_sent, ev.getChannel());
            return;
        }
        long first = ev.getMessage().popLong();
        if (first < 0L) {
            log.debug((Object)"Ignoring Nack due to wrong first seq number.");
            return;
        }
        long last = ev.getMessage().popLong();
        if (last < 0L) {
            log.debug((Object)"Ignoring Nack due to wrong last seq number.");
            return;
        }
        if (first > last) {
            log.debug((Object)("Ignoring Nack due to wrong seq numbers (first=" + first + ",last=" + last + ",confirmed=" + peer.last_msg_confirmed + ")."));
            return;
        }
        if (first < this.first_msg_sent || last > this.last_msg_sent) {
            log.debug((Object)("Received Nack(" + first + "," + last + ") for message not sent. Restarting communication."));
            this.ignore(peer, ev.getChannel());
            return;
        }
        this.debugPeer(peer, "handleNack(" + first + "," + last + ")");
        if (first <= peer.last_msg_confirmed) {
            if (last <= peer.last_msg_confirmed) {
                log.debug((Object)"Received Nack for messages already confirmed. Discarding.");
                return;
            }
            first = peer.last_msg_confirmed + 1L;
            log.debug((Object)("Received Nack for message already confirmed. Changig first to " + first));
        }
        if (last > peer.last_msg_sent) {
            log.debug((Object)"Nack includes messages not sent to peer. Sending Update.");
            if (first <= peer.last_msg_sent) {
                log.debug((Object)"Nack partially includes messages sent to peer, resending.");
                this.resend(peer, first, peer.last_msg_sent);
            }
            this.update(peer, last, ev.getChannel());
        } else {
            this.resend(peer, first, last);
        }
    }

    private void handleNakFifoTimer(NakFifoTimer ev) {
        try {
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        if (ev.getQualifierMode() != 2) {
            return;
        }
        boolean doConfirm = false;
        ++this.rounds_confirm;
        if (this.rounds_confirm > this.param_CONFIRM_ROUNDS) {
            this.rounds_confirm = 0L;
            doConfirm = true;
        }
        boolean changedSeq = false;
        Iterator peers_iter = this.peers.values().iterator();
        while (peers_iter.hasNext()) {
            Peer peer = (Peer)peers_iter.next();
            ++peer.rounds_appl_msg;
            ++peer.rounds_msg_recv;
            ++peer.rounds_msg_sent;
            this.debugPeer(peer, "Timer");
            if (peer.nacked != null) {
                ++peer.nacked.rounds;
                if ((long)peer.nacked.rounds > this.param_RESEND_NACK_ROUNDS) {
                    this.nack(peer, peer.last_msg_delivered >= peer.nacked.first_msg ? peer.last_msg_delivered + 1L : peer.nacked.first_msg, peer.nacked.last_msg, ((SendableEvent)peer.undelivered_msgs.getFirst()).getChannel());
                    peer.nacked.rounds = 0;
                }
            } else if ((long)peer.rounds_appl_msg > this.param_MAX_APPL_ROUNDS) {
                peers_iter.remove();
                peer = null;
            }
            if (peer != null && (long)peer.rounds_msg_recv > this.param_MAX_RECV_ROUNDS) {
                Iterator msgs = peer.unconfirmed_msgs.iterator();
                while (msgs.hasNext()) {
                    this.sendFIFOUndelivered((SendableEvent)msgs.next(), peer.addr);
                }
                peers_iter.remove();
                peer = null;
            }
            if (peer != null && (long)peer.rounds_msg_sent > this.param_MAX_SENT_ROUNDS) {
                try {
                    PingEvent e = new PingEvent(peer.last_channel, this);
                    if (!changedSeq) {
                        ++this.last_msg_sent;
                        changedSeq = true;
                    }
                    this.sending(e, peer.addr, this.last_msg_sent);
                    this.utils.pushSeq(e.getMessage(), this.last_msg_sent);
                    e.getMessage().pushByte((byte)0);
                    this.utils.pushSeq(e.getMessage(), peer.last_msg_delivered);
                    peer.last_confirm_sent = peer.last_msg_delivered;
                    e.dest = peer.addr;
                    e.go();
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                    log.warn((Object)"Impossible to send ping.");
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                    log.warn((Object)"Impossible to send ping.");
                }
            }
            if (!doConfirm || peer == null || peer.last_msg_delivered <= peer.last_confirm_sent) continue;
            this.confirm(peer);
        }
    }

    private void handleIgnore(IgnoreEvent ev) {
        Peer peer = (Peer)this.peers.get(ev.source);
        if (peer == null) {
            peer = this.createPeer(ev.source, this.last_msg_sent, ev.getChannel());
        }
        this.debugPeer(peer, "handleIgnore");
        peer.last_msg_delivered = ev.getMessage().popLong();
        peer.undelivered_msgs.clear();
        peer.nacked = null;
        peer.rounds_msg_recv = 0;
        peer.last_channel = ev.getChannel();
        log.debug((Object)("Received Ignore from " + peer.addr.toString() + " with value " + peer.last_msg_delivered));
    }

    private void handleUpdate(UpdateEvent ev) {
        Peer peer = (Peer)this.peers.get(ev.source);
        if (peer == null) {
            peer = this.createPeer(ev.source, this.last_msg_sent, ev.getChannel());
        }
        if ((ev.from = this.utils.popSeq(ev.getMessage(), peer.last_msg_delivered, false)) < 0L) {
            log.debug((Object)"Received incorrect Update. Discarding.");
            return;
        }
        ev.to = this.utils.popSeq(ev.getMessage(), peer.last_msg_delivered, false);
        if (ev.to < 0L) {
            log.debug((Object)"Received incorrect Update. Discarding.");
            return;
        }
        this.receive(peer, ev, ev.from, ev.to);
    }

    private void handleConfirm(ConfirmEvent ev) {
        Peer peer = (Peer)this.peers.get(ev.source);
        if (peer == null) {
            log.debug((Object)("Received Confirm from unknown peer (" + ev.source + "). Discarding it."));
            return;
        }
        long confirmed = this.utils.popSeq(ev.getMessage(), peer.last_msg_confirmed, false);
        if (confirmed < 0L) {
            log.debug((Object)("Problems reading confirm sequence number from " + ev.source));
            return;
        }
        this.confirmed(peer, confirmed, ev.getChannel());
    }

    private void sending(SendableEvent ev, Object addr, long seq) throws AppiaEventException, CloneNotSupportedException {
        Peer peer = (Peer)this.peers.get(addr);
        if (peer == null) {
            peer = this.createPeer(addr, seq - 1L, ev.getChannel());
        }
        if (seq > peer.last_msg_sent + 1L) {
            this.update(peer, seq - 1L, ev.getChannel());
        }
        peer.last_msg_sent = seq;
        this.storeUnconfirmed(peer, ev);
        peer.rounds_msg_sent = 0;
        if (!(ev instanceof PingEvent)) {
            peer.rounds_appl_msg = 0;
        }
        peer.last_channel = ev.getChannel();
    }

    private void receive(Peer peer, SendableEvent ev, long seqfrom, long seqto) {
        peer.rounds_msg_recv = 0;
        if (!(ev instanceof PingEvent) && !(ev instanceof UpdateEvent)) {
            peer.rounds_appl_msg = 0;
        }
        peer.last_channel = ev.getChannel();
        log.debug((Object)("Received event " + ev + " from " + peer.addr + " with seq " + seqfrom + " -> " + seqto));
        if (seqfrom <= peer.last_msg_delivered + 1L && seqto >= peer.last_msg_delivered + 1L) {
            try {
                if (!(ev instanceof PingEvent) && !(ev instanceof UpdateEvent)) {
                    ev.go();
                }
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
                return;
            }
            peer.last_msg_delivered = seqto;
            if (peer.undelivered_msgs.size() > 0) {
                long undelivered = this.deliverUndelivered(peer);
                this.debugPeer(peer, "receive1(" + seqfrom + "," + undelivered + ")");
                if (peer.nacked != null && peer.last_msg_delivered >= peer.nacked.last_msg) {
                    peer.nacked = null;
                }
                if (peer.nacked == null && undelivered >= 0L) {
                    this.nack(peer, peer.last_msg_delivered + 1L, undelivered - 1L, ev.getChannel());
                }
            }
        } else {
            if (seqto <= peer.last_msg_delivered) {
                log.debug((Object)("Received old message from " + peer.addr.toString() + ". Discarding."));
                return;
            }
            log.debug((Object)("Storing undelivered from " + peer.addr + " with seq " + seqfrom));
            this.storeUndelivered(peer, ev, seqfrom);
            if (peer.nacked == null) {
                this.nack(peer, peer.last_msg_delivered + 1L, seqfrom - 1L, ev.getChannel());
            }
        }
    }

    private void confirmed(Peer peer, long peer_confirmed, Channel channel) {
        if (peer_confirmed >= peer.first_msg_sent && peer_confirmed <= peer.last_msg_sent) {
            if (peer_confirmed > peer.last_msg_confirmed) {
                this.removeUnconfirmed(peer, peer_confirmed);
            }
        } else if (peer_confirmed > this.last_msg_sent) {
            log.debug((Object)("Received wrong peer confirmed number (expected between " + peer.first_msg_sent + " and " + this.last_msg_sent + ", received " + peer_confirmed + " from " + peer.addr + ". Sending Ignore."));
            this.ignore(peer, channel);
        }
    }

    private void nack(Peer peer, long first, long last, Channel channel) {
        if (first > last) {
            this.debugPeer(peer, "nack error");
            throw new AppiaError("first(" + first + ") > last(" + last + ")");
        }
        try {
            NackEvent nack = new NackEvent(channel, this);
            nack.getMessage().pushLong(last);
            nack.getMessage().pushLong(first);
            nack.dest = peer.addr;
            nack.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
            log.warn((Object)"Impossible to send Nack. Maybe next time.");
            return;
        }
        peer.nacked = new Nacked(first, last);
        log.warn((Object)("nacked: " + first + " - " + last + " (" + (last - first) + ")"));
        this.debugPeer(peer, "nack");
    }

    private void ignore(Peer peer, Channel channel) {
        try {
            IgnoreEvent ev = new IgnoreEvent(channel, this);
            ev.getMessage().pushLong(peer.last_msg_confirmed);
            ev.dest = peer.addr;
            ev.go();
            log.debug((Object)("Sent Ignore with " + peer.last_msg_confirmed + " to " + peer.addr));
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
            log.warn((Object)"Unable to send Ignore later it will be retransmited.");
            return;
        }
        peer.rounds_msg_sent = 0;
    }

    private void update(Peer peer, long to, Channel channel) {
        try {
            UpdateEvent update = new UpdateEvent(channel, this);
            update.from = peer.last_msg_sent + 1L;
            update.to = to;
            update.dest = peer.addr;
            UpdateEvent clone = (UpdateEvent)update.cloneEvent();
            this.storeUnconfirmed(peer, clone);
            this.utils.pushSeq(update.getMessage(), update.to);
            this.utils.pushSeq(update.getMessage(), update.from);
            update.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
            log.error((Object)"Unable to send or store update.");
            throw new AppiaError("Don't know how to solve this problem. Aborting.");
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            log.error((Object)"Unable to send or store update.");
            throw new AppiaError("Don't know how to solve this problem. Aborting.");
        }
        peer.last_msg_sent = to;
        peer.rounds_msg_sent = 0;
    }

    private void confirm(Peer peer) {
        try {
            ConfirmEvent ev = new ConfirmEvent(peer.last_channel, this);
            this.utils.pushSeq(ev.getMessage(), peer.last_msg_delivered);
            ev.dest = peer.addr;
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
            log.warn((Object)"Unable to send ConfirmEvent. Continuing.");
            return;
        }
        peer.last_confirm_sent = peer.last_msg_delivered;
        log.debug((Object)("Sent Confirm " + peer.last_confirm_sent + " to " + peer.addr));
    }

    private void storeUnconfirmed(Peer peer, SendableEvent ev) {
        boolean cfr_ignored_0 = ev instanceof UpdateEvent;
        peer.unconfirmed_msgs.addLast(ev);
        int size = peer.unconfirmed_msgs.size();
        if (size / 500 > 0 && size % 500 == 0) {
            log.warn((Object)("Unconfirmed reached " + peer.unconfirmed_msgs.size()));
        }
    }

    private void removeUnconfirmed(Peer peer, long last) {
        while (peer.last_msg_confirmed < last) {
            SendableEvent ev = (SendableEvent)peer.unconfirmed_msgs.removeFirst();
            if (ev instanceof UpdateEvent) {
                peer.last_msg_confirmed = ((UpdateEvent)ev).to;
                continue;
            }
            ++peer.last_msg_confirmed;
        }
    }

    private void resend(Peer peer, long first, long last) {
        ListIterator aux = peer.unconfirmed_msgs.listIterator();
        long seq = peer.last_msg_confirmed;
        while (aux.hasNext() && seq <= last) {
            SendableEvent evaux = (SendableEvent)aux.next();
            if (evaux instanceof UpdateEvent) {
                UpdateEvent update = (UpdateEvent)evaux;
                seq = update.to;
                if ((update.from < first || update.from > last) && (update.to < first || update.to > last)) continue;
                try {
                    UpdateEvent ev = (UpdateEvent)update.cloneEvent();
                    ev.setSourceSession(this);
                    ev.init();
                    this.utils.pushSeq(ev.getMessage(), update.to);
                    this.utils.pushSeq(ev.getMessage(), update.from);
                    ev.dest = peer.addr;
                    ev.go();
                    peer.rounds_msg_sent = 0;
                }
                catch (AppiaEventException ex1) {
                    ex1.printStackTrace();
                }
                catch (CloneNotSupportedException ex2) {
                    ex2.printStackTrace();
                }
                continue;
            }
            if (++seq < first || seq > last) continue;
            try {
                SendableEvent ev = (SendableEvent)evaux.cloneEvent();
                ev.setSourceSession(this);
                ev.init();
                this.utils.pushSeq(ev.getMessage(), seq);
                ev.getMessage().pushByte((byte)0);
                ev.dest = peer.addr;
                ev.go();
                peer.rounds_msg_sent = 0;
            }
            catch (AppiaEventException ex1) {
                ex1.printStackTrace();
            }
            catch (CloneNotSupportedException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private void storeUndelivered(Peer peer, SendableEvent ev, long seq) {
        if (!(ev instanceof UpdateEvent)) {
            this.utils.pushSeq(ev.getMessage(), seq);
        }
        ListIterator<SendableEvent> aux = peer.undelivered_msgs.listIterator(peer.undelivered_msgs.size());
        while (aux.hasPrevious()) {
            long seqaux;
            SendableEvent evaux = (SendableEvent)aux.previous();
            if (evaux instanceof UpdateEvent) {
                UpdateEvent update = (UpdateEvent)evaux;
                if (seq >= update.from && seq <= update.to) {
                    log.debug((Object)"Received undelivered message already stored. Discarding new copy.");
                    return;
                }
                seqaux = update.to;
            } else {
                seqaux = this.utils.popSeq(evaux.getMessage(), peer.last_msg_delivered, true);
                if (seqaux == seq) {
                    log.debug((Object)"Received undelivered message already stored. Discarding new copy.");
                    return;
                }
            }
            if (seqaux >= seq) continue;
            aux.next();
            aux.add(ev);
            return;
        }
        peer.undelivered_msgs.addFirst(ev);
    }

    private long deliverUndelivered(Peer peer) {
        ListIterator aux = peer.undelivered_msgs.listIterator();
        while (aux.hasNext()) {
            SendableEvent evaux = (SendableEvent)aux.next();
            if (evaux instanceof UpdateEvent) {
                UpdateEvent update = (UpdateEvent)evaux;
                if (update.to <= peer.last_msg_delivered) {
                    log.debug((Object)("Discarded unwanted event from " + peer.addr + " with seq " + update.from + " -> " + update.to));
                    aux.remove();
                    continue;
                }
                if (update.from == peer.last_msg_delivered + 1L) {
                    peer.last_msg_delivered = update.to;
                    aux.remove();
                    continue;
                }
                return update.from;
            }
            long seqaux = this.utils.popSeq(evaux.getMessage(), peer.last_msg_delivered, true);
            if (seqaux <= peer.last_msg_delivered) {
                log.debug((Object)("Discarded unwanted event from " + peer.addr + " with seq " + seqaux));
                aux.remove();
                continue;
            }
            if (seqaux == peer.last_msg_delivered + 1L) {
                if (!(evaux instanceof PingEvent)) {
                    try {
                        evaux.getMessage().discard(4);
                        evaux.go();
                    }
                    catch (AppiaEventException ex) {
                        ex.printStackTrace();
                        log.debug((Object)("Discarding event " + evaux + ". This may lead to incoherence."));
                    }
                }
                peer.last_msg_delivered = seqaux;
                aux.remove();
                continue;
            }
            return seqaux;
        }
        return -1L;
    }

    private Peer createPeer(Object addr, long init, Channel channel) {
        Peer peer = new Peer(addr, init);
        this.peers.put(peer.addr, peer);
        this.ignore(peer, channel);
        return peer;
    }

    private void sendFIFOUndelivered(SendableEvent ev, Object addr) {
        if (ev instanceof PingEvent) {
            return;
        }
        try {
            SendableEvent clone = (SendableEvent)ev.cloneEvent();
            clone.dest = addr;
            FIFOUndeliveredEvent e = new FIFOUndeliveredEvent(ev.getChannel(), this, clone);
            e.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
            log.warn((Object)"Unable to send Undelivered notification. Continuing but problems may happen.");
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            log.warn((Object)"Unable to send Undelivered notification. Continuing but problems may happen.");
        }
    }

    private void sendTimer(Channel channel) {
        try {
            NakFifoTimer timer = new NakFifoTimer(this.param_TIMER_PERIOD, channel, (Session)this, 0);
            timer.go();
            this.timerChannel = channel;
        }
        catch (AppiaException ex) {
            log.warn((Object)"Unable to send timer. Correct operation of session is not guaranteed.");
        }
    }

    private void debugPeer(Peer peer, String s) {
        if (log.isDebugEnabled()) {
            SendableEvent ev;
            s = "@" + s + " Peer: " + peer.addr.toString() + "\n";
            s = String.valueOf(s) + "\t First Msg Sent: " + peer.first_msg_sent + "\n";
            s = String.valueOf(s) + "\t Last Msg Sent/Confirmed: " + peer.last_msg_sent + "/" + peer.last_msg_confirmed + "\n";
            s = String.valueOf(s) + "\t Last Msg Delivered: " + peer.last_msg_delivered + "\n";
            s = String.valueOf(s) + "\t Rounds Appl/Sent/Recv: " + peer.rounds_appl_msg + "/" + peer.rounds_msg_sent + "/" + peer.rounds_msg_recv + "\n";
            int limit = 10;
            s = String.valueOf(s) + "\t Unconfirmed Msgs:\n";
            ListIterator iter = peer.unconfirmed_msgs.listIterator();
            long l = peer.last_msg_confirmed;
            while (iter.hasNext()) {
                ev = (SendableEvent)iter.next();
                s = String.valueOf(s) + "\t\t " + ++l + ": " + ev + "\n";
                if (--limit > 0) continue;
                s = String.valueOf(s) + "\t\t  ...\n";
                break;
            }
            limit = 10;
            s = String.valueOf(s) + "\t Undelivered Msgs:\n";
            iter = peer.undelivered_msgs.listIterator();
            while (iter.hasNext()) {
                ev = (SendableEvent)iter.next();
                l = this.utils.popSeq(ev.getMessage(), peer.last_msg_delivered, true);
                s = String.valueOf(s) + "\t\t " + l + ": " + ev + "\n";
                if (--limit > 0) continue;
                s = String.valueOf(s) + "\t\t  ...\n";
                break;
            }
            s = String.valueOf(s) + "\t Nacked First/Last/Rounds: ";
            s = peer.nacked == null ? String.valueOf(s) + "null\n" : String.valueOf(s) + peer.nacked.first_msg + "/" + peer.nacked.last_msg + "/" + peer.nacked.rounds + "\n";
            s = String.valueOf(s) + "\t Channel: " + peer.last_channel + "\n";
            log.debug((Object)s);
        }
    }
}

