/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.sslcomplete;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory sunFactory;
    private String[] anon_cipher_suites = null;
    private boolean anon = false;

    public CustomSSLSocketFactory(SSLContext ctx, boolean anon) {
        this.anon = anon;
        this.sunFactory = ctx.getSocketFactory();
        if (anon) {
            String[] sunSuites = this.sunFactory.getSupportedCipherSuites();
            String[] aux = new String[sunSuites.length];
            int j = 0;
            for (int i = 0; i < sunSuites.length; ++i) {
                if (sunSuites[i].indexOf("anon") < 0) continue;
                aux[j++] = sunSuites[i];
            }
            this.anon_cipher_suites = new String[j];
            System.arraycopy(aux, 0, this.anon_cipher_suites, 0, j);
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket s = (SSLSocket)this.sunFactory.createSocket();
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int param) throws IOException {
        SSLSocket s = (SSLSocket)this.sunFactory.createSocket(inetAddress, param);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public Socket createSocket(String str, int param) throws IOException, UnknownHostException {
        SSLSocket s = (SSLSocket)this.sunFactory.createSocket(str, param);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public Socket createSocket(Socket socket, String str, int param, boolean param3) throws IOException {
        SSLSocket s = (SSLSocket)this.sunFactory.createSocket(socket, str, param, param3);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int param, InetAddress inetAddress2, int param3) throws IOException {
        SSLSocket s = (SSLSocket)this.sunFactory.createSocket(inetAddress, param, inetAddress2, param3);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public Socket createSocket(String str, int param, InetAddress inetAddress, int param3) throws IOException, UnknownHostException {
        SSLSocket s = (SSLSocket)this.sunFactory.createSocket(str, param, inetAddress, param3);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        if (this.anon) {
            return this.anon_cipher_suites;
        }
        return this.sunFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sunFactory.getSupportedCipherSuites();
    }
}

