/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.sslcomplete;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Hashtable;
import java.util.Random;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Direction;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.events.AppiaMulticast;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.protocols.common.RegisterSocketEvent;
import net.sf.appia.protocols.sslcomplete.CustomSSLServerSocketFactory;
import net.sf.appia.protocols.sslcomplete.CustomSSLSocketFactory;
import net.sf.appia.protocols.sslcomplete.SslRegisterSocketEvent;
import net.sf.appia.protocols.tcpcomplete.AcceptReader;
import net.sf.appia.protocols.tcpcomplete.SocketInfoContainer;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteSession;
import net.sf.appia.protocols.utils.HostUtils;
import net.sf.appia.protocols.utils.ParseUtils;
import net.sf.appia.xml.interfaces.InitializableSession;
import net.sf.appia.xml.utils.SessionProperties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SslCompleteSession
extends TcpCompleteSession
implements InitializableSession {
    private SSLServerSocketFactory ssf = null;
    private SSLSocketFactory sf = null;
    private String protocol = "SSL";
    private String certificateManagers = "SunX509";
    private String keyStore = "JKS";
    private String keystoreFile = null;
    private char[] passphrase = null;
    private String[] enabledCiphers = null;
    private static Logger log = Logger.getLogger(SslCompleteSession.class);

    public SslCompleteSession(Layer layer) {
        super(layer);
    }

    @Override
    public void init(SessionProperties props) {
        super.init(props);
        if (props.containsKey("protocol")) {
            this.protocol = props.getString("protocol");
        }
        if (props.containsKey("certificate_managers")) {
            this.certificateManagers = props.getString("certificate_managers");
        }
        if (props.containsKey("keystore")) {
            this.keyStore = props.getString("keystore");
        }
        if (props.containsKey("keystore_file")) {
            this.keystoreFile = props.getString("keystore_file");
        }
        if (props.containsKey("passphrase")) {
            this.passphrase = props.getCharArray("passphrase");
        }
        if (props.containsKey("enabled_ciphers")) {
            this.enabledCiphers = props.getString("enabled_ciphers").split(",");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SSL parameters after XML init:\n[protocol=" + this.protocol + " certificate_managers=" + this.certificateManagers + " key_store=" + this.keyStore + " keystore_file=" + this.keystoreFile + " passphrase=" + new String(this.passphrase) + " enabled_ciphers=" + this.enabledCiphers + "]"));
        }
    }

    @Override
    public void handle(Event e) {
        if (e instanceof SendableEvent) {
            this.handleSendable((SendableEvent)e);
        } else if (e instanceof SslRegisterSocketEvent) {
            this.handleSslRegisterSocket((SslRegisterSocketEvent)e);
        } else if (e instanceof RegisterSocketEvent) {
            this.handleRegisterSocket((RegisterSocketEvent)e);
        } else {
            super.handle(e);
        }
    }

    private void handleSendable(SendableEvent e) {
        Object[] valids = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Preparing to send event " + e));
        }
        if (e.dest instanceof AppiaMulticast) {
            Object[] dests = ((AppiaMulticast)e.dest).getDestinations();
            int i = 0;
            while (i < dests.length) {
                if (dests[i] instanceof InetSocketAddress) {
                    if (!this.validate((InetSocketAddress)dests[i], e.getChannel())) {
                        if (valids == null) {
                            valids = new Object[dests.length];
                            System.arraycopy(dests, 0, valids, 0, i);
                        }
                        valids[i] = null;
                        this.sendUndelivered(e.getChannel(), (InetSocketAddress)dests[i]);
                    } else if (valids != null) {
                        valids[i] = dests[i];
                    }
                } else {
                    this.sendUndelivered(e.getChannel(), (InetSocketAddress)dests[i]);
                }
                ++i;
            }
        } else if (e.dest instanceof InetSocketAddress) {
            if (!this.validate((InetSocketAddress)e.dest, e.getChannel())) {
                this.sendUndelivered(e.getChannel(), (InetSocketAddress)e.dest);
            }
        } else {
            this.sendUndelivered(e.getChannel(), (InetSocketAddress)e.dest);
        }
        if (valids != null) {
            int tam = 0;
            int j = 0;
            int i = 0;
            while (i < valids.length) {
                if (valids[i] != null) {
                    ++tam;
                }
                ++i;
            }
            Object[] trimmedDests = new Object[tam];
            i = 0;
            while (i < valids.length) {
                if (valids[i] != null) {
                    trimmedDests[j] = valids[i];
                    ++j;
                }
                ++i;
            }
            e.dest = new AppiaMulticast(((AppiaMulticast)e.dest).getMulticastAddress(), trimmedDests);
        }
        super.handle(e);
    }

    private boolean validate(InetSocketAddress dest, Channel channel) {
        block9: {
            block8: {
                try {
                    if (!this.existsSocket(this.ourReaders, dest)) break block8;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"recognized our ssl socket. sending...");
                    }
                    return true;
                }
                catch (IOException ex) {
                    if (log.isDebugEnabled()) {
                        ex.printStackTrace();
                        log.debug((Object)("Member " + dest.toString() + " has failed."));
                    }
                    this.sendUndelivered(channel, dest);
                    return false;
                }
            }
            if (!this.existsSocket(this.otherReaders, dest)) break block9;
            if (log.isDebugEnabled()) {
                log.debug((Object)"recognized other ssl socket. sending...");
            }
            return true;
        }
        if (this.createSSLSocket(this.ourReaders, dest, channel) != null && log.isDebugEnabled()) {
            log.debug((Object)"created new ssl socket, sending...");
        }
        return true;
    }

    @Override
    protected void handleRegisterSocket(RegisterSocketEvent e) {
        block2: {
            int bindedPort;
            e.port = bindedPort = this.registerWithSSL(e.port, e.getChannel());
            e.localHost = HostUtils.getLocalAddress();
            e.error = bindedPort < 0;
            e.setDir(Direction.invert(e.getDir()));
            e.setSourceSession(this);
            try {
                e.init();
                e.go();
            }
            catch (AppiaEventException ex) {
                if (!log.isDebugEnabled()) break block2;
                ex.printStackTrace();
            }
        }
    }

    private void handleSslRegisterSocket(SslRegisterSocketEvent e) {
        block3: {
            int bindedPort;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received SSL register socket event: " + e));
            }
            this.protocol = e.protocol;
            this.certificateManagers = e.certificateManagers;
            this.keyStore = e.keyStore;
            this.keystoreFile = e.keystoreFile;
            this.passphrase = e.passphrase;
            this.enabledCiphers = e.enabledCiphers;
            e.port = bindedPort = this.registerWithSSL(e.port, e.getChannel());
            e.error = bindedPort < 0;
            e.setDir(Direction.invert(e.getDir()));
            e.setSourceSession(this);
            try {
                e.init();
                e.go();
            }
            catch (AppiaEventException ex) {
                if (!log.isDebugEnabled()) break block3;
                ex.printStackTrace();
            }
        }
    }

    private int registerWithSSL(int port, Channel channel) {
        SSLServerSocket ss = null;
        try {
            SSLContext ctx = SSLContext.getInstance(this.protocol);
            if (this.keystoreFile != null) {
                KeyStore ks = KeyStore.getInstance(this.keyStore);
                ks.load(new FileInputStream(this.keystoreFile), this.passphrase);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.certificateManagers);
                kmf.init(ks, this.passphrase);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.certificateManagers);
                tmf.init(ks);
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                this.ssf = ctx.getServerSocketFactory();
                this.sf = ctx.getSocketFactory();
            } else {
                ctx.init(null, null, null);
                this.ssf = new CustomSSLServerSocketFactory(ctx, true);
                this.sf = new CustomSSLSocketFactory(ctx, true);
            }
            if (log.isDebugEnabled()) {
                String output = "Configuration dump:\n";
                output = String.valueOf(output) + "--> Server Supported cipher suites\n";
                String[] suites = this.ssf.getSupportedCipherSuites();
                int i = 0;
                while (i < suites.length) {
                    output = String.valueOf(output) + suites[i] + "\n";
                    ++i;
                }
                output = String.valueOf(output) + "--> Server Default cipher suites\n";
                suites = this.ssf.getDefaultCipherSuites();
                i = 0;
                while (i < suites.length) {
                    output = String.valueOf(output) + suites[i] + "\n";
                    ++i;
                }
                output = String.valueOf(output) + "--> Client Supported cipher suites\n";
                suites = this.sf.getSupportedCipherSuites();
                i = 0;
                while (i < suites.length) {
                    output = String.valueOf(output) + suites[i] + "\n";
                    ++i;
                }
                output = String.valueOf(output) + "--> Client Default cipher suites\n";
                suites = this.sf.getDefaultCipherSuites();
                i = 0;
                while (i < suites.length) {
                    output = String.valueOf(output) + suites[i] + "\n";
                    ++i;
                }
                log.debug((Object)output);
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            log.warn((Object)("An error ocurred when initializing SSL session though the SSL register socket event: " + ex.getMessage()));
            return -1;
        }
        if (port == 0) {
            try {
                ss = (SSLServerSocket)this.ssf.createServerSocket(0);
                port = ss.getLocalPort();
            }
            catch (IOException ex) {
                return -1;
            }
        }
        if (port == -1) {
            Random rand = new Random();
            boolean done = false;
            while (!done) {
                int p = rand.nextInt(Short.MAX_VALUE);
                try {
                    ss = (SSLServerSocket)this.ssf.createServerSocket(p);
                    done = true;
                    port = ss.getLocalPort();
                }
                catch (IllegalArgumentException ex) {
                    if (!log.isDebugEnabled()) continue;
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    if (!log.isDebugEnabled()) continue;
                    ex.printStackTrace();
                }
            }
        } else if (port > 0) {
            try {
                ss = (SSLServerSocket)this.ssf.createServerSocket(port);
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                port = -1;
            }
        }
        if (port > 0) {
            this.acceptThread = new AcceptReader(ss, this, channel, this.socketLock);
            Thread t = channel.getThreadFactory().newThread(this.acceptThread);
            t.setName("TCP SSL accept reader");
            t.start();
            this.ourPort = ss.getLocalPort();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Local port is " + this.ourPort));
            }
        } else {
            this.ourPort = -1;
        }
        return this.ourPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket createSSLSocket(Hashtable<InetSocketAddress, SocketInfoContainer> hm, InetSocketAddress iwp, Channel channel) throws IOException {
        Object object = this.socketLock;
        synchronized (object) {
            SSLSocket newSocket;
            block5: {
                newSocket = null;
                if (this.sf != null) break block5;
                return null;
            }
            newSocket = (SSLSocket)this.sf.createSocket(iwp.getAddress(), iwp.getPort());
            newSocket.setTcpNoDelay(true);
            byte[] bPort = ParseUtils.intToByteArray(this.ourPort);
            newSocket.getOutputStream().write(bPort);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending our original port " + this.ourPort));
            }
            this.addSocket(hm, iwp, newSocket, channel);
            return newSocket;
        }
    }
}

