/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.tcpcomplete;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import net.sf.appia.core.Channel;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteSession;
import net.sf.appia.protocols.utils.ParseUtils;
import org.apache.log4j.Logger;

public class AcceptReader
implements Runnable {
    private static Logger log = Logger.getLogger(AcceptReader.class);
    private static final int INT_SIZE = 4;
    private ServerSocket socket;
    private TcpCompleteSession session;
    private Channel channel;
    private Object lock;
    private boolean running;

    public AcceptReader(ServerSocket ss, TcpCompleteSession s, Channel channel, Object lock) {
        this.socket = ss;
        try {
            this.socket.setSoTimeout(s.param_SOTIMEOUT);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        this.session = s;
        this.channel = channel;
        this.lock = lock;
        this.setRunning(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning()) {
            Socket newSocket;
            block19: {
                newSocket = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"accepting connections");
                }
                try {
                    newSocket = this.socket.accept();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"new connection");
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException ex) {
                    if (!this.isRunning()) break block19;
                    ex.printStackTrace();
                }
            }
            if (newSocket == null) continue;
            try {
                int remotePort = this.initProto(newSocket);
                InetSocketAddress iwp = new InetSocketAddress(newSocket.getInetAddress(), remotePort);
                Object object = this.lock;
                synchronized (object) {
                    if (this.session.existsSocket(this.session.ourReaders, iwp)) {
                        this.session.addSocket(this.session.otherReaders, iwp, newSocket, this.channel);
                    } else {
                        this.session.addSocket(this.session.ourReaders, iwp, newSocket, this.channel);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"created socket");
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"error initiating connection. closing connection.");
                }
                try {
                    newSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int initProto(Socket socket) throws IOException {
        byte[] bufferPort = new byte[4];
        this.receiveNBytes(socket.getInputStream(), bufferPort, 4);
        int port = ParseUtils.byteArrayToInt(bufferPort, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("received remote port:: " + port));
        }
        return port;
    }

    private int receiveNBytes(InputStream is, byte[] b, int length) throws IOException {
        int n;
        int i = 0;
        for (n = 0; n != length && i != -1; n += i) {
            i = is.read(b, n, length - n);
        }
        if (i == -1) {
            throw new IOException();
        }
        return n;
    }

    public synchronized void setRunning(boolean r) {
        this.running = r;
        if (!this.running) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

