/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.tcpcomplete;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.sf.appia.core.TimeProvider;
import net.sf.appia.protocols.tcpcomplete.Measure;
import net.sf.appia.protocols.tcpcomplete.SHook;

public class Benchmark {
    public static final boolean ON = false;
    private static Benchmark inst;
    private Map hash = Collections.synchronizedMap(new HashMap());
    private Runnable shHook = new SHook(this.hash);
    private TimeProvider timeProvider = null;

    public static Benchmark getInstance(TimeProvider tp, ThreadFactory thf) {
        return null;
    }

    private Benchmark(TimeProvider tp, ThreadFactory threadFactory) {
        this.timeProvider = tp;
        Thread hook = threadFactory.newThread(this.shHook);
        hook.setName("Benchmark Shutdown Hook");
        Runtime.getRuntime().addShutdownHook(hook);
    }

    public void startTagged(String s, String tag) {
        this.startBench(s + tag);
    }

    public void stopTagged(String s, String tag) {
        this.stopBench(s + tag);
        Measure m = (Measure)this.hash.get(s + tag);
        this.indepBench(s, m.totalTime);
        this.hash.remove(s + tag);
    }

    public void startBench(String s) {
        Measure m = (Measure)this.hash.get(s);
        if (m == null) {
            m = new Measure();
            m.numRuns = 0L;
            m.totalTime = 0L;
            m.name = s;
            m.sTime = this.timeProvider.currentTimeMillis();
            this.hash.put(s, m);
        } else {
            m.sTime = this.timeProvider.currentTimeMillis();
        }
    }

    public void stopBench(String s) {
        Measure m = (Measure)this.hash.get(s);
        long end = this.timeProvider.currentTimeMillis() - m.sTime;
        m.totalTime += end;
        ++m.numRuns;
    }

    public void indepBench(String s, long time) {
        Measure m = (Measure)this.hash.get(s);
        if (m == null) {
            m = new Measure();
            m.numRuns = 1L;
            m.totalTime = time;
            m.name = s;
            this.hash.put(s, m);
        } else {
            m.totalTime += time;
            ++m.numRuns;
        }
    }
}

