/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.tcpcomplete;

import java.util.Hashtable;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import net.sf.appia.core.TimeProvider;
import net.sf.appia.management.AppiaManagementException;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteSession;

public class Measures {
    public static final String THRPUT_MSG_PER_SECOND_UP = "msg_per_second_up";
    public static final String THRPUT_MSG_PER_SECOND_DOWN = "msg_per_second_down";
    public static final String THRPUT_BYTES_PER_SECOND_UP = "bytes_per_second_up";
    public static final String THRPUT_BYTES_PER_SECOND_DOWN = "bytes_per_second_down";
    public static final String REFRESH_INTERVAL = "refresh_interval";
    public static final String QUEUE_SIZE = "queue_size";
    private static final float MINIMUM_VALUE = 0.05f;
    private static final long DEFAULT_REFRESH_INTERVAL = 5000L;
    private Throughput msgPerSecondUp;
    private Throughput msgPerSecondDown;
    private Throughput bytesPerSecondUp;
    private Throughput bytesPerSecondDown;
    private Map<String, String> jmxFeaturesMap = new Hashtable<String, String>();
    private long refreshInterval = 5000L;
    private TcpCompleteSession session;

    public Measures(TimeProvider tp, TcpCompleteSession s) {
        this.msgPerSecondUp = new Throughput(tp);
        this.msgPerSecondDown = new Throughput(tp);
        this.bytesPerSecondUp = new Throughput(tp);
        this.bytesPerSecondDown = new Throughput(tp);
        this.session = s;
    }

    public Measures(TcpCompleteSession s) {
        this.msgPerSecondUp = new Throughput();
        this.msgPerSecondDown = new Throughput();
        this.bytesPerSecondUp = new Throughput();
        this.bytesPerSecondDown = new Throughput();
        this.session = s;
    }

    public void setTimeProvider(TimeProvider tp) {
        this.msgPerSecondUp.setTimeProvider(tp);
        this.msgPerSecondDown.setTimeProvider(tp);
        this.bytesPerSecondUp.setTimeProvider(tp);
        this.bytesPerSecondDown.setTimeProvider(tp);
    }

    public void countMessagesUp(int count) {
        this.msgPerSecondUp.add(count);
    }

    public void countMessagesDown(int count) {
        this.msgPerSecondDown.add(count);
    }

    public void countBytesUp(int count) {
        this.bytesPerSecondUp.add(count);
    }

    public void countBytesDown(int count) {
        this.bytesPerSecondDown.add(count);
    }

    private Object getParameter(String parameter) throws AppiaManagementException {
        if (parameter.equals(THRPUT_MSG_PER_SECOND_UP)) {
            return Float.valueOf(this.msgPerSecondUp.get());
        }
        if (parameter.equals(THRPUT_MSG_PER_SECOND_DOWN)) {
            return Float.valueOf(this.msgPerSecondDown.get());
        }
        if (parameter.equals(THRPUT_BYTES_PER_SECOND_UP)) {
            return Float.valueOf(this.bytesPerSecondUp.get());
        }
        if (parameter.equals(THRPUT_BYTES_PER_SECOND_DOWN)) {
            return Float.valueOf(this.bytesPerSecondDown.get());
        }
        if (parameter.equals(REFRESH_INTERVAL)) {
            return this.refreshInterval;
        }
        if (parameter.equals(QUEUE_SIZE)) {
            return this.session.getGlobalQueueSize();
        }
        throw new AppiaManagementException("Parameter '" + parameter + "' not defined in session " + this.getClass().getName());
    }

    private void setParameter(String parameter, Object newValue) throws AppiaManagementException {
        if (parameter.equals(REFRESH_INTERVAL)) {
            this.refreshInterval = (Long)newValue;
            return;
        }
        throw new AppiaManagementException("Parameter '" + parameter + "' not defined in session " + this.getClass().getName());
    }

    public Object invoke(String action, MBeanOperationInfo info, Object[] params, String[] signature) throws AppiaManagementException {
        throw new AppiaManagementException("The Session " + this.getClass().getName() + " does not accept any parameter to set a new value. It is read only.");
    }

    public MBeanAttributeInfo[] getAttributes(String sid) {
        this.jmxFeaturesMap.put(sid + THRPUT_BYTES_PER_SECOND_DOWN, THRPUT_BYTES_PER_SECOND_DOWN);
        this.jmxFeaturesMap.put(sid + THRPUT_BYTES_PER_SECOND_UP, THRPUT_BYTES_PER_SECOND_UP);
        this.jmxFeaturesMap.put(sid + THRPUT_MSG_PER_SECOND_DOWN, THRPUT_MSG_PER_SECOND_DOWN);
        this.jmxFeaturesMap.put(sid + THRPUT_MSG_PER_SECOND_UP, THRPUT_MSG_PER_SECOND_UP);
        this.jmxFeaturesMap.put(sid + REFRESH_INTERVAL, REFRESH_INTERVAL);
        this.jmxFeaturesMap.put(sid + QUEUE_SIZE, QUEUE_SIZE);
        return new MBeanAttributeInfo[]{new MBeanAttributeInfo(sid + THRPUT_BYTES_PER_SECOND_DOWN, "float", "gets the throughput value", true, false, false), new MBeanAttributeInfo(sid + THRPUT_BYTES_PER_SECOND_UP, "float", "gets the throughput value", true, false, false), new MBeanAttributeInfo(sid + THRPUT_MSG_PER_SECOND_DOWN, "float", "gets the throughput value", true, false, false), new MBeanAttributeInfo(sid + THRPUT_MSG_PER_SECOND_UP, "float", "gets the throughput value", true, false, false), new MBeanAttributeInfo(sid + REFRESH_INTERVAL, "long", "gets and sets the refresh interval", true, true, false), new MBeanAttributeInfo(sid + QUEUE_SIZE, "long", "gets the queue size of sending messages", true, false, false)};
    }

    public Object attributeGetter(String attribute, MBeanAttributeInfo info) throws AppiaManagementException {
        return this.getParameter(this.jmxFeaturesMap.get(attribute));
    }

    public void attributeSetter(Attribute attribute, MBeanAttributeInfo info) throws AppiaManagementException {
        String att = this.jmxFeaturesMap.get(attribute.getName());
        System.out.println("call: " + attribute.getName() + " att " + att);
        this.setParameter(att, attribute.getValue());
    }

    class Throughput {
        private static final long SECOND_IN_MILLIS = 1000L;
        private TimeProvider timeProvider = null;
        private long counter = 0L;
        private long lastTime = 0L;
        private float rate = 0.0f;

        Throughput(TimeProvider time) {
            this.timeProvider = time;
            this.lastTime = this.getTime();
        }

        Throughput() {
            this.timeProvider = null;
            this.lastTime = this.getTime();
        }

        float get() {
            long currentTime = this.getTime();
            long diff = currentTime - this.lastTime;
            if (diff > Measures.this.refreshInterval && diff > 0L) {
                float myRate = (float)this.counter / (float)diff * 1000.0f;
                this.rate = myRate = myRate < 0.05f ? 0.0f : myRate;
                this.counter = 0L;
                this.lastTime = currentTime;
            }
            return this.rate;
        }

        void add(long value) {
            this.counter += value;
        }

        void setTimeProvider(TimeProvider tp) {
            this.timeProvider = tp;
        }

        long getTime() {
            return this.timeProvider == null ? System.currentTimeMillis() : this.timeProvider.currentTimeMillis();
        }

        public String toString() {
            return "" + this.get();
        }
    }
}

