/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.tcpcomplete;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SenderQueue<T> {
    private ConcurrentLinkedQueue<T> mailbox = new ConcurrentLinkedQueue();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition isEmpty = this.lock.newCondition();

    public void add(T item) {
        this.lock.lock();
        try {
            this.mailbox.add(item);
            this.isEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T removeNext() {
        this.lock.lock();
        try {
            while (this.mailbox.isEmpty()) {
                try {
                    this.isEmpty.await();
                }
                catch (InterruptedException e) {
                    T t = null;
                    this.lock.unlock();
                    return t;
                }
            }
            Object e = this.mailbox.remove();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T removeNext(long millis) {
        this.lock.lock();
        try {
            while (this.mailbox.isEmpty()) {
                try {
                    this.isEmpty.await(millis, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    T t = null;
                    this.lock.unlock();
                    return t;
                }
            }
            if (!this.mailbox.isEmpty()) {
                Object e = this.mailbox.remove();
                return (T)e;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getSize() {
        return this.mailbox.size();
    }
}

