/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.utils;

import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class HostUtils {
    public static final PrintStream debug = null;

    private HostUtils() {
    }

    public static InetAddress getLocalAddress() {
        NetworkInterface result_intf = null;
        InetAddress result_addr = null;
        Enumeration<InetAddress> eips = null;
        Enumeration<NetworkInterface> eintfs = null;
        try {
            eintfs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        while (eintfs != null && eintfs.hasMoreElements()) {
            NetworkInterface intf = eintfs.nextElement();
            eips = intf.getInetAddresses();
            while (eips.hasMoreElements()) {
                int rsnum;
                int snum;
                int begini;
                int i;
                InetAddress addr = eips.nextElement();
                HostUtils.debug("INTERFACE " + intf.getName() + "(" + intf.getDisplayName() + ") -> " + addr + "\n\t(Link Local ? " + addr.isLinkLocalAddress() + ") (Loopback ? " + addr.isLoopbackAddress() + ") (Site Local ? " + addr.isSiteLocalAddress() + ") (IPV4 ? " + (addr instanceof Inet4Address) + ") ");
                if (result_addr == null) {
                    result_addr = addr;
                    result_intf = intf;
                    HostUtils.debug(" CHOSEN: result was null");
                    continue;
                }
                if (!(result_addr instanceof Inet4Address) && addr instanceof Inet4Address) {
                    result_addr = addr;
                    result_intf = intf;
                    HostUtils.debug(" CHOSEN: address is IPv4");
                    continue;
                }
                if (result_addr instanceof Inet4Address != addr instanceof Inet4Address) continue;
                if (result_addr.isLinkLocalAddress() && !addr.isLinkLocalAddress()) {
                    result_addr = addr;
                    result_intf = intf;
                    HostUtils.debug(" CHOSEN: address wasn't Link Local");
                    continue;
                }
                if (result_addr.isLinkLocalAddress() != addr.isLinkLocalAddress()) continue;
                if (result_addr.isLoopbackAddress() && !addr.isLoopbackAddress()) {
                    result_addr = addr;
                    result_intf = intf;
                    HostUtils.debug(" CHOSEN: address wasn't Loopback");
                    continue;
                }
                if (result_addr.isLoopbackAddress() != addr.isLoopbackAddress()) continue;
                if (result_addr.isSiteLocalAddress() && !addr.isSiteLocalAddress()) {
                    result_addr = addr;
                    result_intf = intf;
                    HostUtils.debug(" CHOSEN: address wasn't Site Local");
                    continue;
                }
                if (result_addr.isSiteLocalAddress() != addr.isSiteLocalAddress()) continue;
                String s = intf.getName();
                String rs = result_intf.getName();
                for (i = 0; i < s.length() && !Character.isDigit(s.charAt(i)); ++i) {
                }
                if (i < s.length()) {
                    begini = i;
                    while (i < s.length() && Character.isDigit(s.charAt(i))) {
                        ++i;
                    }
                    snum = Integer.parseInt(s.substring(begini, i));
                } else {
                    snum = Integer.MAX_VALUE;
                }
                for (i = 0; i < rs.length() && !Character.isDigit(rs.charAt(i)); ++i) {
                }
                if (i < rs.length()) {
                    begini = i;
                    while (i < rs.length() && Character.isDigit(rs.charAt(i))) {
                        ++i;
                    }
                    rsnum = Integer.parseInt(rs.substring(begini, i));
                } else {
                    rsnum = Integer.MAX_VALUE;
                }
                if (snum < rsnum) {
                    result_addr = addr;
                    result_intf = intf;
                    HostUtils.debug(" CHOSEN: interface number was lower");
                    continue;
                }
                if (snum != rsnum || s.length() >= rs.length() && s.compareTo(rs) >= 0) continue;
                result_addr = addr;
                result_intf = intf;
                HostUtils.debug(" CHOSEN: interface name was lower");
            }
        }
        if (result_addr == null) {
            try {
                result_addr = InetAddress.getByName(null);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        HostUtils.debug("LOCAL ADDRESS -> " + result_addr);
        return result_addr;
    }

    public static boolean isLocalAddress(InetAddress address) {
        Enumeration<InetAddress> eips = null;
        Enumeration<NetworkInterface> eintfs = null;
        try {
            eintfs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        while (eintfs != null && eintfs.hasMoreElements()) {
            NetworkInterface intf = eintfs.nextElement();
            eips = intf.getInetAddresses();
            while (eips.hasMoreElements()) {
                InetAddress addr = eips.nextElement();
                if (!address.equals(addr)) continue;
                return true;
            }
        }
        return false;
    }

    private static void debug(String s) {
        if (debug != null) {
            debug.println("[HostUtils.getLocalAddress()] :" + s);
        }
    }

    public static void main(String[] args) {
        System.out.println("\nHostUtils.getLocalAddress()=" + HostUtils.getLocalAddress());
    }
}

