/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static InetSocketAddress[] parseSocketAddressArray(String s, InetAddress defaultHost, int defaultPort) throws ParseException, UnknownHostException {
        int separator = 44;
        int isep = -1;
        int count = 1;
        while (isep < s.length() && (isep = s.indexOf(44, isep + 1)) >= 0) {
            ++count;
        }
        InetSocketAddress[] result = new InetSocketAddress[count];
        int j = 0;
        isep = -1;
        while (isep < s.length()) {
            int previsep = isep;
            if ((isep = s.indexOf(44, previsep + 1)) < 0) {
                isep = s.length();
            }
            if (isep > previsep + 1) {
                try {
                    result[j++] = ParseUtils.parseSocketAddress(s.substring(previsep + 1, isep), defaultHost, defaultPort);
                    continue;
                }
                catch (ParseException ex) {
                    throw new ParseException(ex.getMessage(), previsep + 1 + ex.getErrorOffset());
                }
            }
            throw new ParseException("Missing element in array.", previsep + 1);
        }
        return result;
    }

    public static InetSocketAddress parseSocketAddress(String s, InetAddress defaultHost, int defaultPort) throws ParseException, UnknownHostException {
        InetSocketAddress addr = null;
        int iport = s.indexOf(58);
        if (iport < 0) {
            if (defaultPort < 0) {
                throw new ParseException("Missing port in \"" + s + "\"", 0);
            }
            addr = new InetSocketAddress(InetAddress.getByName(s), defaultPort);
        } else if (iport == 0) {
            if (defaultHost == null) {
                throw new ParseException("Missing host in \"" + s + "\"", iport);
            }
            addr = new InetSocketAddress(defaultHost, Integer.parseInt(s.substring(1)));
        } else if (iport < s.length() - 1) {
            addr = new InetSocketAddress(InetAddress.getByName(s.substring(0, iport)), Integer.parseInt(s.substring(iport + 1)));
        } else {
            throw new ParseException("Missing port in \"" + s + "\"", iport);
        }
        return addr;
    }

    public static byte[] intToByteArray(int i) {
        byte[] ret = new byte[]{(byte)((i & 0xFF000000) >> 24), (byte)((i & 0xFF0000) >> 16), (byte)((i & 0xFF00) >> 8), (byte)(i & 0xFF)};
        return ret;
    }

    public static void intToByteArray(int i, byte[] a, int o) {
        a[o + 0] = (byte)((i & 0xFF000000) >> 24);
        a[o + 1] = (byte)((i & 0xFF0000) >> 16);
        a[o + 2] = (byte)((i & 0xFF00) >> 8);
        a[o + 3] = (byte)(i & 0xFF);
    }

    public static int byteArrayToInt(byte[] b, int off) {
        int ret = 0;
        ret |= b[off] << 24;
        ret |= b[off + 1] << 24 >>> 8;
        ret |= b[off + 2] << 24 >>> 16;
        return ret |= b[off + 3] << 24 >>> 24;
    }
}

