/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.xml;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.appia.core.Appia;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.xml.AppiaXMLException;
import net.sf.appia.xml.Configuration;
import net.sf.appia.xml.XMLFileHandler;
import net.sf.appia.xml.utils.ChannelProperties;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppiaXML {
    private static Logger log = Logger.getLogger(AppiaXML.class);
    private SAXParser parser;
    private XMLFileHandler handler;
    private Configuration config;
    private static AppiaXML appiaxml = new AppiaXML();

    private AppiaXML() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            log.fatal((Object)("Exception creating XML parser: " + e));
            e.printStackTrace();
            System.exit(-1);
        }
        catch (FactoryConfigurationError e) {
            log.fatal((Object)("Exception creating XML parser: " + e));
            e.printStackTrace();
            System.exit(-1);
        }
        catch (SAXException e) {
            log.fatal((Object)("Exception creating XML parser: " + e));
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private AppiaXML(Appia appia) throws AppiaXMLException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new AppiaXMLException("Unable to get SAX parser.", e);
        }
        catch (FactoryConfigurationError e) {
            throw new AppiaXMLException("Unable to get SAX parser.", e);
        }
        catch (SAXException e) {
            throw new AppiaXMLException("Unable to get SAX parser.", e);
        }
        this.config = new Configuration(appia);
        this.handler = new XMLFileHandler(this.config);
    }

    public static AppiaXML getInstance(Appia appia) throws AppiaXMLException {
        return new AppiaXML(appia);
    }

    public static void load(File xmlfile) throws SAXException, IOException {
        appiaxml.instanceLoad(xmlfile, null);
    }

    public static void load(File xmlfile, Appia appia) throws SAXException, IOException {
        appiaxml.instanceLoad(xmlfile, appia);
    }

    public void instanceLoad(File xmlfile, Appia appia) throws SAXException, IOException {
        if (appia == null) {
            if (this.config == null) {
                this.config = new Configuration();
                this.handler = new XMLFileHandler(this.config);
            }
        } else if (this.config == null) {
            try {
                this.config = new Configuration(appia);
            }
            catch (AppiaXMLException e) {
                throw new SAXException(e);
            }
            this.handler = new XMLFileHandler(this.config);
        }
        log.info((Object)("Loading XML configuration from file: " + xmlfile));
        this.parser.parse(xmlfile, (DefaultHandler)this.handler);
    }

    public static void load(String xmlstr) throws SAXException, IOException {
        appiaxml.instanceLoad(xmlstr, null);
    }

    public static void load(String xmlstr, Appia appia) throws SAXException, IOException {
        appiaxml.instanceLoad(xmlstr, appia);
    }

    public void instanceLoad(String xmlstr, Appia appia) throws SAXException, IOException {
        if (appia == null) {
            if (this.config == null) {
                this.config = new Configuration();
            } else if (this.config == null) {
                try {
                    this.config = new Configuration(appia);
                }
                catch (AppiaXMLException e) {
                    throw new SAXException(e);
                }
            }
        }
        this.handler = new XMLFileHandler(this.config);
        log.info((Object)"Loading XML configuration from a char stream...");
        this.parser.parse(new InputSource(new StringReader(xmlstr)), (DefaultHandler)this.handler);
    }

    public static void loadAndRun(File xmlfile) throws SAXException, IOException {
        appiaxml.instanceLoad(xmlfile, null);
        Appia.run();
    }

    public static void loadAndRun(String xmlstr) throws SAXException, IOException {
        appiaxml.instanceLoad(xmlstr, null);
        Appia.run();
    }

    public static String retrieve() {
        return null;
    }

    public static Channel createChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, MemoryManager mm, String messageFactory) throws AppiaException {
        return appiaxml.instanceCreateChannel(name, templateName, label, params, initialized, mm, messageFactory);
    }

    public static Channel createChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, String messageFactory) throws AppiaException {
        return appiaxml.instanceCreateChannel(name, templateName, label, params, initialized, null, messageFactory);
    }

    public Channel instanceCreateChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, MemoryManager mm, String messageFactory) throws AppiaException {
        return this.config.createChannel(name, templateName, label, params, initialized, mm, false, messageFactory);
    }

    public Channel instanceCreateChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, MemoryManager mm, boolean managed, String messageFactory) throws AppiaException {
        return this.config.createChannel(name, templateName, label, params, initialized, mm, managed, messageFactory);
    }

    public Channel instanceCreateChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, String messageFactory) throws AppiaException {
        return this.config.createChannel(name, templateName, label, params, initialized, null, false, messageFactory);
    }

    public Channel instanceCreateChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, boolean managed, String messageFactory) throws AppiaException {
        return this.config.createChannel(name, templateName, label, params, initialized, null, managed, messageFactory);
    }

    public static Channel getChannel(String name) {
        return appiaxml.instanceGetChannel(name);
    }

    public Channel instanceGetChannel(String name) {
        return this.config.getChannel(name);
    }

    public static Channel[] getChannelList() {
        return appiaxml.instanceGetChannelList();
    }

    public Channel[] instanceGetChannelList() {
        return this.config.getChannelList();
    }
}

