/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.ThreadFactory;
import net.sf.appia.core.Appia;
import net.sf.appia.core.AppiaDuplicatedSessionsException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.EventScheduler;
import net.sf.appia.core.Layer;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.core.message.MessageFactory;
import net.sf.appia.management.jmx.JMXConfiguration;
import net.sf.appia.xml.AppiaXMLException;
import net.sf.appia.xml.templates.ChannelTemplate;
import net.sf.appia.xml.templates.SessionTemplate;
import net.sf.appia.xml.utils.ChannelInfo;
import net.sf.appia.xml.utils.ChannelProperties;

public class Configuration {
    private Hashtable templates;
    private Hashtable channels;
    private ChannelTemplate currentChTemplate;
    private String currentSessionName;
    private int currentSessionSharingState;
    private Hashtable globalSessions;
    private Hashtable labelSessions;
    private Appia appia;
    private EventScheduler globalEventScheduler;
    private JMXConfiguration jmxConfiguration;
    private ThreadFactory threadFactory;
    private boolean schedulerClassIsSet;
    private Class eventSchedulerClass;
    private Constructor esWithAppiaConstructor;
    private boolean multiSchedulers;
    private LinkedList channelList = new LinkedList();
    private Hashtable sessionChannels = new Hashtable();
    private LinkedList newChannelList = new LinkedList();

    public Configuration() {
        this.templates = new Hashtable();
        this.channels = new Hashtable();
        this.globalSessions = new Hashtable();
        this.labelSessions = new Hashtable();
        this.globalEventScheduler = new EventScheduler();
        this.jmxConfiguration = null;
    }

    public Configuration(Appia appia) throws AppiaXMLException {
        this.templates = new Hashtable();
        this.channels = new Hashtable();
        this.globalSessions = new Hashtable();
        this.labelSessions = new Hashtable();
        this.appia = appia;
        this.globalEventScheduler = new EventScheduler(appia);
        this.jmxConfiguration = new JMXConfiguration(appia.getManagementMBeanID());
        try {
            if (this.threadFactory != null) {
                appia.setThreadFactory(this.threadFactory);
            }
        }
        catch (AppiaException e) {
            throw new AppiaXMLException("Could not create XML Configuration.", e);
        }
    }

    public void useMultiSchedulers(boolean multiSchedulers) {
        this.multiSchedulers = multiSchedulers;
        if (multiSchedulers) {
            this.globalEventScheduler = null;
        }
    }

    public boolean usesGlobalScheduler() {
        return !this.multiSchedulers;
    }

    public void setEventScheduler(String className) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.eventSchedulerClass = Class.forName(className);
        this.esWithAppiaConstructor = this.eventSchedulerClass.getDeclaredConstructor(Appia.class);
        if (this.globalEventScheduler != null) {
            this.globalEventScheduler = this.appia == null ? (EventScheduler)this.eventSchedulerClass.newInstance() : (EventScheduler)this.esWithAppiaConstructor.newInstance(this.appia);
        }
        this.schedulerClassIsSet = true;
    }

    public void setThreadFactory(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.threadFactory = (ThreadFactory)Class.forName(className).newInstance();
    }

    private EventScheduler getEventScheduler() throws AppiaXMLException {
        if (this.globalEventScheduler != null) {
            return this.globalEventScheduler;
        }
        if (this.appia == null) {
            if (this.schedulerClassIsSet) {
                try {
                    return (EventScheduler)this.eventSchedulerClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new AppiaXMLException("Unable to create event scheduler instance of type:" + this.eventSchedulerClass.getName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new AppiaXMLException("Unable to create event scheduler instance of type:" + this.eventSchedulerClass.getName(), e);
                }
            }
            return new EventScheduler();
        }
        if (this.schedulerClassIsSet) {
            try {
                return (EventScheduler)this.esWithAppiaConstructor.newInstance(this.appia);
            }
            catch (IllegalArgumentException e1) {
                throw new AppiaXMLException("Unable to create event scheduler instance of type:" + this.esWithAppiaConstructor.getName(), e1);
            }
            catch (InstantiationException e1) {
                throw new AppiaXMLException("Unable to create event scheduler instance of type:" + this.esWithAppiaConstructor.getName(), e1);
            }
            catch (IllegalAccessException e1) {
                throw new AppiaXMLException("Unable to create event scheduler instance of type:" + this.esWithAppiaConstructor.getName(), e1);
            }
            catch (InvocationTargetException e1) {
                throw new AppiaXMLException("Unable to create event scheduler instance of type:" + this.esWithAppiaConstructor.getName(), e1);
            }
        }
        return new EventScheduler(this.appia);
    }

    public void addTemplate(String name) {
        this.currentChTemplate = new ChannelTemplate(name);
        this.templates.put(name, this.currentChTemplate);
    }

    public void addSession(String name, int sharing) {
        this.currentSessionName = name;
        this.currentSessionSharingState = sharing;
    }

    public void setProtocol(String protocol) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> protocolClass = null;
        protocolClass = Class.forName(protocol);
        Layer layerInstance = null;
        layerInstance = (Layer)protocolClass.newInstance();
        this.currentChTemplate.addSession(this.currentSessionName, this.currentSessionSharingState, layerInstance);
    }

    public JMXConfiguration getJMXConfiguration() {
        return this.jmxConfiguration;
    }

    public void storeChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, MemoryManager mm, boolean managed, String msgFact) {
        ChannelInfo cinfo = null;
        cinfo = mm == null ? new ChannelInfo(name, templateName, label, params, initialized, msgFact) : new ChannelInfo(name, templateName, label, params, initialized, mm, msgFact);
        cinfo.setManaged(managed);
        this.channelList.add(cinfo);
        ChannelTemplate ctempl = (ChannelTemplate)this.templates.get(templateName);
        LinkedList stls = ctempl.getSessionTemplates();
        for (int i = 0; i < stls.size(); ++i) {
            LinkedList clist;
            String storeName;
            SessionTemplate stempl = (SessionTemplate)stls.get(i);
            String sname = stempl.getName();
            int sharing = stempl.getSharingState();
            if (sharing != 2 && sharing != 1) continue;
            String string = storeName = sharing == 1 ? sname + label : sname;
            if (!this.sessionChannels.containsKey(storeName)) {
                this.sessionChannels.put(storeName, new LinkedList());
            } else {
                clist = (LinkedList)this.sessionChannels.get(storeName);
                for (int j = 0; j < clist.size(); ++j) {
                    ChannelInfo aux = (ChannelInfo)clist.get(j);
                    aux.addDependency(cinfo);
                    cinfo.addDependency(aux);
                }
            }
            clist = (LinkedList)this.sessionChannels.get(storeName);
            clist.add(cinfo);
        }
    }

    private void proccessDependencies() throws AppiaXMLException {
        while (!this.channelList.isEmpty()) {
            ChannelInfo cinfo = (ChannelInfo)this.channelList.removeFirst();
            if (this.newChannelList.isEmpty()) {
                cinfo.setEventScheduler(this.getEventScheduler());
            } else {
                for (int i = 0; i < this.newChannelList.size(); ++i) {
                    ChannelInfo aux = (ChannelInfo)this.newChannelList.get(i);
                    if (!cinfo.depends(aux)) continue;
                    if (aux.getEventScheduler() != null) {
                        cinfo.setEventScheduler(aux.getEventScheduler());
                        continue;
                    }
                    cinfo.setEventScheduler(this.getEventScheduler());
                }
            }
            if (cinfo.getEventScheduler() == null) {
                cinfo.setEventScheduler(this.getEventScheduler());
            }
            this.newChannelList.add(cinfo);
        }
    }

    public void createChannels() throws AppiaXMLException {
        this.proccessDependencies();
        while (!this.newChannelList.isEmpty()) {
            ChannelInfo ci = (ChannelInfo)this.newChannelList.removeFirst();
            this.createChannel(ci.getName(), ci.getTemplateName(), ci.getLabel(), ci.getParams(), ci.isInitialized(), ci.getEventScheduler(), ci.getMemoryManager(), ci.isManaged() ? this.jmxConfiguration : null, ci.getMessageFactory());
        }
    }

    public Channel createChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, MemoryManager mm, boolean managed, String msgFactory) throws AppiaXMLException {
        ChannelTemplate chnt = (ChannelTemplate)this.templates.get(templateName);
        if (chnt == null) {
            throw new AppiaXMLException("Template '" + templateName + "' does not exist");
        }
        Channel chn = chnt.createChannel(name, label, params, this.globalSessions, this.labelSessions, this.globalEventScheduler, mm, managed ? this.jmxConfiguration : null);
        if (msgFactory != null && !msgFactory.equals("")) {
            try {
                chn.setMessageFactory((MessageFactory)Class.forName(msgFactory).newInstance());
            }
            catch (InstantiationException e1) {
                throw new AppiaXMLException("Could not instantiate the message factory", e1);
            }
            catch (IllegalAccessException e1) {
                throw new AppiaXMLException("Could not instantiate the message factory", e1);
            }
            catch (ClassNotFoundException e1) {
                throw new AppiaXMLException("Could not instantiate the message factory", e1);
            }
        }
        this.channels.put(name, chn);
        if (initialized) {
            try {
                chn.start();
            }
            catch (AppiaDuplicatedSessionsException e) {
                throw new AppiaXMLException("Unable to start the channel: " + chn.getChannelID(), e);
            }
        }
        return chn;
    }

    public Channel createChannel(String name, String templateName, String label, ChannelProperties params, boolean initialized, EventScheduler eventScheduler, MemoryManager mm, JMXConfiguration jmxConfig, String msgFactory) throws AppiaXMLException {
        ChannelTemplate chnt = (ChannelTemplate)this.templates.get(templateName);
        if (chnt == null) {
            throw new AppiaXMLException("Template '" + templateName + "' does not exist");
        }
        Channel chn = chnt.createChannel(name, label, params, this.globalSessions, this.labelSessions, eventScheduler, mm, jmxConfig);
        if (msgFactory != null && !msgFactory.equals("")) {
            try {
                chn.setMessageFactory((MessageFactory)Class.forName(msgFactory).newInstance());
            }
            catch (InstantiationException e1) {
                throw new AppiaXMLException("Could not instantiate the message factory", e1);
            }
            catch (IllegalAccessException e1) {
                throw new AppiaXMLException("Could not instantiate the message factory", e1);
            }
            catch (ClassNotFoundException e1) {
                throw new AppiaXMLException("Could not instantiate the message factory", e1);
            }
        }
        this.channels.put(name, chn);
        if (initialized) {
            try {
                chn.start();
            }
            catch (AppiaDuplicatedSessionsException e) {
                throw new AppiaXMLException("Unable to start the channel: " + chn.getChannelID(), e);
            }
        }
        return chn;
    }

    public Channel getChannel(String name) {
        return (Channel)this.channels.get(name);
    }

    public Channel[] getChannelList() {
        Object[] aux = this.channels.values().toArray();
        Channel[] chl = new Channel[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            chl[i] = (Channel)aux[i];
        }
        return chl;
    }

    public void printConfig() {
        Enumeration e = this.templates.elements();
        while (e.hasMoreElements()) {
            ((ChannelTemplate)e.nextElement()).printChannelTemplate();
        }
    }
}

