/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.xml;

import java.lang.reflect.InvocationTargetException;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.xml.AppiaXMLException;
import net.sf.appia.xml.Configuration;
import net.sf.appia.xml.utils.ChannelProperties;
import net.sf.appia.xml.utils.SessionProperties;
import net.sf.appia.xml.utils.SharingState;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFileHandler
extends DefaultHandler {
    private Configuration config;
    private boolean settingProtocol;
    private boolean creatingChannel;
    private String channelName;
    private String channelTemplateName;
    private String channelLabel;
    private String channelInitialized;
    private String channelManaged;
    private String channelMsgFactory;
    private String sessionName;
    private boolean settingParameter;
    private String paramName;
    private ChannelProperties params;
    private SessionProperties currentParams;
    private String mmSize;
    private String mmUPThreshold;
    private String mmDOWNThreshold;
    private MemoryManager memoryManager = null;
    private String namingHost;
    private String namingPort;
    private String local;
    private boolean charactersUsed;
    private StringBuffer charactersAcum;

    public XMLFileHandler(Configuration config) {
        this.config = config;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.charactersUsed) {
            this.charactersUsed = true;
        }
        this.charactersAcum.append(ch, start, length);
    }

    private void processCharacters() throws SAXException {
        if (this.settingProtocol) {
            try {
                this.config.setProtocol(this.charactersAcum.toString());
            }
            catch (ClassNotFoundException e) {
                throw new SAXException(e);
            }
            catch (InstantiationException e) {
                throw new SAXException(e);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
        } else if (this.creatingChannel && this.settingParameter) {
            this.currentParams.setProperty(this.paramName, this.charactersAcum.toString());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.charactersAcum = new StringBuffer();
        if (qName.equals("appia")) {
            String att = attributes.getValue("multischedulers");
            if (att != null && att.equals("yes")) {
                this.config.useMultiSchedulers(true);
            }
            if ((att = attributes.getValue("threadFactory")) != null && !att.equals("")) {
                try {
                    this.config.setThreadFactory(att);
                }
                catch (ClassNotFoundException e) {
                    throw new SAXException(e);
                }
                catch (InstantiationException e) {
                    throw new SAXException(e);
                }
                catch (IllegalAccessException e) {
                    throw new SAXException(e);
                }
            }
            if ((att = attributes.getValue("scheduler")) != null) {
                try {
                    this.config.setEventScheduler(att);
                }
                catch (SecurityException e) {
                    throw new SAXException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new SAXException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new SAXException(e);
                }
                catch (InstantiationException e) {
                    throw new SAXException(e);
                }
                catch (IllegalAccessException e) {
                    throw new SAXException(e);
                }
                catch (InvocationTargetException e) {
                    throw new SAXException(e);
                }
            }
        } else if (qName.equals("template")) {
            this.config.addTemplate(attributes.getValue("name"));
        } else if (qName.equals("session")) {
            this.config.addSession(attributes.getValue("name"), SharingState.value(attributes.getValue("sharing")));
        } else if (qName.equals("protocol")) {
            this.settingProtocol = true;
        } else if (qName.equals("channel")) {
            this.params = new ChannelProperties();
            this.creatingChannel = true;
            this.memoryManager = null;
            this.channelName = attributes.getValue("name");
            this.channelTemplateName = attributes.getValue("template");
            this.channelInitialized = attributes.getValue("initialized");
            this.channelManaged = attributes.getValue("managed");
            this.channelLabel = attributes.getValue("label");
            this.channelMsgFactory = attributes.getValue("messageFactory");
        } else if (qName.equals("chsession")) {
            this.sessionName = attributes.getValue("name");
            this.currentParams = new SessionProperties();
        } else if (qName.equals("memorymanagement")) {
            this.mmSize = attributes.getValue("size");
            this.mmUPThreshold = attributes.getValue("up_threshold");
            this.mmDOWNThreshold = attributes.getValue("down_threshold");
        } else if (qName.equals("management")) {
            this.namingHost = attributes.getValue("naming_host");
            this.namingPort = attributes.getValue("naming_port");
            this.local = attributes.getValue("local");
        } else if (qName.equals("parameter")) {
            this.paramName = attributes.getValue("name");
            this.settingParameter = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.charactersUsed) {
            this.charactersUsed = false;
            this.processCharacters();
        }
        if (qName.equals("protocol")) {
            this.settingProtocol = false;
        } else if (qName.equals("channel")) {
            boolean init = false;
            boolean managed = false;
            if (this.channelInitialized.equals("yes")) {
                init = true;
            }
            if (this.channelManaged != null && this.channelManaged.equals("yes")) {
                managed = true;
            }
            if (this.config.usesGlobalScheduler()) {
                try {
                    this.config.createChannel(this.channelName, this.channelTemplateName, this.channelLabel, this.params, init, this.memoryManager, managed, this.channelMsgFactory);
                }
                catch (AppiaXMLException e) {
                    throw new SAXException(e);
                }
            } else {
                this.config.storeChannel(this.channelName, this.channelTemplateName, this.channelLabel, this.params, init, this.memoryManager, managed, this.channelMsgFactory);
            }
            this.creatingChannel = false;
        } else if (qName.equals("chsession") && this.creatingChannel) {
            this.params.put(this.sessionName, this.currentParams);
        } else if (qName.equals("memorymanagement") && this.creatingChannel) {
            this.memoryManager = new MemoryManager(this.channelName + " Memory Manager", Integer.parseInt(this.mmSize), Integer.parseInt(this.mmUPThreshold), Integer.parseInt(this.mmDOWNThreshold));
        } else if (qName.equals("management")) {
            if (this.namingHost != null) {
                this.config.getJMXConfiguration().setNamingServer(this.namingHost);
            }
            if (this.namingPort != null) {
                this.config.getJMXConfiguration().setNamingPort(Integer.parseInt(this.namingPort));
            }
            if (this.local != null) {
                this.config.getJMXConfiguration().setLocal(this.local.equals("yes"));
            }
        } else if (qName.equals("parameter")) {
            this.settingParameter = false;
        } else if (qName.equals("appia")) {
            try {
                if (!this.config.usesGlobalScheduler()) {
                    this.config.createChannels();
                }
            }
            catch (AppiaXMLException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public Configuration configuration() {
        return this.config;
    }
}

