/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.client;

import java.io.Serializable;
import org.vanilladb.comm.client.VanillaCommClient;
import org.vanilladb.comm.client.VanillaCommClientListener;
import org.vanilladb.comm.view.ProcessType;
import org.vanilladb.comm.view.ProcessView;

public class ClientDemo
implements VanillaCommClientListener {
    private static final int REQ_ID_SHIFT = 100000;

    public static void main(String[] args) {
        int selfId = Integer.parseInt(args[0]);
        VanillaCommClient client = new VanillaCommClient(selfId, new ClientDemo());
        new Thread(client).start();
        int serverCount = ProcessView.buildServersProcessList(-1).getSize();
        ClientDemo.sendRequestPeriodically(selfId, client, serverCount);
    }

    private static void sendRequestPeriodically(final int selfId, final VanillaCommClient client, final int serverCount) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int count = 100000 * selfId;
                int targetServerId = selfId % serverCount;
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    String message = String.format("Request #%d from client %d", count, selfId);
                    client.sendP2pMessage(ProcessType.SERVER, targetServerId, (Serializable)((Object)message));
                    ++count;
                }
            }
        }).start();
    }

    @Override
    public void onReceiveP2pMessage(ProcessType senderType, int senderId, Serializable message) {
        System.out.println("Received a P2P message from " + (Object)((Object)senderType) + " " + senderId + ", message: " + message);
    }
}

