/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.client;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.Appia;
import net.sf.appia.core.AppiaDuplicatedSessionsException;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaInvalidQoSException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Layer;
import net.sf.appia.core.QoS;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteLayer;
import org.vanilladb.comm.client.VanillaCommClientListener;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.protocols.p2pappl.P2pApplicationLayer;
import org.vanilladb.comm.protocols.p2pappl.P2pMessage;
import org.vanilladb.comm.protocols.p2pappl.P2pMessageListener;
import org.vanilladb.comm.view.ProcessType;
import org.vanilladb.comm.view.ProcessView;

public class VanillaCommClient
implements P2pMessageListener,
Runnable {
    private static Logger logger = Logger.getLogger(VanillaCommClient.class.getName());
    private VanillaCommClientListener listener;
    private Channel p2pChannel;

    public VanillaCommClient(int selfId, VanillaCommClientListener listener) {
        int globalSelfId = ProcessView.toGlobalId(ProcessType.CLIENT, selfId);
        this.listener = listener;
        this.setupP2pChannel(globalSelfId);
    }

    @Override
    public void run() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Starts the network service");
        }
        Appia.run();
    }

    public void sendP2pMessage(ProcessType receiverType, int receiverId, Serializable message) {
        try {
            int globalId = ProcessView.toGlobalId(receiverType, receiverId);
            P2pMessage p2p = new P2pMessage(message, globalId);
            p2p.asyncGo(this.p2pChannel, -1);
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRecvP2pMessage(int senderId, Serializable message) {
        this.listener.onReceiveP2pMessage(ProcessView.toProcessType(senderId), ProcessView.toLocalId(senderId), message);
    }

    public int getServerCount() {
        return ProcessView.SERVER_COUNT;
    }

    public int getClientCount() {
        return ProcessView.CLIENT_COUNT;
    }

    private void setupP2pChannel(int globalSelfId) {
        try {
            ProcessList processList = ProcessView.buildAllProcessList(globalSelfId);
            Layer[] layers = new Layer[]{new TcpCompleteLayer(), new P2pApplicationLayer(this, processList, true)};
            QoS qos = new QoS("P2P QoS", layers);
            this.p2pChannel = qos.createUnboundChannel("P2P Channel");
            this.p2pChannel.start();
        }
        catch (AppiaInvalidQoSException e) {
            e.printStackTrace();
        }
        catch (AppiaDuplicatedSessionsException e) {
            e.printStackTrace();
        }
    }
}

