/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.process;

import java.io.Serializable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vanilladb.comm.process.CommProcess;

public class ProcessList
implements Serializable {
    private static final long serialVersionUID = 20200318001L;
    private CommProcess[] processes;
    private int selfId = -1;
    private Map<SocketAddress, Integer> addressToId = new HashMap<SocketAddress, Integer>();

    private ProcessList(CommProcess[] processes) {
        this.processes = processes;
        for (CommProcess process : processes) {
            if (process.isSelf()) {
                this.selfId = process.getId();
            }
            this.addressToId.put(process.getAddress(), process.getId());
        }
    }

    public ProcessList(ProcessList processList) {
        CommProcess[] targets = processList.processes;
        this.processes = new CommProcess[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            this.processes[i] = new CommProcess(targets[i]);
        }
        this.selfId = processList.selfId;
        this.addressToId = new HashMap<SocketAddress, Integer>(processList.addressToId);
    }

    public int getSize() {
        return this.processes.length;
    }

    public int getId(SocketAddress addr) {
        Integer id = this.addressToId.get(addr);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public CommProcess getProcess(SocketAddress addr) {
        int i = this.getId(addr);
        if (i == -1) {
            return null;
        }
        return this.processes[i];
    }

    public CommProcess getProcess(int id) {
        return this.processes[id];
    }

    public int getSelfId() {
        return this.selfId;
    }

    public CommProcess getSelfProcess() {
        if (this.selfId == -1) {
            return null;
        }
        return this.processes[this.selfId];
    }

    public boolean areAllCorrect() {
        for (int id = 0; id < this.processes.length; ++id) {
            if (this.processes[id].isCorrect()) continue;
            return false;
        }
        return true;
    }

    public Set<Integer> getCorrectProcessIds() {
        HashSet<Integer> corrects = new HashSet<Integer>();
        for (int id = 0; id < this.processes.length; ++id) {
            if (!this.processes[id].isCorrect()) continue;
            corrects.add(id);
        }
        return corrects;
    }

    public int getCorrectCount() {
        int count = 0;
        for (int id = 0; id < this.processes.length; ++id) {
            if (!this.processes[id].isCorrect()) continue;
            ++count;
        }
        return count;
    }

    public static class Builder {
        List<CommProcess> processes = new ArrayList<CommProcess>();

        public void addProcess(CommProcess process) {
            if (process.getId() != this.processes.size()) {
                throw new IllegalArgumentException("Process must be added with increasing ids");
            }
            this.processes.add(process);
        }

        public ProcessList build() {
            return new ProcessList(this.processes.toArray(new CommProcess[this.processes.size()]));
        }
    }
}

