/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.rb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.rb.MessageId;
import org.vanilladb.comm.protocols.rb.ReliableBroadcast;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;

public class ReliableBroadcastSession
extends Session {
    private static Logger logger = Logger.getLogger(ReliableBroadcastSession.class.getName());
    private ProcessList processList;
    private Set<MessageId> delivered = new HashSet<MessageId>();
    private Map<Integer, Map<Integer, ReliableBroadcast>> logs = new HashMap<Integer, Map<Integer, ReliableBroadcast>>();
    private int sequenceNumber = 0;

    ReliableBroadcastSession(Layer layer) {
        super(layer);
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        } else if (event instanceof AllProcessesReady) {
            this.handleAllProcessesReady((AllProcessesReady)event);
        } else if (event instanceof FailureDetected) {
            this.handleFailureDetected((FailureDetected)event);
        } else if (event instanceof ReliableBroadcast) {
            if (event.getDir() == -1) {
                this.handleBroadcastRequest((ReliableBroadcast)event);
            } else {
                this.handleBroadcastDeliver((ReliableBroadcast)event);
            }
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ProcessListInit");
        }
        this.processList = event.copyProcessList();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        for (int pid = 0; pid < this.processList.getSize(); ++pid) {
            this.logs.put(pid, new HashMap());
        }
    }

    private void handleAllProcessesReady(AllProcessesReady event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received AllProcessesReady");
        }
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.processList.getProcess(i).setState(ProcessState.CORRECT);
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleFailureDetected(FailureDetected event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FailureDetected (failed id = " + event.getFailedProcessId() + ")");
        }
        this.processList.getProcess(event.getFailedProcessId()).setState(ProcessState.FAILED);
        try {
            event.go();
            for (Map.Entry<Integer, ReliableBroadcast> entry : this.logs.get(event.getFailedProcessId()).entrySet()) {
                int seqNum = entry.getKey();
                ReliableBroadcast broadcast = entry.getValue();
                MessageId id = new MessageId(event.getFailedProcessId(), seqNum);
                broadcast.getMessage().pushObject(id);
                broadcast.setSourceSession(this);
                broadcast.setDir(-1);
                broadcast.init();
                broadcast.go();
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleBroadcastRequest(ReliableBroadcast event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received a Broadcast request from a upper layer");
        }
        int seqNum = this.sequenceNumber++;
        MessageId id = new MessageId(this.processList.getSelfId(), seqNum);
        event.getMessage().pushObject(id);
        try {
            event.setSourceSession(this);
            event.setDir(-1);
            event.init();
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleBroadcastDeliver(ReliableBroadcast event) {
        MessageId id;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received a delivered broadcast from a lower layer");
        }
        if (!this.delivered.contains(id = (MessageId)event.getMessage().popObject())) {
            try {
                this.delivered.add(id);
                this.logs.get(id.getSourceProcessId()).put(id.getSequenceNumber(), (ReliableBroadcast)event.cloneEvent());
                if (!this.processList.getProcess(id.getSourceProcessId()).isCorrect()) {
                    ReliableBroadcast cloned = (ReliableBroadcast)event.cloneEvent();
                    cloned.setSourceSession(this);
                    cloned.setDir(-1);
                    cloned.init();
                    cloned.go();
                }
                event.setSourceSession(this);
                event.setDir(1);
                event.init();
                event.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }
}

