/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.tcpfd;

import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.protocols.common.RegisterSocketEvent;
import net.sf.appia.protocols.tcpcomplete.TcpUndeliveredEvent;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;
import org.vanilladb.comm.protocols.tcpfd.FdHello;
import org.vanilladb.comm.protocols.tcpfd.FdHelloAck;
import org.vanilladb.comm.protocols.tcpfd.FdHelloRetry;

public class TcpFailureDetectionSession
extends Session {
    private static Logger logger = Logger.getLogger(TcpFailureDetectionSession.class.getName());
    private static final int RETRY_PERIOD = 5000;
    private ProcessList processList;

    TcpFailureDetectionSession(Layer layer) {
        super(layer);
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        } else if (event instanceof RegisterSocketEvent) {
            this.handleRegisterSocket((RegisterSocketEvent)event);
        } else if (event instanceof FdHello) {
            this.handleFdHello((FdHello)event);
        } else if (event instanceof FdHelloAck) {
            this.handleFdHelloAck((FdHelloAck)event);
        } else if (event instanceof TcpUndeliveredEvent) {
            this.handleTcpUndelivered((TcpUndeliveredEvent)event);
        } else if (event instanceof FdHelloRetry) {
            this.handleFdHelloRetry((FdHelloRetry)event);
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ProcessListInit");
        }
        this.processList = event.copyProcessList();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleRegisterSocket(RegisterSocketEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received RegisterSocketEvent");
        }
        try {
            event.go();
            if (event.getDir() == 1 && !event.error) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Sending FdHello to all other nodes");
                }
                for (int id = 0; id < this.processList.getSize(); ++id) {
                    if (id == this.processList.getSelfId()) continue;
                    FdHello hello = new FdHello(event.getChannel(), this);
                    hello.source = this.processList.getSelfProcess().getAddress();
                    hello.dest = this.processList.getProcess(id).getAddress();
                    hello.init();
                    hello.go();
                }
                this.scheduleHelloRetry(event.getChannel());
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        catch (AppiaException e) {
            e.printStackTrace();
        }
    }

    private void handleFdHello(FdHello event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FdHello from " + event.source);
        }
        try {
            FdHelloAck ack = new FdHelloAck(event.getChannel(), this);
            ack.source = this.processList.getSelfProcess().getAddress();
            ack.dest = event.source;
            ack.init();
            ack.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleFdHelloAck(FdHelloAck event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FdHelloAck from " + event.source);
        }
        try {
            this.processList.getProcess((SocketAddress)event.source).setState(ProcessState.CORRECT);
            if (this.processList.areAllCorrect()) {
                AllProcessesReady ready = new AllProcessesReady(event.getChannel(), 1, this);
                ready.init();
                ready.go();
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleTcpUndelivered(TcpUndeliveredEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received TcpUndelivered for " + event.getFailedAddress());
        }
        try {
            int processId = this.processList.getId((SocketAddress)event.getFailedAddress());
            if (processId == -1) {
                return;
            }
            if (!this.processList.getProcess(processId).isInitialized()) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Cannot deliver messages to processs " + event.getFailedAddress() + ". Retry later.");
                }
            } else if (this.processList.getProcess(processId).isCorrect()) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Detected failed processs " + event.getFailedAddress());
                }
                this.processList.getProcess(processId).setState(ProcessState.FAILED);
                FailureDetected fd = new FailureDetected(event.getChannel(), this, processId);
                fd.init();
                fd.go();
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleFdHelloRetry(FdHelloRetry event) {
        try {
            boolean needToRetryLater = false;
            for (int id = 0; id < this.processList.getSize(); ++id) {
                if (id == this.processList.getSelfId() || this.processList.getProcess(id).isInitialized()) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Sending FdHello again to " + this.processList.getProcess(id).getAddress());
                }
                FdHello hello = new FdHello(event.getChannel(), this);
                hello.source = this.processList.getSelfProcess().getAddress();
                hello.dest = this.processList.getProcess(id).getAddress();
                hello.init();
                hello.go();
                needToRetryLater = true;
            }
            if (needToRetryLater) {
                this.scheduleHelloRetry(event.getChannel());
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        catch (AppiaException e) {
            e.printStackTrace();
        }
    }

    private void scheduleHelloRetry(Channel channel) throws AppiaEventException, AppiaException {
        FdHelloRetry retry = new FdHelloRetry(5000L, "FdHelloRetry", channel, this);
        retry.init();
        retry.go();
    }
}

