/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.tob;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.floodingconsensus.ConsensusRequest;
import org.vanilladb.comm.protocols.floodingconsensus.ConsensusResult;
import org.vanilladb.comm.protocols.rb.MessageId;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;
import org.vanilladb.comm.protocols.tob.OrderProposal;
import org.vanilladb.comm.protocols.tob.TotalOrderBroadcast;

public class TotalOrderBroadcastSession
extends Session {
    private static Logger logger = Logger.getLogger(TotalOrderBroadcastSession.class.getName());
    private ProcessList processList;
    private int sequenceNumber = 1;
    private Set<MessageId> delivered = new HashSet<MessageId>();
    private Map<MessageId, TotalOrderBroadcast> unordered = new HashMap<MessageId, TotalOrderBroadcast>();
    private List<MessageId> waitForDeliverIds = new ArrayList<MessageId>();
    private Map<MessageId, TotalOrderBroadcast> waitForDeliverMessages = new HashMap<MessageId, TotalOrderBroadcast>();
    private boolean wait = false;

    TotalOrderBroadcastSession(Layer layer) {
        super(layer);
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        } else if (event instanceof AllProcessesReady) {
            this.handleAllProcessesReady((AllProcessesReady)event);
        } else if (event instanceof FailureDetected) {
            this.handleFailureDetected((FailureDetected)event);
        } else if (event instanceof TotalOrderBroadcast) {
            if (event.getDir() == -1) {
                this.handleBroadcastRequest((TotalOrderBroadcast)event);
            } else {
                this.handleBroadcastDeliver((TotalOrderBroadcast)event);
            }
        } else if (event instanceof ConsensusResult) {
            this.handleConsensusResult((ConsensusResult)event);
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ProcessListInit");
        }
        this.processList = event.copyProcessList();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleAllProcessesReady(AllProcessesReady event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received AllProcessesReady");
        }
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.processList.getProcess(i).setState(ProcessState.CORRECT);
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleFailureDetected(FailureDetected event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FailureDetected (failed id = " + event.getFailedProcessId() + ")");
        }
        this.processList.getProcess(event.getFailedProcessId()).setState(ProcessState.FAILED);
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleBroadcastRequest(TotalOrderBroadcast event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received a TotalOrderBroadcast request");
        }
        MessageId id = new MessageId(this.processList.getSelfId(), this.sequenceNumber);
        ++this.sequenceNumber;
        event.getMessage().pushObject(id);
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleBroadcastDeliver(TotalOrderBroadcast event) {
        MessageId id;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received a delivered Broadcast message");
        }
        if (!this.delivered.contains(id = (MessageId)event.getMessage().popObject())) {
            if (this.waitForDeliverIds.contains(id)) {
                this.waitForDeliverMessages.put(id, event);
                this.tryDeliver(event.getChannel());
            } else {
                this.unordered.put(id, event);
                this.tryOrder(event.getChannel());
            }
        }
    }

    private void handleConsensusResult(ConsensusResult event) {
        OrderProposal decision = (OrderProposal)event.getDecision();
        ArrayList<MessageId> orderedIds = new ArrayList<MessageId>(decision.getMessageIds());
        Collections.sort(orderedIds);
        for (MessageId id : orderedIds) {
            TotalOrderBroadcast message = this.unordered.remove(id);
            this.waitForDeliverIds.add(id);
            if (message == null) continue;
            this.waitForDeliverMessages.put(id, message);
        }
        this.tryDeliver(event.getChannel());
        this.wait = false;
        this.tryOrder(event.getChannel());
    }

    private void tryOrder(Channel channel) {
        if (!this.wait && !this.unordered.isEmpty()) {
            this.wait = true;
            OrderProposal proposal = new OrderProposal(this.unordered.keySet());
            try {
                ConsensusRequest request = new ConsensusRequest(channel, this, proposal);
                request.init();
                request.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        }
    }

    private void tryDeliver(Channel channel) {
        HashSet<MessageId> delivered = new HashSet<MessageId>();
        for (MessageId id : this.waitForDeliverIds) {
            TotalOrderBroadcast message = this.waitForDeliverMessages.remove(id);
            if (message == null) continue;
            delivered.add(id);
            try {
                message.setSourceSession(this);
                message.setDir(1);
                message.init();
                message.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        }
        this.waitForDeliverIds.removeAll(delivered);
        this.delivered.addAll(delivered);
    }
}

