/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.totalorderappl;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.protocols.common.RegisterSocketEvent;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.process.ProcessStateListener;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;
import org.vanilladb.comm.protocols.totalorderappl.TotalOrderMessageListener;
import org.vanilladb.comm.protocols.totalorderappl.TotalOrderMessages;

public class TotalOrderApplicationSession
extends Session {
    private static Logger logger = Logger.getLogger(TotalOrderApplicationSession.class.getName());
    private ProcessStateListener procListener;
    private TotalOrderMessageListener totalMsgListener;
    private ProcessList processList;
    private boolean willRegisterSocket;

    TotalOrderApplicationSession(Layer layer, ProcessStateListener procListener, TotalOrderMessageListener totalMsgListener, ProcessList processList, boolean willRegisterSocket) {
        super(layer);
        this.procListener = procListener;
        this.totalMsgListener = totalMsgListener;
        this.processList = processList;
        this.willRegisterSocket = willRegisterSocket;
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)event);
        } else if (event instanceof AllProcessesReady) {
            this.handleAllProcessesReady((AllProcessesReady)event);
        } else if (event instanceof RegisterSocketEvent) {
            this.handleRegisterSocketEvent((RegisterSocketEvent)event);
        } else if (event instanceof FailureDetected) {
            this.handleFailureDetected((FailureDetected)event);
        } else if (event instanceof TotalOrderMessages) {
            this.handleTotalOrderMessage((TotalOrderMessages)event);
        }
    }

    private void handleChannelInit(ChannelInit init) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ChannelInit");
        }
        try {
            init.go();
            if (this.willRegisterSocket) {
                RegisterSocketEvent rse = new RegisterSocketEvent(init.getChannel(), -1, this);
                rse.localHost = this.processList.getSelfProcess().getAddress().getAddress();
                rse.port = this.processList.getSelfProcess().getAddress().getPort();
                rse.init();
                rse.go();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Socket registration request sent.");
                }
            }
            ProcessListInit processInit = new ProcessListInit(init.getChannel(), this, new ProcessList(this.processList));
            processInit.init();
            processInit.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleAllProcessesReady(AllProcessesReady event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received AllProcessesReady");
        }
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.processList.getProcess(i).setState(ProcessState.CORRECT);
        }
        this.procListener.onAllProcessesReady();
    }

    private void handleRegisterSocketEvent(RegisterSocketEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received RegisterSocket");
        }
        if (event.error) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe(event.getErrorDescription());
            }
            System.exit(2);
        } else if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Socket registration completed. (%s:%d)", event.localHost, event.port));
        }
    }

    private void handleFailureDetected(FailureDetected event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FailureDetected (failed id = " + event.getFailedProcessId() + ")");
        }
        this.processList.getProcess(event.getFailedProcessId()).setState(ProcessState.FAILED);
        this.procListener.onProcessFailed(event.getFailedProcessId());
    }

    private void handleTotalOrderMessage(TotalOrderMessages event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Received TotalOrderMessage (serial number start at: %d, length: %d)", event.getMessageSerialNumberStart(), event.getMessages().length));
        }
        long startId = event.getMessageSerialNumberStart();
        Serializable[] messages = event.getMessages();
        for (int id = 0; id < messages.length; ++id) {
            this.totalMsgListener.onRecvTotalOrderMessage(startId + (long)id, messages[id]);
        }
    }
}

