/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.zabelection;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;
import org.vanilladb.comm.protocols.zabelection.LeaderChanged;
import org.vanilladb.comm.protocols.zabelection.LeaderInit;

public class ZabElectionSession
extends Session {
    private static Logger logger = Logger.getLogger(ZabElectionSession.class.getName());
    private ProcessList processList;
    private int leaderId;
    private int epochId = 0;

    ZabElectionSession(Layer layer) {
        super(layer);
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        } else if (event instanceof AllProcessesReady) {
            this.handleAllProcessesReady((AllProcessesReady)event);
        } else if (event instanceof FailureDetected) {
            this.handleFailureDetected((FailureDetected)event);
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ProcessListInit");
        }
        this.processList = event.copyProcessList();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleAllProcessesReady(AllProcessesReady event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received AllProcessesReady");
        }
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.processList.getProcess(i).setState(ProcessState.CORRECT);
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        this.leaderId = this.processList.getSize() - 1;
        try {
            LeaderInit init = new LeaderInit(event.getChannel(), this, this.leaderId);
            init.init();
            init.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleFailureDetected(FailureDetected event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FailureDetected (failed id = " + event.getFailedProcessId() + ")");
        }
        this.processList.getProcess(event.getFailedProcessId()).setState(ProcessState.FAILED);
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        if (this.leaderId == event.getFailedProcessId()) {
            this.electNewLeader();
            try {
                LeaderChanged change = new LeaderChanged(event.getChannel(), this, this.leaderId, this.epochId);
                change.init();
                change.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        }
    }

    private void electNewLeader() {
        for (int i = this.processList.getSize() - 1; i >= 0; --i) {
            if (!this.processList.getProcess(i).isCorrect()) continue;
            this.leaderId = i;
            break;
        }
        ++this.epochId;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Elected a new leader: Process " + this.leaderId + " (epoch: " + this.epochId + ")");
        }
    }
}

