/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.visallo.web.clientapi.JsonUtil;
import org.visallo.web.clientapi.codegen.ApiException;

public class ApiInvoker {
    private static ApiInvoker INSTANCE = new ApiInvoker();
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private boolean isDebug = false;
    private String csrfToken;
    private String workspaceId;
    private String jSessionId;

    public void enableDebug() {
        this.isDebug = true;
    }

    public static ApiInvoker getInstance() {
        return INSTANCE;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static Object deserialize(String json, String containerType, Class cls) throws ApiException {
        try {
            if ("List".equals(containerType)) {
                CollectionType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, cls);
                List response = (List)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if (String.class.equals((Object)cls)) {
                if (json != null && json.startsWith("\"") && json.endsWith("\"") && json.length() > 1) {
                    return json.substring(1, json.length() - 2);
                }
                return json;
            }
            return JsonUtil.getJsonMapper().readValue(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public static String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                return JsonUtil.getJsonMapper().writeValueAsString(obj);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public InputStream getBinary(String host, String path, Map<String, String> queryParams, Map<String, String> headerParams) throws ApiException {
        Client client = this.getClient(host);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        WebResource.Builder builder = client.resource(host + path + querystring).accept("application/json");
        for (String key : headerParams.keySet()) {
            builder.header(key, headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, this.defaultHeaderMap.get(key));
        }
        if (this.workspaceId != null) {
            builder.header("Visallo-Workspace-Id", this.workspaceId);
        }
        if (this.jSessionId != null) {
            builder.header("Cookie", "JSESSIONID=" + this.jSessionId);
        }
        ClientResponse response = null;
        response = builder.get(ClientResponse.class);
        if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            return response.getEntityInputStream();
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), response.getEntity(String.class));
    }

    public String invokeAPI(String host, String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, Map<String, String> formParams, String contentType) throws ApiException {
        Client client = this.getClient(host);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        WebResource.Builder builder = client.resource(host + path + querystring).accept("application/json");
        for (String key : headerParams.keySet()) {
            builder.header(key, headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, this.defaultHeaderMap.get(key));
        }
        if (this.workspaceId != null) {
            builder.header("Visallo-Workspace-Id", this.workspaceId);
        }
        if (this.jSessionId != null) {
            builder.header("Cookie", "JSESSIONID=" + this.jSessionId);
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            builder.header("Visallo-CSRF-Token", this.csrfToken);
            response = body == null ? builder.post(ClientResponse.class, (Object)ApiInvoker.serialize(body)) : (body instanceof FormDataMultiPart ? ((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, body) : ((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)ApiInvoker.serialize(body)));
        } else if ("PUT".equals(method)) {
            builder.header("Visallo-CSRF-Token", this.csrfToken);
            if (body == null) {
                response = builder.put(ClientResponse.class, (Object)ApiInvoker.serialize(body));
            } else if ("application/x-www-form-urlencoded".equals(contentType)) {
                StringBuilder formParamBuilder = new StringBuilder();
                for (String key : formParams.keySet()) {
                    String value = formParams.get(key);
                    if (value == null || "".equals(value.trim())) continue;
                    if (formParamBuilder.length() > 0) {
                        formParamBuilder.append("&");
                    }
                    try {
                        formParamBuilder.append(URLEncoder.encode(key, "utf8")).append("=").append(URLEncoder.encode(value, "utf8"));
                    }
                    catch (Exception exception) {}
                }
                response = ((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)formParamBuilder.toString());
            } else {
                response = ((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)ApiInvoker.serialize(body));
            }
        } else if ("DELETE".equals(method)) {
            builder.header("Visallo-CSRF-Token", this.csrfToken);
            response = body == null ? builder.delete(ClientResponse.class, (Object)ApiInvoker.serialize(body)) : ((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)ApiInvoker.serialize(body));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            return response.getEntity(String.class);
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), response.getEntity(String.class));
    }

    private Client getClient(String host) {
        if (!this.hostMap.containsKey(host)) {
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            clientConfig.getClasses().add(MultiPartWriter.class);
            Client client = Client.create(clientConfig);
            if (this.isDebug) {
                client.addFilter(new LoggingFilter());
            }
            this.hostMap.put(host, client);
        }
        return this.hostMap.get(host);
    }

    public void setCsrfToken(String csrfToken) {
        this.csrfToken = csrfToken;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setJSessionId(String jSessionId) {
        this.jSessionId = jSessionId;
    }
}

