/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.json.JSONArray;
import org.visallo.web.clientapi.ApiInvoker;
import org.visallo.web.clientapi.codegen.ApiException;
import org.visallo.web.clientapi.codegen.VertexApi;
import org.visallo.web.clientapi.model.ClientApiArtifactImportResponse;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiElementFindRelatedResponse;
import org.visallo.web.clientapi.model.ClientApiElementSearchResponse;
import org.visallo.web.clientapi.model.ClientApiVertexEdges;
import org.visallo.web.clientapi.util.FileUtils;
import org.visallo.web.clientapi.util.IOUtils;

public class VertexApiExt
extends VertexApi {
    public static final int VIDEO_TRANSCRIPT_INDEX_BITS = 12;
    public static final int VIDEO_TRANSCRIPT_OFFSET_BITS = 20;
    public static final String VERTEX_BASE_URL = "/vertex/";

    public ClientApiElement create(String conceptType, String visibilitySource, String justificationText) throws ApiException {
        return this.create(conceptType, visibilitySource, justificationText, null, null);
    }

    public void resolveTerm(String artifactId, String propertyKey, String propertyName, int mentionStart, int mentionEnd, String sign, String conceptId, String visibilitySource) throws ApiException {
        this.resolveTerm(artifactId, propertyKey, propertyName, mentionStart, mentionEnd, sign, conceptId, visibilitySource, null, null, null);
    }

    public void resolveVideoTranscriptTerm(String artifactId, String propertyKey, String propertyName, int videoFrameIndex, int mentionStart, int mentionEnd, String sign, String conceptId, String visibilitySource) throws ApiException {
        int mentionStartWithVideoFrame = videoFrameIndex << 20 | mentionStart;
        int mentionEndWithVideoFrame = videoFrameIndex << 20 | mentionEnd;
        this.resolveTerm(artifactId, propertyKey, propertyName, mentionStartWithVideoFrame, mentionEndWithVideoFrame, sign, conceptId, visibilitySource, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientApiArtifactImportResponse importFile(String visibilitySource, String fileName, InputStream data) throws ApiException, IOException {
        File tempDir = FileUtils.getTempDirectory();
        File file = new File(tempDir, fileName);
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                IOUtils.copy(data, out);
            }
            finally {
                out.close();
            }
            ClientApiArtifactImportResponse clientApiArtifactImportResponse = this.importFile(visibilitySource, file);
            return clientApiArtifactImportResponse;
        }
        finally {
            VertexApiExt.safeDelete(file);
        }
    }

    private static void safeDelete(File file) {
        if (!file.delete()) {
            throw new RuntimeException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    public ClientApiArtifactImportResponse importFiles(FileForImport ... files) throws ApiException, IOException {
        if (files == null || files.length == 0) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String path = "/vertex/import".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            HashMap<String, String> formParams = new HashMap<String, String>();
            String[] contentTypes = new String[]{"multipart/form-data"};
            String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
            FormDataMultiPart mp = new FormDataMultiPart();
            for (FileForImport fileForImport : files) {
                mp.field("visibilitySource", fileForImport.getVisibilitySource(), MediaType.MULTIPART_FORM_DATA_TYPE);
                FormDataContentDisposition dispo = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name("file").fileName(fileForImport.getFileName())).size(fileForImport.getFile().length())).build();
                FormDataBodyPart bodyPart = new FormDataBodyPart(dispo, (Object)fileForImport.getFile(), MediaType.MULTIPART_FORM_DATA_TYPE);
                mp.bodyPart(bodyPart);
            }
            FormDataMultiPart postBody = mp;
            try {
                String response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType);
                if (response != null) {
                    ClientApiArtifactImportResponse clientApiArtifactImportResponse = (ClientApiArtifactImportResponse)ApiInvoker.deserialize(response, "", ClientApiArtifactImportResponse.class);
                    return clientApiArtifactImportResponse;
                }
                ClientApiArtifactImportResponse clientApiArtifactImportResponse = null;
                return clientApiArtifactImportResponse;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    ClientApiArtifactImportResponse clientApiArtifactImportResponse = null;
                    return clientApiArtifactImportResponse;
                }
                throw ex;
            }
        }
        finally {
            for (FileForImport fileForImport : files) {
                fileForImport.deleteTempFiles();
            }
        }
    }

    public InputStream getRaw(String graphVertexId) throws IOException, ApiException {
        return this.getRaw(graphVertexId, true, false, null);
    }

    public InputStream getRawForPlayback(String graphVertexId, String type) throws IOException, ApiException {
        return this.getRaw(graphVertexId, false, true, type);
    }

    private InputStream getRaw(String graphVertexId, boolean download, boolean playback, String type) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        queryParams.put("graphVertexId", graphVertexId);
        if (download) {
            queryParams.put("download", "true");
        }
        if (playback) {
            queryParams.put("playback", "true");
        }
        if (type != null) {
            queryParams.put("type", type);
        }
        return this.apiInvoker.getBinary(this.basePath, "/vertex/raw", queryParams, headerParams);
    }

    public InputStream getThumbnail(String graphVertexId, Integer width) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        queryParams.put("graphVertexId", graphVertexId);
        if (width != null) {
            queryParams.put("width", width.toString());
        }
        return this.apiInvoker.getBinary(this.basePath, "/vertex/thumbnail", queryParams, headerParams);
    }

    public InputStream getPosterFrame(String graphVertexId, Integer width) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        queryParams.put("graphVertexId", graphVertexId);
        if (width != null) {
            queryParams.put("width", width.toString());
        }
        return this.apiInvoker.getBinary(this.basePath, "/vertex/poster-frame", queryParams, headerParams);
    }

    public InputStream getVideoPreview(String graphVertexId, Integer width) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        queryParams.put("graphVertexId", graphVertexId);
        if (width != null) {
            queryParams.put("width", width.toString());
        }
        return this.apiInvoker.getBinary(this.basePath, "/vertex/video-preview", queryParams, headerParams);
    }

    public ClientApiElementFindRelatedResponse findRelated(List<String> vertexIds) throws ApiException {
        return this.findRelated(vertexIds, null, null, null);
    }

    public ClientApiElementSearchResponse vertexSearch(String query) throws ApiException {
        JSONArray filters = new JSONArray();
        return this.vertexSearch(query, filters, null, null, null, null, null);
    }

    public ClientApiElementSearchResponse vertexSearch(String query, JSONArray filters, Integer offset, Integer size, String conceptType, Boolean includeChildNodes, List<String> relatedToVertexIds) throws ApiException {
        return this.vertexSearch(query, filters.toString(), offset, size, conceptType, includeChildNodes, relatedToVertexIds);
    }

    public ClientApiElement setProperty(String graphVertexId, String propertyKey, String propertyName, String value, String visibilitySource, String justificationText) throws ApiException {
        return this.setProperty(graphVertexId, propertyKey, propertyName, value, visibilitySource, justificationText, null, null);
    }

    public ClientApiVertexEdges getEdges(String graphVertexId) throws ApiException {
        return this.getEdges(graphVertexId, null, null, null);
    }

    public static class FileForImport {
        private final String visibilitySource;
        private final String fileName;
        private final InputStream data;
        private File file;

        public FileForImport(String visibilitySource, String fileName, InputStream data) {
            this.visibilitySource = visibilitySource;
            this.fileName = fileName;
            this.data = data;
        }

        public String getVisibilitySource() {
            return this.visibilitySource;
        }

        public String getFileName() {
            return this.fileName;
        }

        public File getFile() throws IOException {
            if (this.file == null) {
                File tempDir = FileUtils.getTempDirectory();
                this.file = new File(tempDir, this.getFileName());
                FileOutputStream out = new FileOutputStream(this.file);
                try {
                    IOUtils.copy(this.data, out);
                }
                finally {
                    out.close();
                }
            }
            return this.file;
        }

        public void deleteTempFiles() {
            if (this.file != null) {
                VertexApiExt.safeDelete(this.file);
            }
        }
    }
}

