/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.codegen;

import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.visallo.web.clientapi.ApiInvoker;
import org.visallo.web.clientapi.codegen.ApiException;
import org.visallo.web.clientapi.model.ClientApiEdgeWithVertexData;
import org.visallo.web.clientapi.model.ClientApiEdgesExistsResponse;
import org.visallo.web.clientapi.model.ClientApiElementAcl;
import org.visallo.web.clientapi.model.ClientApiHistoricalPropertyResults;

public class EdgeApi {
    protected String basePath = "http://visallo-dev:8889";
    protected ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ClientApiEdgeWithVertexData getByEdgeId(String graphEdgeId) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        if (graphEdgeId == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/edge/properties".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(graphEdgeId))) {
            queryParams.put("graphEdgeId", String.valueOf(graphEdgeId));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiEdgeWithVertexData)ApiInvoker.deserialize(response, "", ClientApiEdgeWithVertexData.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ClientApiHistoricalPropertyResults getPropertyHistory(String graphEdgeId, String propertyKey, String propertyName, Long startTime, Long endTime) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        if (graphEdgeId == null || propertyKey == null || propertyName == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/edge/property/history".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(graphEdgeId))) {
            queryParams.put("graphEdgeId", String.valueOf(graphEdgeId));
        }
        if (!"null".equals(String.valueOf(propertyKey))) {
            queryParams.put("propertyKey", String.valueOf(propertyKey));
        }
        if (!"null".equals(String.valueOf(propertyName))) {
            queryParams.put("propertyName", String.valueOf(propertyName));
        }
        if (!"null".equals(String.valueOf(startTime))) {
            queryParams.put("startTime", String.valueOf(startTime));
        }
        if (!"null".equals(String.valueOf(endTime))) {
            queryParams.put("endTime", String.valueOf(endTime));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiHistoricalPropertyResults)ApiInvoker.deserialize(response, "", ClientApiHistoricalPropertyResults.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ClientApiEdgeWithVertexData create(String outVertexId, String inVertexId, String predicateLabel, String visibilitySource, String justificationText, String sourceInfo, String edgeId) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        if (outVertexId == null || inVertexId == null || predicateLabel == null || visibilitySource == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/edge/create".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(outVertexId))) {
            queryParams.put("outVertexId", String.valueOf(outVertexId));
        }
        if (!"null".equals(String.valueOf(inVertexId))) {
            queryParams.put("inVertexId", String.valueOf(inVertexId));
        }
        if (!"null".equals(String.valueOf(predicateLabel))) {
            queryParams.put("predicateLabel", String.valueOf(predicateLabel));
        }
        if (!"null".equals(String.valueOf(visibilitySource))) {
            queryParams.put("visibilitySource", String.valueOf(visibilitySource));
        }
        if (!"null".equals(String.valueOf(justificationText))) {
            queryParams.put("justificationText", String.valueOf(justificationText));
        }
        if (!"null".equals(String.valueOf(sourceInfo))) {
            queryParams.put("sourceInfo", String.valueOf(sourceInfo));
        }
        if (!"null".equals(String.valueOf(edgeId))) {
            queryParams.put("edgeId", String.valueOf(edgeId));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiEdgeWithVertexData)ApiInvoker.deserialize(response, "", ClientApiEdgeWithVertexData.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public void setProperty(String edgeId, String propertyKey, String propertyName, String value, String visibilitySource, String justificationString, String sourceInfo, String metadata) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        if (edgeId == null || propertyKey == null || propertyName == null || value == null || visibilitySource == null || justificationString == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/edge/property".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(edgeId))) {
            queryParams.put("edgeId", String.valueOf(edgeId));
        }
        if (!"null".equals(String.valueOf(propertyKey))) {
            queryParams.put("propertyKey", String.valueOf(propertyKey));
        }
        if (!"null".equals(String.valueOf(propertyName))) {
            queryParams.put("propertyName", String.valueOf(propertyName));
        }
        if (!"null".equals(String.valueOf(value))) {
            queryParams.put("value", String.valueOf(value));
        }
        if (!"null".equals(String.valueOf(visibilitySource))) {
            queryParams.put("visibilitySource", String.valueOf(visibilitySource));
        }
        if (!"null".equals(String.valueOf(justificationString))) {
            queryParams.put("justificationString", String.valueOf(justificationString));
        }
        if (!"null".equals(String.valueOf(sourceInfo))) {
            queryParams.put("sourceInfo", String.valueOf(sourceInfo));
        }
        if (!"null".equals(String.valueOf(metadata))) {
            queryParams.put("metadata", String.valueOf(metadata));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return;
            }
            return;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return;
            }
            throw ex;
        }
    }

    public void deleteEdge(String edgeId) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        if (edgeId == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/edge".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(edgeId))) {
            queryParams.put("edgeId", String.valueOf(edgeId));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return;
            }
            return;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return;
            }
            throw ex;
        }
    }

    public ClientApiEdgesExistsResponse doExist(List<String> edgeIds) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = null;
        if (edgeIds == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/edge/exists".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            hasFields = true;
            if (edgeIds != null) {
                for (String edgeId : edgeIds) {
                    mp.field("edgeIds[]", edgeId, MediaType.MULTIPART_FORM_DATA_TYPE);
                }
            }
            if (hasFields && !mp.getFields().isEmpty()) {
                postBody = mp;
            }
        } else {
            throw new RuntimeException("invalid content type");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiEdgesExistsResponse)ApiInvoker.deserialize(response, "", ClientApiEdgesExistsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ClientApiElementAcl getAcl(String elementId) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        if (elementId == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/edge/acl".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(elementId))) {
            queryParams.put("elementId", String.valueOf(elementId));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiElementAcl)ApiInvoker.deserialize(response, "", ClientApiElementAcl.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

