/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.model;

import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.Date;

public enum PropertyType {
    DATE("date"),
    STRING("string"),
    GEO_LOCATION("geoLocation"),
    IMAGE("image"),
    BINARY("binary"),
    CURRENCY("currency"),
    DOUBLE("double"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    DIRECTORY_ENTITY("directory/entity");

    public static final String VERTEXIUM_TYPE_GEO_POINT = "org.vertexium.type.GeoPoint";
    private final String text;

    private PropertyType(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    @JsonValue
    public String getText() {
        return this.text;
    }

    public static PropertyType convert(String property) {
        for (PropertyType pt : PropertyType.values()) {
            if (!pt.toString().equalsIgnoreCase(property)) continue;
            return pt;
        }
        return STRING;
    }

    public static Class getTypeClass(PropertyType propertyType) {
        switch (propertyType) {
            case DATE: {
                return Date.class;
            }
            case STRING: 
            case DIRECTORY_ENTITY: {
                return String.class;
            }
            case GEO_LOCATION: {
                try {
                    return Class.forName(VERTEXIUM_TYPE_GEO_POINT);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not find class: org.vertexium.type.GeoPoint");
                }
            }
            case IMAGE: {
                return byte[].class;
            }
            case BINARY: {
                return byte[].class;
            }
            case CURRENCY: {
                return BigDecimal.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case INTEGER: {
                return Integer.class;
            }
        }
        throw new RuntimeException("Unhandled property type: " + (Object)((Object)propertyType));
    }
}

