/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.formula;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.formula.RequireJsSupport;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.util.ObjectMapperFactory;

public class FormulaEvaluator {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(FormulaEvaluator.class);
    public static final String CONFIGURATION_PARAMETER_MAX_THREADS = FormulaEvaluator.class.getName() + ".max.threads";
    public static final int CONFIGURATION_DEFAULT_MAX_THREADS = 1;
    private Configuration configuration;
    private OntologyRepository ontologyRepository;
    private ExecutorService executorService;
    private static final ThreadLocal<Map<String, Scriptable>> threadLocalScope = new ThreadLocal<Map<String, Scriptable>>(){

        @Override
        protected Map<String, Scriptable> initialValue() {
            return new HashMap<String, Scriptable>();
        }
    };

    @Inject
    public FormulaEvaluator(Configuration configuration, OntologyRepository ontologyRepository) {
        this.configuration = configuration;
        this.ontologyRepository = ontologyRepository;
        this.executorService = Executors.newFixedThreadPool(configuration.getInt(CONFIGURATION_PARAMETER_MAX_THREADS, 1));
    }

    public void close() {
        this.executorService.shutdown();
    }

    public String evaluateTitleFormula(Element element, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Title", element, null, null, userContext, authorizations);
    }

    public String evaluateTimeFormula(Element element, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Time", element, null, null, userContext, authorizations);
    }

    public String evaluateSubtitleFormula(Element element, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Subtitle", element, null, null, userContext, authorizations);
    }

    public String evaluatePropertyDisplayFormula(Element element, String propertyKey, String propertyName, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Property", element, propertyKey, propertyName, userContext, authorizations);
    }

    private String evaluateFormula(String type, Element element, String propertyKey, String propertyName, UserContext userContext, Authorizations authorizations) {
        FormulaEvaluatorCallable evaluationCallable = new FormulaEvaluatorCallable(type, element, propertyKey, propertyName, userContext, authorizations);
        try {
            return this.executorService.submit(evaluationCallable).get();
        }
        catch (InterruptedException e) {
            LOGGER.error(type + " evaluation interrupted", e);
        }
        catch (ExecutionException e) {
            LOGGER.error("Error encountered during " + type + " evaluation", e);
        }
        return "Unable to Evaluate " + type;
    }

    public Scriptable getScriptable(UserContext userContext) {
        String mapKey;
        Map<String, Scriptable> scopes = threadLocalScope.get();
        Scriptable scope = scopes.get(mapKey = userContext.locale.toString() + userContext.timeZone);
        if (scope == null) {
            scope = this.setupContext(this.getOntologyJson(), this.getConfigurationJson(userContext.locale), userContext.timeZone);
            scopes.put(mapKey, scope);
        }
        return scope;
    }

    private Scriptable setupContext(String ontologyJson, String configurationJson, String timeZone) {
        Context context = Context.enter();
        context.setLanguageVersion(160);
        RequireJsSupport browserSupport = new RequireJsSupport();
        ScriptableObject scope = context.initStandardObjects((ScriptableObject)browserSupport, true);
        try {
            scope.put("ONTOLOGY_JSON", (Scriptable)scope, (Object)Context.toObject((Object)ontologyJson, (Scriptable)scope));
            scope.put("CONFIG_JSON", (Scriptable)scope, (Object)Context.toObject((Object)configurationJson, (Scriptable)scope));
            scope.put("USERS_TIMEZONE", (Scriptable)scope, (Object)Context.toObject((Object)timeZone, (Scriptable)scope));
        }
        catch (Exception e) {
            throw new VisalloException("Json resource not available", e);
        }
        String[] names = new String[]{"print", "load", "consoleWarn", "consoleError", "readFully"};
        browserSupport.defineFunctionProperties(names, scope.getClass(), 2);
        Scriptable argsObj = context.newArray((Scriptable)scope, new Object[0]);
        scope.defineProperty("arguments", (Object)argsObj, 2);
        this.loadJavaScript(scope);
        scope.sealObject();
        return scope;
    }

    private void loadJavaScript(ScriptableObject scope) {
        this.evaluateFile(scope, "libs/underscore.js");
        this.evaluateFile(scope, "libs/r.js");
        this.evaluateFile(scope, "libs/windowTimers.js");
        this.evaluateFile(scope, "loader.js");
    }

    protected String getOntologyJson() {
        ClientApiOntology result = this.ontologyRepository.getClientApiObject();
        try {
            return ObjectMapperFactory.getInstance().writeValueAsString((Object)result);
        }
        catch (JsonProcessingException ex) {
            throw new VisalloException("Could not evaluate JSON: " + result, ex);
        }
    }

    protected String getConfigurationJson(Locale locale) {
        return this.configuration.toJSON(locale).toString();
    }

    private void evaluateFile(ScriptableObject scope, String filename) {
        LOGGER.debug("evaluating file: %s", filename);
        try (InputStream is = FormulaEvaluator.class.getResourceAsStream(filename);){
            if (is == null) {
                throw new VisalloException("File not found " + filename);
            }
            Context.getCurrentContext().evaluateString((Scriptable)scope, IOUtils.toString((InputStream)is), filename, 0, null);
        }
        catch (IOException ex) {
            throw new VisalloException("Could not read file: " + filename, ex);
        }
    }

    protected String toJson(Element element, String workspaceId, Authorizations authorizations) {
        ClientApiElement v = ClientApiConverter.toClientApi(element, workspaceId, authorizations);
        return v.toString();
    }

    private class FormulaEvaluatorCallable
    implements Callable<String> {
        private final String propertyKey;
        private final String propertyName;
        private UserContext userContext;
        private String fieldName;
        private Element element;
        private Authorizations authorizations;

        public FormulaEvaluatorCallable(String fieldName, Element element, String propertyKey, String propertyName, UserContext userContext, Authorizations authorizations) {
            this.fieldName = fieldName;
            this.element = element;
            this.propertyKey = propertyKey;
            this.propertyName = propertyName;
            this.userContext = userContext;
            this.authorizations = authorizations;
        }

        @Override
        public String call() throws Exception {
            Scriptable scope = FormulaEvaluator.this.getScriptable(this.userContext);
            String json = FormulaEvaluator.this.toJson(this.element, this.userContext.getWorkspaceId(), this.authorizations);
            Function function = (Function)scope.get("evaluate" + this.fieldName + "FormulaJson", scope);
            Object result = function.call(Context.getCurrentContext(), scope, scope, new Object[]{json, this.propertyKey, this.propertyName});
            return (String)Context.jsToJava((Object)result, String.class);
        }
    }

    public static class UserContext {
        private final Locale locale;
        private final String timeZone;
        private final String workspaceId;

        public UserContext(Locale locale, String timeZone, String workspaceId) {
            this.locale = locale == null ? Locale.getDefault() : locale;
            this.timeZone = timeZone;
            this.workspaceId = workspaceId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getWorkspaceId() {
            return this.workspaceId;
        }
    }
}

