/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.config.Configuration;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkData;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerPrepareData;
import org.visallo.core.ingest.graphProperty.TermMentionFilter;
import org.visallo.core.ingest.graphProperty.VerifyResults;
import org.visallo.core.ingest.video.VideoTranscript;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.properties.types.VisalloPropertyUpdate;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class GraphPropertyWorker {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphPropertyWorker.class);
    private Graph graph;
    private VisibilityTranslator visibilityTranslator;
    private WorkQueueRepository workQueueRepository;
    private OntologyRepository ontologyRepository;
    private AuthorizationRepository authorizationRepository;
    private GraphPropertyWorkerPrepareData workerPrepareData;
    private Configuration configuration;
    private WorkspaceRepository workspaceRepository;
    private GraphRepository graphRepository;

    public VerifyResults verify() {
        return new VerifyResults();
    }

    public void prepare(GraphPropertyWorkerPrepareData workerPrepareData) throws Exception {
        this.workerPrepareData = workerPrepareData;
    }

    protected void applyTermMentionFilters(Vertex outVertex, Iterable<Vertex> termMentions) {
        for (TermMentionFilter termMentionFilter : this.workerPrepareData.getTermMentionFilters()) {
            try {
                termMentionFilter.apply(outVertex, termMentions, this.workerPrepareData.getAuthorizations());
            }
            catch (Exception e) {
                LOGGER.error("Could not apply term mention filter", e);
            }
        }
        this.getGraph().flush();
    }

    protected void pushTextUpdated(GraphPropertyWorkData data) {
        if (data == null || data.getElement() == null) {
            return;
        }
        this.getWorkQueueRepository().pushTextUpdated(data.getElement().getId(), data.getPriority());
    }

    public abstract boolean isHandled(Element var1, Property var2);

    public boolean isDeleteHandled(Element element, Property property) {
        return false;
    }

    public boolean isHiddenHandled(Element element, Property property) {
        return false;
    }

    public boolean isUnhiddenHandled(Element element, Property property) {
        return false;
    }

    public abstract void execute(InputStream var1, GraphPropertyWorkData var2) throws Exception;

    public boolean isLocalFileRequired() {
        return false;
    }

    protected User getUser() {
        return this.workerPrepareData.getUser();
    }

    public Authorizations getAuthorizations() {
        return this.workerPrepareData.getAuthorizations();
    }

    @Inject
    public final void setGraph(Graph graph) {
        this.graph = graph;
    }

    protected Graph getGraph() {
        return this.graph;
    }

    @Inject
    public final void setWorkQueueRepository(WorkQueueRepository workQueueRepository) {
        this.workQueueRepository = workQueueRepository;
    }

    @Inject
    public final void setWorkspaceRepository(WorkspaceRepository workspaceRepository) {
        this.workspaceRepository = workspaceRepository;
    }

    protected WorkspaceRepository getWorkspaceRepository() {
        return this.workspaceRepository;
    }

    protected WorkQueueRepository getWorkQueueRepository() {
        return this.workQueueRepository;
    }

    protected OntologyRepository getOntologyRepository() {
        return this.ontologyRepository;
    }

    @Inject
    public final void setOntologyRepository(OntologyRepository ontologyRepository) {
        this.ontologyRepository = ontologyRepository;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Inject
    public final void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected VisibilityTranslator getVisibilityTranslator() {
        return this.visibilityTranslator;
    }

    @Inject
    public final void setVisibilityTranslator(VisibilityTranslator visibilityTranslator) {
        this.visibilityTranslator = visibilityTranslator;
    }

    @Inject
    public final void setAuthorizationRepository(AuthorizationRepository authorizationRepository) {
        this.authorizationRepository = authorizationRepository;
    }

    protected AuthorizationRepository getAuthorizationRepository() {
        return this.authorizationRepository;
    }

    public GraphRepository getGraphRepository() {
        return this.graphRepository;
    }

    @Inject
    public final void setGraphRepository(GraphRepository graphRepository) {
        this.graphRepository = graphRepository;
    }

    protected boolean isTextProperty(Property property) {
        if (property == null) {
            return false;
        }
        if (property.getName().equals(VisalloProperties.RAW.getPropertyName())) {
            return false;
        }
        String mimeType = (String)property.getMetadata().getValue(VisalloProperties.MIME_TYPE.getPropertyName());
        return mimeType != null && mimeType.startsWith("text");
    }

    protected static boolean isVertex(Element element) {
        return element instanceof Vertex;
    }

    protected static boolean isConceptType(Element element, String conceptType) {
        String elementConceptType = (String)VisalloProperties.CONCEPT_TYPE.getPropertyValue(element);
        if (elementConceptType == null) {
            return false;
        }
        return elementConceptType.equals(conceptType);
    }

    protected void addVideoTranscriptAsTextPropertiesToMutation(ExistingElementMutation<Vertex> mutation, String propertyKey, VideoTranscript videoTranscript, Metadata metadata, Visibility visibility) {
        VisalloProperties.MIME_TYPE_METADATA.setMetadata(metadata, "text/plain", this.getVisibilityTranslator().getDefaultVisibility());
        for (VideoTranscript.TimedText entry : videoTranscript.getEntries()) {
            String textPropertyKey = this.getVideoTranscriptTimedTextPropertyKey(propertyKey, entry);
            StreamingPropertyValue value = new StreamingPropertyValue((InputStream)new ByteArrayInputStream(entry.getText().getBytes()), String.class);
            VisalloProperties.TEXT.addPropertyValue((ElementMutation<?>)mutation, textPropertyKey, value, metadata, visibility);
        }
    }

    protected void pushVideoTranscriptTextPropertiesOnWorkQueue(Element element, String propertyKey, VideoTranscript videoTranscript, Priority priority) {
        for (VideoTranscript.TimedText entry : videoTranscript.getEntries()) {
            String textPropertyKey = this.getVideoTranscriptTimedTextPropertyKey(propertyKey, entry);
            this.getWorkQueueRepository().pushGraphPropertyQueue(element, textPropertyKey, VisalloProperties.TEXT.getPropertyName(), priority);
        }
    }

    private String getVideoTranscriptTimedTextPropertyKey(String propertyKey, VideoTranscript.TimedText entry) {
        String startTime = String.format("%08d", Math.max(0L, entry.getTime().getStart()));
        String endTime = String.format("%08d", Math.max(0L, entry.getTime().getEnd()));
        return propertyKey + '\u001e' + MediaVisalloProperties.VIDEO_FRAME.getPropertyName() + '\u001e' + startTime + '\u001e' + endTime;
    }

    protected void addVertexToWorkspaceIfNeeded(GraphPropertyWorkData data, Vertex vertex) {
        if (data.getWorkspaceId() == null) {
            return;
        }
        this.graph.flush();
        this.getWorkspaceRepository().updateEntityOnWorkspace(data.getWorkspaceId(), vertex.getId(), (Boolean)false, null, this.getUser());
    }

    protected void pushChangedPropertiesOnWorkQueue(GraphPropertyWorkData data, List<VisalloPropertyUpdate> changedProperties) {
        this.getWorkQueueRepository().pushGraphVisalloPropertyQueue(data.getElement(), changedProperties, data.getWorkspaceId(), data.getVisibilitySource(), data.getPriority());
    }
}

