/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.graph;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class GraphReindexService {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphReindexService.class);
    private final GraphBaseWithSearchIndex graph;

    @Inject
    public GraphReindexService(Graph graph) {
        if (!(graph instanceof GraphBaseWithSearchIndex)) {
            throw new VisalloException("Reindex plugin cannot be enabled when the graph does not implement " + GraphBaseWithSearchIndex.class.getName());
        }
        this.graph = (GraphBaseWithSearchIndex)graph;
    }

    public void reindexVertices(int batchSize, Authorizations authorizations) {
        Iterable vertices = this.graph.getVertices(authorizations);
        this.reindexVertices(vertices, batchSize, authorizations);
    }

    public void reindexVertices(Iterable<Vertex> vertices, int batchSize, Authorizations authorizations) {
        long count = 0L;
        ArrayList<Element> batch = new ArrayList<Element>(batchSize);
        for (Vertex vertex : vertices) {
            batch.add((Element)vertex);
            if (batch.size() == batchSize) {
                this.submitBatchOfElementsToSearchIndex(ElementType.VERTEX, count, batch, authorizations);
            }
            ++count;
        }
        if (batch.size() > 0) {
            this.submitBatchOfElementsToSearchIndex(ElementType.VERTEX, count, batch, authorizations);
        }
    }

    public void reindexEdges(int batchSize, Authorizations authorizations) {
        Iterable edges = this.graph.getEdges(authorizations);
        this.reindexEdges(edges, batchSize, authorizations);
    }

    public void reindexEdges(Iterable<Edge> edges, int batchSize, Authorizations authorizations) {
        long count = 0L;
        ArrayList<Element> batch = new ArrayList<Element>(batchSize);
        for (Edge edge : edges) {
            batch.add((Element)edge);
            if (batch.size() == batchSize) {
                this.submitBatchOfElementsToSearchIndex(ElementType.EDGE, count, batch, authorizations);
            }
            ++count;
        }
        if (batch.size() > 0) {
            this.submitBatchOfElementsToSearchIndex(ElementType.EDGE, count, batch, authorizations);
        }
    }

    private void submitBatchOfElementsToSearchIndex(ElementType elementType, long endIndex, List<Element> batch, Authorizations authorizations) {
        LOGGER.debug("indexing %s %d-%d", elementType, endIndex - (long)batch.size(), endIndex);
        this.graph.getSearchIndex().addElements((Graph)this.graph, batch, authorizations);
        batch.clear();
    }
}

