/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.visallo.core.model.user.AuthorizationContext;
import org.visallo.core.model.user.AuthorizationMapper;
import org.visallo.core.model.user.UserRepository;

public class DefaultAuthorizationMapper
extends AuthorizationMapper {
    private final UserRepository userRepository;

    @Inject
    public DefaultAuthorizationMapper(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public Set<String> getPrivileges(AuthorizationContext authorizationContext) {
        if (authorizationContext.isNewUser()) {
            return this.userRepository.getDefaultPrivileges();
        }
        return authorizationContext.getExistingUser().getPrivileges();
    }

    @Override
    public Set<String> getAuthorizations(AuthorizationContext authorizationContext) {
        if (authorizationContext.isNewUser()) {
            return this.userRepository.getDefaultAuthorizations();
        }
        return Sets.newHashSet((Object[])this.userRepository.getAuthorizations(authorizationContext.getExistingUser(), new String[0]).getAuthorizations());
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

