/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.v5analytics.simpleorm.SimpleOrmContext;
import com.v5analytics.simpleorm.SimpleOrmSession;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.util.IterableUtils;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRepository;
import org.visallo.core.model.notification.ExpirationAge;
import org.visallo.core.model.notification.UserNotification;
import org.visallo.core.model.notification.UserNotificationRepository;
import org.visallo.core.model.user.UserListener;
import org.visallo.core.model.user.UserPasswordUtil;
import org.visallo.core.model.user.UserSessionCounterRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.user.SystemUser;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.JSONUtil;
import org.visallo.web.clientapi.model.ClientApiUser;
import org.visallo.web.clientapi.model.ClientApiUsers;
import org.visallo.web.clientapi.model.Privilege;
import org.visallo.web.clientapi.model.UserStatus;

public abstract class UserRepository {
    public static final String GRAPH_USER_ID_PREFIX = "USER_";
    public static final String VISIBILITY_STRING = "user";
    public static final VisalloVisibility VISIBILITY = new VisalloVisibility("user");
    public static final String OWL_IRI = "http://visallo.org/user";
    public static final String USER_CONCEPT_IRI = "http://visallo.org/user#user";
    private final Set<String> defaultPrivileges;
    private final Set<String> defaultAuthorizations;
    private final SimpleOrmSession simpleOrmSession;
    private final UserSessionCounterRepository userSessionCounterRepository;
    private final WorkQueueRepository workQueueRepository;
    private final UserNotificationRepository userNotificationRepository;
    private final LockRepository lockRepository;
    private final Configuration configuration;
    private LongRunningProcessRepository longRunningProcessRepository;
    private Collection<UserListener> userListeners;

    protected UserRepository(Configuration configuration, SimpleOrmSession simpleOrmSession, UserSessionCounterRepository userSessionCounterRepository, WorkQueueRepository workQueueRepository, UserNotificationRepository userNotificationRepository, LockRepository lockRepository) {
        this.configuration = configuration;
        this.simpleOrmSession = simpleOrmSession;
        this.userSessionCounterRepository = userSessionCounterRepository;
        this.workQueueRepository = workQueueRepository;
        this.userNotificationRepository = userNotificationRepository;
        this.lockRepository = lockRepository;
        this.defaultPrivileges = Privilege.stringToPrivileges((String)configuration.get("newuser.privileges", ""));
        this.defaultAuthorizations = this.parseAuthorizations(configuration.get("newuser.authorizations", ""));
    }

    private Set<String> parseAuthorizations(String authorizations) {
        return Sets.newHashSet((Object[])authorizations.split(","));
    }

    public abstract User findByUsername(String var1);

    public abstract Iterable<User> find(int var1, int var2);

    public Iterable<User> findByStatus(int skip, int limit, UserStatus status) {
        List allUsers = IterableUtils.toList(this.find(skip, limit));
        ArrayList<User> matchingUsers = new ArrayList<User>();
        for (User user : allUsers) {
            if (user.getUserStatus() != status) continue;
            matchingUsers.add(user);
        }
        return matchingUsers;
    }

    public abstract User findById(String var1);

    protected abstract User addUser(String var1, String var2, String var3, String var4, Set<String> var5, Set<String> var6);

    public void setPassword(User user, String password) {
        byte[] salt = UserPasswordUtil.getSalt();
        byte[] passwordHash = UserPasswordUtil.hashPassword(password, salt);
        this.setPassword(user, salt, passwordHash);
    }

    public abstract void setPassword(User var1, byte[] var2, byte[] var3);

    public abstract boolean isPasswordValid(User var1, String var2);

    public abstract void recordLogin(User var1, String var2);

    public abstract User setCurrentWorkspace(String var1, String var2);

    public abstract String getCurrentWorkspaceId(String var1);

    public abstract User setStatus(String var1, UserStatus var2);

    public void addAuthorization(User user, String auth, User authUser) {
        this.internalAddAuthorization(user, auth, authUser);
        this.sendNotificationToUserAboutAddAuthorization(user, auth, authUser);
        this.fireUserAddAuthorizationEvent(user, auth);
    }

    private void sendNotificationToUserAboutAddAuthorization(User user, String auth, User authUser) {
        String title = "Authorization Added";
        String message = "Authorization Added: " + auth;
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.workQueueRepository.pushUserNotification(userNotification);
    }

    protected abstract void internalAddAuthorization(User var1, String var2, User var3);

    public void removeAuthorization(User user, String auth, User authUser) {
        this.internalRemoveAuthorization(user, auth, authUser);
        this.sendNotificationToUserAboutRemoveAuthorization(user, auth, authUser);
        this.fireUserRemoveAuthorizationEvent(user, auth);
    }

    private void sendNotificationToUserAboutRemoveAuthorization(User user, String auth, User authUser) {
        String title = "Authorization Removed";
        String message = "Authorization Removed: " + auth;
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.workQueueRepository.pushUserNotification(userNotification);
    }

    protected abstract void internalRemoveAuthorization(User var1, String var2, User var3);

    public abstract Authorizations getAuthorizations(User var1, String ... var2);

    public abstract void setDisplayName(User var1, String var2);

    public abstract void setEmailAddress(User var1, String var2);

    public abstract void setUiPreferences(User var1, JSONObject var2);

    public JSONObject toJsonWithAuths(User user) {
        JSONObject json = UserRepository.toJson(user);
        JSONArray authorizations = new JSONArray();
        for (String a : this.getAuthorizations(user, new String[0]).getAuthorizations()) {
            authorizations.put((Object)a);
        }
        json.put("authorizations", (Object)authorizations);
        json.put("uiPreferences", (Object)user.getUiPreferences());
        Set<String> privileges = user.getPrivileges();
        json.put("privileges", (Object)Privilege.toJson(privileges));
        return json;
    }

    public ClientApiUser toClientApiPrivate(User user) {
        ClientApiUser u = this.toClientApi(user);
        for (String a : this.getAuthorizations(user, new String[0]).getAuthorizations()) {
            u.addAuthorization(a);
        }
        for (JSONObject json : this.getLongRunningProcesses(user)) {
            u.getLongRunningProcesses().add(ClientApiConverter.toClientApiValue((JSONObject)json));
        }
        u.setUiPreferences(JSONUtil.toJsonNode(user.getUiPreferences()));
        u.getProperties().putAll(user.getCustomProperties());
        Set<String> privileges = user.getPrivileges();
        u.getPrivileges().addAll(privileges);
        return u;
    }

    private List<JSONObject> getLongRunningProcesses(User user) {
        return this.getLongRunningProcessRepository().getLongRunningProcesses(user);
    }

    private LongRunningProcessRepository getLongRunningProcessRepository() {
        if (this.longRunningProcessRepository == null) {
            this.longRunningProcessRepository = InjectHelper.getInstance(LongRunningProcessRepository.class);
        }
        return this.longRunningProcessRepository;
    }

    private ClientApiUser toClientApi(User user) {
        return this.toClientApi(user, null);
    }

    private ClientApiUser toClientApi(User user, Map<String, String> workspaceNames) {
        ClientApiUser u = new ClientApiUser();
        u.setId(user.getUserId());
        u.setUserName(user.getUsername());
        u.setDisplayName(user.getDisplayName());
        u.setStatus(user.getUserStatus());
        u.setUserType(user.getUserType());
        u.setEmail(user.getEmailAddress());
        u.setCurrentWorkspaceId(user.getCurrentWorkspaceId());
        u.getProperties().putAll(user.getCustomProperties());
        if (workspaceNames != null) {
            String workspaceName = workspaceNames.get(user.getCurrentWorkspaceId());
            u.setCurrentWorkspaceName(workspaceName);
        }
        return u;
    }

    protected String formatUsername(String username) {
        return username.trim().toLowerCase();
    }

    public ClientApiUsers toClientApi(Iterable<User> users, Map<String, String> workspaceNames) {
        ClientApiUsers clientApiUsers = new ClientApiUsers();
        for (User user : users) {
            clientApiUsers.getUsers().add(this.toClientApi(user, workspaceNames));
        }
        return clientApiUsers;
    }

    public static JSONObject toJson(User user) {
        return UserRepository.toJson(user, null);
    }

    public static JSONObject toJson(User user, Map<String, String> workspaceNames) {
        try {
            JSONObject json = new JSONObject();
            json.put("id", (Object)user.getUserId());
            json.put("userName", (Object)user.getUsername());
            json.put("displayName", (Object)user.getDisplayName());
            json.put("status", (Object)user.getUserStatus());
            json.put("userType", (Object)user.getUserType());
            json.put("email", (Object)user.getEmailAddress());
            json.put("currentWorkspaceId", (Object)user.getCurrentWorkspaceId());
            if (workspaceNames != null) {
                String workspaceName = workspaceNames.get(user.getCurrentWorkspaceId());
                json.put("currentWorkspaceName", (Object)workspaceName);
            }
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleOrmContext getSimpleOrmContext(User user) {
        String[] authorizations = this.getAuthorizations(user, new String[0]).getAuthorizations();
        return this.getSimpleOrmContext(authorizations);
    }

    public SimpleOrmContext getSimpleOrmContext(Authorizations authorizations, String ... additionalAuthorizations) {
        ArrayList<String> auths = new ArrayList<String>();
        if (authorizations.getAuthorizations() != null) {
            for (String a : authorizations.getAuthorizations()) {
                if (a == null || a.length() <= 0) continue;
                auths.add(a);
            }
        }
        if (additionalAuthorizations != null) {
            for (String a : additionalAuthorizations) {
                if (a == null || a.length() <= 0) continue;
                auths.add(a);
            }
        }
        return this.getSimpleOrmContext(auths.toArray(new String[auths.size()]));
    }

    public SimpleOrmContext getSimpleOrmContext(String ... authorizations) {
        return this.simpleOrmSession.createContext(authorizations);
    }

    public User getSystemUser() {
        return new SystemUser();
    }

    public User findOrAddUser(final String username, final String displayName, final String emailAddress, final String password, final Set<String> privileges, final Set<String> userAuthorizations) {
        return this.lockRepository.lock("findOrAddUser", new Callable<User>(){

            @Override
            public User call() throws Exception {
                User user = UserRepository.this.findByUsername(username);
                if (user == null) {
                    user = UserRepository.this.addUser(username, displayName, emailAddress, password, privileges, userAuthorizations);
                }
                return user;
            }
        });
    }

    public Set<String> getDefaultPrivileges() {
        return this.defaultPrivileges;
    }

    public Set<String> getDefaultAuthorizations() {
        return this.defaultAuthorizations;
    }

    public final void delete(User user) {
        this.internalDelete(user);
        this.userSessionCounterRepository.deleteSessions(user.getUserId());
        this.workQueueRepository.pushUserStatusChange(user, UserStatus.OFFLINE);
        this.fireUserDeletedEvent(user);
    }

    protected abstract void internalDelete(User var1);

    public final void setPrivileges(User user, Set<String> privileges, User authUser) {
        if (!privileges.equals(user.getPrivileges())) {
            this.internalSetPrivileges(user, privileges, authUser);
            this.sendNotificationToUserAboutPrivilegeChange(user, privileges, authUser);
            this.fireUserPrivilegesUpdatedEvent(user, privileges);
        }
    }

    public void setAuthorizations(User user, Set<String> authorizations, User authUser) {
        ImmutableSet currentAuthorizations = ImmutableSet.copyOf((Object[])this.getAuthorizations(user, new String[0]).getAuthorizations());
        if (!authorizations.equals(currentAuthorizations)) {
            HashSet toRemoveAuthorizations = new HashSet(currentAuthorizations);
            for (String auth : authorizations) {
                if (currentAuthorizations.contains((Object)auth)) {
                    toRemoveAuthorizations.remove(auth);
                    continue;
                }
                this.addAuthorization(user, auth, authUser);
            }
            for (String auth : toRemoveAuthorizations) {
                this.removeAuthorization(user, auth, authUser);
            }
        }
    }

    private void sendNotificationToUserAboutPrivilegeChange(User user, Set<String> privileges, User authUser) {
        String title = "Privileges Changed";
        String message = "New Privileges: " + Joiner.on((String)", ").join(privileges);
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.workQueueRepository.pushUserNotification(userNotification);
    }

    protected abstract void internalSetPrivileges(User var1, Set<String> var2, User var3);

    public Iterable<User> find(String query) {
        List users;
        String lowerCaseQuery = query == null ? null : query.toLowerCase();
        int skip = 0;
        int limit = 100;
        ArrayList<User> foundUsers = new ArrayList<User>();
        while ((users = IterableUtils.toList(this.find(skip, limit))).size() != 0) {
            for (User user : users) {
                if (lowerCaseQuery != null && !user.getDisplayName().toLowerCase().contains(lowerCaseQuery)) continue;
                foundUsers.add(user);
            }
            skip += limit;
        }
        return foundUsers;
    }

    public static String createRandomPassword() {
        return new BigInteger(120, new SecureRandom()).toString(32);
    }

    public abstract User findByPasswordResetToken(String var1);

    public abstract void setPasswordResetTokenAndExpirationDate(User var1, String var2, Date var3);

    public abstract void clearPasswordResetTokenAndExpirationDate(User var1);

    protected void afterNewUserAdded(User newUser) {
        this.fireNewUserAddedEvent(newUser);
    }

    private void fireNewUserAddedEvent(User user) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.newUserAdded(user);
        }
    }

    private void fireUserDeletedEvent(User user) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userDeleted(user);
        }
    }

    private void fireUserPrivilegesUpdatedEvent(User user, Set<String> privileges) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userPrivilegesUpdated(user, privileges);
        }
    }

    private void fireUserAddAuthorizationEvent(User user, String auth) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userAddAuthorization(user, auth);
        }
    }

    private void fireUserRemoveAuthorizationEvent(User user, String auth) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userRemoveAuthorization(user, auth);
        }
    }

    protected void fireUserLoginEvent(User user, String remoteAddr) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userLogin(user, remoteAddr);
        }
    }

    protected void fireUserStatusChangeEvent(User user, UserStatus status) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userStatusChange(user, status);
        }
    }

    private Iterable<UserListener> getUserListeners() {
        if (this.userListeners == null) {
            this.userListeners = InjectHelper.getInjectedServices(UserListener.class, this.configuration);
        }
        return this.userListeners;
    }

    public abstract void setPropertyOnUser(User var1, String var2, Object var3);
}

