/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.status;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.visallo.core.status.StatusData;
import org.visallo.core.status.StatusRepository;

public class InMemoryStatusRepository
implements StatusRepository {
    private Table<String, String, StatusData> instances = HashBasedTable.create();

    @Override
    public StatusRepository.StatusHandle saveStatus(String group, String instance, StatusData statusData) {
        this.instances.put((Object)group, (Object)instance, (Object)statusData);
        return new StatusRepository.StatusHandle(group, instance);
    }

    @Override
    public void deleteStatus(StatusRepository.StatusHandle statusHandle) {
        this.instances.remove((Object)statusHandle.getGroup(), (Object)statusHandle.getInstance());
    }

    @Override
    public Iterable<String> getGroups() {
        return this.instances.rowKeySet();
    }

    @Override
    public Iterable<String> getInstances(String group) {
        return this.instances.row((Object)group).keySet();
    }

    @Override
    public StatusData getStatusData(String group, String instance) {
        return (StatusData)this.instances.get((Object)group, (Object)instance);
    }
}

